# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['zdpapi_mysql', 'zdpapi_mysql.pymysql', 'zdpapi_mysql.pymysql.constants']

package_data = \
{'': ['*']}

setup_kwargs = {
    'name': 'zdpapi-mysql',
    'version': '1.0.1',
    'description': '基于异步的快速操作MySQL的组件',
    'long_description': '# zapi_mysql\n基于异步的快速操作MySQL的组件\n\n项目地址： https://github.com/zhangdapeng520/zdpapi_mysql\n\n使用pip安装\n```shell\npip install zapi_mysql\n```\n\n## 一、增删改数据\n\n### 1.1 创建表\n```python\nimport asyncio\nfrom zapi_mysql import Mysql\ndb = Mysql(host=\'127.0.0.1\',\n           port=3306,\n           user=\'root\',\n           password=\'root\',\n           db=\'test\')\n\n\nasync def test_example_execute(loop):\n    # 删除表\n    await db.connect()\n    sql = "DROP TABLE IF EXISTS user;"\n    \n    # 创建表\n    await db.execute(sql)\n    sql = """CREATE TABLE user\n                                  (id INT,\n                                  name VARCHAR(255),\n                                  PRIMARY KEY (id));"""\n    await db.execute(sql)\n    \n    # 插入SQL语句\n    sql = "INSERT INTO user VALUES(1,\'张三\')"\n    await db.execute(sql)\n\n\nloop = asyncio.get_event_loop()\nloop.run_until_complete(test_example_execute(loop))\n```\n\n### 1.2 插入数据\n```python\nimport asyncio\nfrom zapi_mysql import Mysql\ndb = Mysql(host=\'127.0.0.1\',\n           port=3306,\n           user=\'root\',\n           password=\'root\',\n           db=\'test\')\n\n\nasync def test_example_execute(loop):\n    # 插入SQL语句\n    sql = "INSERT INTO user VALUES(2,\'李四\')"\n    await db.execute(sql)\n\n\nloop = asyncio.get_event_loop()\nloop.run_until_complete(test_example_execute(loop))\n```\n\n### 1.3 批量插入数据\n```python\nimport asyncio\nfrom zapi_mysql import Mysql\ndb = Mysql(host=\'127.0.0.1\',\n           port=3306,\n           user=\'root\',\n           password=\'root\',\n           db=\'test\')\n\n\nasync def test_example_execute(loop):\n    # 插入SQL语句\n    data = [(4, \'gothic metal\'), (5, \'doom metal\'), (6, \'post metal\')]\n    sql = "INSERT INTO user VALUES(%s,%s)"\n    await db.execute(sql, data=data)\n\n\nloop = asyncio.get_event_loop()\nloop.run_until_complete(test_example_execute(loop))\n```\n\n## 二、查询数据\n\n### 2.1 查询所有数据\n```python\nimport asyncio\nfrom zapi_mysql import Mysql\ndb = Mysql(host=\'127.0.0.1\',\n           port=3306,\n           user=\'root\',\n           password=\'root\',\n           db=\'test\')\n\n\nasync def test_example_execute(loop):\n    # 插入SQL语句\n    sql = "SELECT id, name FROM user ORDER BY id"\n    result = await db.execute(sql)\n    print("查询结果：\\n", result)\n\n\nloop = asyncio.get_event_loop()\nloop.run_until_complete(test_example_execute(loop))\n```\n\n### 2.2 查询单条数据\n```python\nimport asyncio\nfrom zapi_mysql import Mysql\ndb = Mysql(host=\'127.0.0.1\',\n           port=3306,\n           user=\'root\',\n           password=\'root\',\n           db=\'test\')\n\n\nasync def test_example_execute(loop):\n    # 查询单条数据\n    sql = "SELECT id, name FROM user ORDER BY id"\n    result = await db.execute(sql, return_all=False)\n    print("查询结果：\\n", result)\n\n\nloop = asyncio.get_event_loop()\nloop.run_until_complete(test_example_execute(loop))\n```\n\n## 三、CRUD快捷工具\n\n### 3.1 新增用户\n```python\nimport asyncio\nfrom zdpapi_mysql import Mysql, Crud\ndb = Mysql(host=\'127.0.0.1\',\n           port=3306,\n           user=\'root\',\n           password=\'root\',\n           db=\'test\')\n\ncrud = Crud(db, "user", ["name"])\n\nasync def test_create_table(loop):\n    # 删除表\n    await db.connect()\n    sql = "DROP TABLE IF EXISTS user;"\n\n    # 创建表\n    await db.execute(sql)\n    sql = """CREATE TABLE user(id INT PRIMARY KEY AUTO_INCREMENT, name VARCHAR(255));"""\n    await db.execute(sql)\n\n    # 插入SQL语句\n    sql = "INSERT INTO user VALUES(1,\'张三\')"\n    await db.execute(sql)\n\n\nasync def test_insert(loop):\n    # 插入SQL语句\n    await crud.add("李四")\n    await crud.add("王五")\n    await crud.add("赵六")\n\n\nif __name__ == "__main__":\n    loop = asyncio.get_event_loop()\n    loop.run_until_complete(test_create_table(loop))\n    loop.run_until_complete(test_insert(loop))\n\n```\n\n### 3.2 添加多条数据\n```python\nimport asyncio\nfrom zdpapi_mysql import Mysql, Crud\ndb = Mysql(host=\'127.0.0.1\',\n           port=3306,\n           user=\'root\',\n           password=\'root\',\n           db=\'test\')\n\ncrud = Crud(db, "user", ["name"])\n\nasync def test_create_table(loop):\n    # 删除表\n    await db.connect()\n    sql = "DROP TABLE IF EXISTS user;"\n\n    # 创建表\n    await db.execute(sql)\n    sql = """CREATE TABLE user(id INT PRIMARY KEY AUTO_INCREMENT, name VARCHAR(255));"""\n    await db.execute(sql)\n\n    # 插入SQL语句\n    sql = "INSERT INTO user VALUES(1,\'张三\')"\n    await db.execute(sql)\n\n\nasync def test_insert(loop):\n    # 插入SQL语句\n    await crud.add("李四")\n    await crud.add("王五")\n    await crud.add("赵六")\n\n\nasync def test_insert_many(loop):\n    # 插入SQL语句\n    data = [("孙悟空",), ("猪八戒",), ("沙僧",), ]\n    await crud.add_many(data)\n    \n\nif __name__ == "__main__":\n    loop = asyncio.get_event_loop()\n    loop.run_until_complete(test_create_table(loop))\n    loop.run_until_complete(test_insert(loop))\n    loop.run_until_complete(test_insert_many(loop))\n\n```\n\n### 3.3 根据ID删除数据\n```python\nimport asyncio\nfrom zdpapi_mysql import Mysql, Crud\ndb = Mysql(host=\'127.0.0.1\',\n           port=3306,\n           user=\'root\',\n           password=\'root\',\n           db=\'test\')\n\ncrud = Crud(db, "user", ["name"])\n\nasync def test_create_table(loop):\n    # 删除表\n    await db.connect()\n    sql = "DROP TABLE IF EXISTS user;"\n\n    # 创建表\n    await db.execute(sql)\n    sql = """CREATE TABLE user(id INT PRIMARY KEY AUTO_INCREMENT, name VARCHAR(255));"""\n    await db.execute(sql)\n\n    # 插入SQL语句\n    sql = "INSERT INTO user VALUES(1,\'张三\')"\n    await db.execute(sql)\n\n\nasync def test_insert(loop):\n    # 插入SQL语句\n    await crud.add("李四")\n    await crud.add("王五")\n    await crud.add("赵六")\n\n\nasync def test_insert_many(loop):\n    # 插入SQL语句\n    data = [("孙悟空",), ("猪八戒",), ("沙僧",), ]\n    await crud.add_many(data)\n    \nasync def test_delete(loop):\n    # 根据ID删除数据\n    await crud.delete(1)\n    await crud.delete(2)\n    await crud.delete(3)\n    \n\nif __name__ == "__main__":\n    loop = asyncio.get_event_loop()\n    loop.run_until_complete(test_create_table(loop))\n    loop.run_until_complete(test_insert(loop))\n    loop.run_until_complete(test_insert_many(loop))\n    loop.run_until_complete(test_delete(loop))\n\n```\n\n### 3.4 根据ID列表删除\n```python\nimport asyncio\nfrom zdpapi_mysql import Mysql, Crud\ndb = Mysql(host=\'127.0.0.1\',\n           port=3306,\n           user=\'root\',\n           password=\'root\',\n           db=\'test\')\n\ncrud = Crud(db, "user", ["name"])\n\nasync def test_create_table(loop):\n    # 删除表\n    await db.connect()\n    sql = "DROP TABLE IF EXISTS user;"\n\n    # 创建表\n    await db.execute(sql)\n    sql = """CREATE TABLE user(id INT PRIMARY KEY AUTO_INCREMENT, name VARCHAR(255));"""\n    await db.execute(sql)\n\n    # 插入SQL语句\n    sql = "INSERT INTO user VALUES(1,\'张三\')"\n    await db.execute(sql)\n\n\nasync def test_insert(loop):\n    # 插入SQL语句\n    await crud.add("李四")\n    await crud.add("王五")\n    await crud.add("赵六")\n\n\nasync def test_insert_many(loop):\n    # 插入SQL语句\n    data = [("孙悟空",), ("猪八戒",), ("沙僧",), ]\n    await crud.add_many(data)\n    \nasync def test_delete(loop):\n    # 根据ID删除数据\n    await crud.delete(1)\n    await crud.delete(2)\n    await crud.delete(3)\n    \nasync def test_delete_ids(loop):\n    # 根据ID列表删除数据\n    await crud.delete_ids((3,4,5))\n    \n\nif __name__ == "__main__":\n    loop = asyncio.get_event_loop()\n    loop.run_until_complete(test_create_table(loop))\n    loop.run_until_complete(test_insert(loop))\n    loop.run_until_complete(test_insert_many(loop))\n    loop.run_until_complete(test_delete(loop))\n    loop.run_until_complete(test_delete_ids(loop))\n```\n\n### 3.5 更新多条数据\n```python\nimport asyncio\nfrom zdpapi_mysql import Mysql, Crud\ndb = Mysql(host=\'127.0.0.1\',\n           port=3306,\n           user=\'root\',\n           password=\'root\',\n           db=\'test\')\n\ncrud = Crud(db, "user", ["name"])\n\nasync def test_create_table(loop):\n    # 删除表\n    await db.connect()\n    sql = "DROP TABLE IF EXISTS user;"\n\n    # 创建表\n    await db.execute(sql)\n    sql = """CREATE TABLE user(id INT PRIMARY KEY AUTO_INCREMENT, name VARCHAR(255));"""\n    await db.execute(sql)\n\n    # 插入SQL语句\n    sql = "INSERT INTO user VALUES(1,\'张三\')"\n    await db.execute(sql)\n\n\nasync def test_insert(loop):\n    # 插入SQL语句\n    await crud.add("李四")\n    await crud.add("王五")\n    await crud.add("赵六")\n\n\nasync def test_insert_many(loop):\n    # 插入SQL语句\n    data = [("孙悟空",), ("猪八戒",), ("沙僧",), ]\n    await crud.add_many(data)\n    \nasync def test_delete(loop):\n    # 根据ID删除数据\n    await crud.delete(1)\n    await crud.delete(2)\n    await crud.delete(3)\n    \nasync def test_delete_ids(loop):\n    # 根据ID列表删除数据\n    await crud.delete_ids((3,4,5))\n    \nasync def test_update(loop):\n    # 根据ID更新数据\n    await crud.update(6, {"name":"二郎神111"})\n    \nasync def test_update_many(loop):\n    # 更新多条数据\n    data=[\n        {"id":6, "name":"猪八戒"},\n        {"id":7, "name":"嫦娥"},\n    ]\n    await crud.update_many(data)\n   \n\nif __name__ == "__main__":\n    loop = asyncio.get_event_loop()\n    loop.run_until_complete(test_create_table(loop))\n    loop.run_until_complete(test_insert(loop))\n    loop.run_until_complete(test_insert_many(loop))\n    loop.run_until_complete(test_delete(loop))\n    loop.run_until_complete(test_delete_ids(loop))\n    loop.run_until_complete(test_update(loop))\n    loop.run_until_complete(test_update_many(loop))\n```\n\n### 3.6 查询单条数据\n```python\nimport asyncio\nfrom zdpapi_mysql import Mysql, Crud\ndb = Mysql(host=\'127.0.0.1\',\n           port=3306,\n           user=\'root\',\n           password=\'root\',\n           db=\'test\')\n\ncrud = Crud(db, "user", ["name"])\n\nasync def test_create_table(loop):\n    # 删除表\n    await db.connect()\n    sql = "DROP TABLE IF EXISTS user;"\n\n    # 创建表\n    await db.execute(sql)\n    sql = """CREATE TABLE user(id INT PRIMARY KEY AUTO_INCREMENT, name VARCHAR(255));"""\n    await db.execute(sql)\n\n    # 插入SQL语句\n    sql = "INSERT INTO user VALUES(1,\'张三\')"\n    await db.execute(sql)\n\n\nasync def test_insert(loop):\n    # 插入SQL语句\n    await crud.add("李四")\n    await crud.add("王五")\n    await crud.add("赵六")\n\n\nasync def test_insert_many(loop):\n    # 插入SQL语句\n    data = [("孙悟空",), ("猪八戒",), ("沙僧",), ]\n    await crud.add_many(data)\n    \nasync def test_delete(loop):\n    # 根据ID删除数据\n    await crud.delete(1)\n    await crud.delete(2)\n    await crud.delete(3)\n    \nasync def test_delete_ids(loop):\n    # 根据ID列表删除数据\n    await crud.delete_ids((3,4,5))\n    \nasync def test_update(loop):\n    # 根据ID更新数据\n    await crud.update(6, {"name":"二郎神111"})\n    \nasync def test_update_many(loop):\n    # 更新多条数据\n    data=[\n        {"id":6, "name":"猪八戒"},\n        {"id":7, "name":"嫦娥"},\n    ]\n    await crud.update_many(data)\n\nasync def test_find_one(loop):\n    # 查询单条数据\n    result = await crud.find(6)\n    print("查询结果：\\n", result)\n   \n\nif __name__ == "__main__":\n    loop = asyncio.get_event_loop()\n    loop.run_until_complete(test_create_table(loop))\n    loop.run_until_complete(test_insert(loop))\n    loop.run_until_complete(test_insert_many(loop))\n    loop.run_until_complete(test_delete(loop))\n    loop.run_until_complete(test_delete_ids(loop))\n    loop.run_until_complete(test_update(loop))\n    loop.run_until_complete(test_update_many(loop))\n    loop.run_until_complete(test_find_one(loop))\n```\n\n### 3.8 根据ID列表查询\n```python\nimport asyncio\nfrom zdpapi_mysql import Mysql, Crud\ndb = Mysql(host=\'127.0.0.1\',\n           port=3306,\n           user=\'root\',\n           password=\'root\',\n           db=\'test\')\n\ncrud = Crud(db, "user", ["name"])\n\n\nasync def test_create_table(loop):\n    # 删除表\n    await db.connect()\n    sql = "DROP TABLE IF EXISTS user;"\n\n    # 创建表\n    await db.execute(sql)\n    sql = """CREATE TABLE user(id INT PRIMARY KEY AUTO_INCREMENT, name VARCHAR(255));"""\n    await db.execute(sql)\n\n    # 插入SQL语句\n    sql = "INSERT INTO user VALUES(1,\'张三\')"\n    await db.execute(sql)\n\n\nasync def test_insert(loop):\n    # 插入SQL语句\n    await crud.add("李四")\n    await crud.add("王五")\n    await crud.add("赵六")\n\n\nasync def test_insert_many(loop):\n    # 插入SQL语句\n    data = [("孙悟空",), ("猪八戒",), ("沙僧",), ]\n    await crud.add_many(data)\n\n\nasync def test_delete(loop):\n    # 根据ID删除数据\n    await crud.delete(1)\n    await crud.delete(2)\n    await crud.delete(3)\n\n\nasync def test_delete_ids(loop):\n    # 根据ID列表删除数据\n    await crud.delete_ids((3, 4, 5))\n\n\nasync def test_update(loop):\n    # 根据ID更新数据\n    await crud.update(6, {"name": "二郎神111"})\n\n\nasync def test_update_many(loop):\n    # 更新多条数据\n    data = [\n        {"id": 6, "name": "猪八戒"},\n        {"id": 7, "name": "嫦娥"},\n    ]\n    await crud.update_many(data)\n\n\nasync def test_find_one(loop):\n    # 查询单条数据\n    result = await crud.find(6)\n    print("查询结果：\\n", result)\n\n\nasync def test_find_ids(loop):\n    # 根据ID列表查询\n    result = await crud.find_ids([6, 7, 8])\n    print("查询结果：\\n", result)\n\n\nif __name__ == "__main__":\n    loop = asyncio.get_event_loop()\n    loop.run_until_complete(test_create_table(loop))\n    loop.run_until_complete(test_insert(loop))\n    loop.run_until_complete(test_insert_many(loop))\n    loop.run_until_complete(test_delete(loop))\n    loop.run_until_complete(test_delete_ids(loop))\n    loop.run_until_complete(test_update(loop))\n    loop.run_until_complete(test_update_many(loop))\n    loop.run_until_complete(test_find_one(loop))\n    loop.run_until_complete(test_find_ids(loop))\n```\n\n### 3.9 分页查询数据\n```python\nimport asyncio\nfrom zdpapi_mysql import Mysql, Crud\ndb = Mysql(host=\'127.0.0.1\',\n           port=3306,\n           user=\'root\',\n           password=\'root\',\n           db=\'test\')\n\ncrud = Crud(db, "user", ["name"])\n\n\nasync def test_create_table(loop):\n    # 删除表\n    await db.connect()\n    sql = "DROP TABLE IF EXISTS user;"\n\n    # 创建表\n    await db.execute(sql)\n    sql = """CREATE TABLE user(id INT PRIMARY KEY AUTO_INCREMENT, name VARCHAR(255));"""\n    await db.execute(sql)\n\n    # 插入SQL语句\n    sql = "INSERT INTO user VALUES(1,\'张三\')"\n    await db.execute(sql)\n\n\nasync def test_insert(loop):\n    # 插入SQL语句\n    await crud.add("李四")\n    await crud.add("王五")\n    await crud.add("赵六")\n\n\nasync def test_insert_many(loop):\n    # 插入SQL语句\n    data = [("孙悟空",), ("猪八戒",), ("沙僧",), ]\n    await crud.add_many(data)\n\n\nasync def test_delete(loop):\n    # 根据ID删除数据\n    await crud.delete(1)\n    await crud.delete(2)\n    await crud.delete(3)\n\n\nasync def test_delete_ids(loop):\n    # 根据ID列表删除数据\n    await crud.delete_ids((3, 4, 5))\n\n\nasync def test_update(loop):\n    # 根据ID更新数据\n    await crud.update(6, {"name": "二郎神111"})\n\n\nasync def test_update_many(loop):\n    # 更新多条数据\n    data = [\n        {"id": 6, "name": "猪八戒"},\n        {"id": 7, "name": "嫦娥"},\n    ]\n    await crud.update_many(data)\n\n\nasync def test_find_one(loop):\n    # 查询单条数据\n    result = await crud.find(6)\n    print("查询结果：\\n", result)\n\n\nasync def test_find_ids(loop):\n    # 根据ID列表查询\n    result = await crud.find_ids([6, 7, 8])\n    print("查询结果：\\n", result)\n\nasync def test_find_page(loop):\n    # 分页查询数据\n    result = await crud.find_page(1, 20)\n    print("查询结果：\\n", result)\n\n\nif __name__ == "__main__":\n    loop = asyncio.get_event_loop()\n    loop.run_until_complete(test_create_table(loop))\n    loop.run_until_complete(test_insert(loop))\n    loop.run_until_complete(test_insert_many(loop))\n    loop.run_until_complete(test_delete(loop))\n    loop.run_until_complete(test_delete_ids(loop))\n    loop.run_until_complete(test_update(loop))\n    loop.run_until_complete(test_update_many(loop))\n    loop.run_until_complete(test_find_one(loop))\n    loop.run_until_complete(test_find_ids(loop))\n    loop.run_until_complete(test_find_page(loop))\n```\n\n### 3.10 查询总数\n```python\nimport asyncio\nfrom zdpapi_mysql import Mysql, Crud\ndb = Mysql(host=\'127.0.0.1\',\n           port=3306,\n           user=\'root\',\n           password=\'root\',\n           db=\'test\')\n\ncrud = Crud(db, "user", ["name"])\n\n\nasync def test_create_table(loop):\n    # 删除表\n    await db.connect()\n    sql = "DROP TABLE IF EXISTS user;"\n\n    # 创建表\n    await db.execute(sql)\n    sql = """CREATE TABLE user(id INT PRIMARY KEY AUTO_INCREMENT, name VARCHAR(255));"""\n    await db.execute(sql)\n\n    # 插入SQL语句\n    sql = "INSERT INTO user VALUES(1,\'张三\')"\n    await db.execute(sql)\n\n\nasync def test_insert(loop):\n    # 插入SQL语句\n    await crud.add("李四")\n    await crud.add("王五")\n    await crud.add("赵六")\n\n\nasync def test_insert_many(loop):\n    # 插入SQL语句\n    data = [("孙悟空",), ("猪八戒",), ("沙僧",), ]\n    await crud.add_many(data)\n\n\nasync def test_delete(loop):\n    # 根据ID删除数据\n    await crud.delete(1)\n    await crud.delete(2)\n    await crud.delete(3)\n\n\nasync def test_delete_ids(loop):\n    # 根据ID列表删除数据\n    await crud.delete_ids((3, 4, 5))\n\n\nasync def test_update(loop):\n    # 根据ID更新数据\n    await crud.update(6, {"name": "二郎神111"})\n\n\nasync def test_update_many(loop):\n    # 更新多条数据\n    data = [\n        {"id": 6, "name": "猪八戒"},\n        {"id": 7, "name": "嫦娥"},\n    ]\n    await crud.update_many(data)\n\n\nasync def test_find_one(loop):\n    # 查询单条数据\n    result = await crud.find(6)\n    print("查询结果：\\n", result)\n\n\nasync def test_find_ids(loop):\n    # 根据ID列表查询\n    result = await crud.find_ids([6, 7, 8])\n    print("查询结果：\\n", result)\n\nasync def test_find_page(loop):\n    # 分页查询数据\n    result = await crud.find_page(1, 20)\n    print("查询结果：\\n", result)\n\nasync def test_find_total(loop):\n    # 查询数据总数\n    result = await crud.find_total()\n    print("查询结果：\\n", result)\n\n\nif __name__ == "__main__":\n    loop = asyncio.get_event_loop()\n    loop.run_until_complete(test_create_table(loop))\n    loop.run_until_complete(test_insert(loop))\n    loop.run_until_complete(test_insert_many(loop))\n    loop.run_until_complete(test_delete(loop))\n    loop.run_until_complete(test_delete_ids(loop))\n    loop.run_until_complete(test_update(loop))\n    loop.run_until_complete(test_update_many(loop))\n    loop.run_until_complete(test_find_one(loop))\n    loop.run_until_complete(test_find_ids(loop))\n    loop.run_until_complete(test_find_page(loop))\n    loop.run_until_complete(test_find_total(loop))\n```\n',
    'author': '张大鹏',
    'author_email': 'lxgzhw@163.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/zhangdapeng520/zdpapi_mysql',
    'packages': packages,
    'package_data': package_data,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
