# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['zdpapi_modbus', 'zdpapi_modbus.libs', 'zdpapi_modbus.libs.modbus_tk']

package_data = \
{'': ['*']}

install_requires = \
['aioredis[hiredis]>=2.0.0,<3.0.0', 'redis>=4.0.2,<5.0.0']

setup_kwargs = {
    'name': 'zdpapi-modbus',
    'version': '1.7.0',
    'description': 'python版modbus协议快速开发工具库',
    'long_description': '# zdpapi_modbus\npython版modbus协议快速开发工具库\n\n安装方式\n```shell\npip install zdpapi_modbus\n```\n\n## 一、快速入门\n\n### 1.1 实例1：读写数据\n\n#### 1.1.1 slave读写master数据\n```python\nfrom zdpapi_modbus import  cst, modbus_tcp\nimport time\nimport random\n\n# 创建一个TCP服务\nserver = modbus_tcp.TcpServer()\n# 启动server\nserver.start()\n# 添加一个slave\nslave_id = 1\nslave_1 = server.add_slave(slave_id)\n# 添加一个block\nblock_name = "0"\nslave_1.add_block(block_name, cst.HOLDING_REGISTERS, 0, 100)\n\n\n# 不断的写入数据\nwhile True:\n    # 写入数据\n    slave = server.get_slave(slave_id)\n    address = 0\n    values = [random.randint(0, 100) for _ in range(6)]\n    slave.set_values(block_name, address, values)\n    values = slave.get_values(block_name, address, len(values))\n    print("slave上的values是：", values)\n    # 读取数据\n    slave = server.get_slave(slave_id)\n    address = 10\n    values = slave.get_values(block_name, address, len(values))\n    print("slave接收到server传过来的数据：", values)\n    time.sleep(1)\n```\n\n#### 1.1.2 master从slave读数据\n```python\nfrom zdpapi_modbus import cst, modbus_tcp\nimport time\nimport random\n\nmaster = modbus_tcp.TcpMaster()\nmaster.set_timeout(5.0)\nslave_id = 1\n\nwhile True:\n    # 读取数据\n    values = master.execute(slave_id, cst.READ_HOLDING_REGISTERS, 0, 6)\n    print("values:", values)\n    # 写入数据\n    address = 10\n    values = [random.randint(10, 20) for _ in range(6)]\n    master.execute(slave_id, cst.WRITE_MULTIPLE_REGISTERS, address, output_value=values)\n    # 1s执行一次\n    time.sleep(1)\n```\n\n### 1.2 使用钩子\n\n#### 1.2.1 slave\n```python\nimport sys\nfrom zdpapi_modbus import cst, modbus_tcp, utils\nimport logging\n\n\ndef main():\n    logger = utils.create_logger(name="console", record_format="%(message)s")\n\n    try:\n        # 创建一个TCP服务\n        server = modbus_tcp.TcpServer()\n        logger.info("running...")\n        logger.info("enter \'quit\' for closing the server")\n        # 启动server\n        server.start()\n        # 添加一个slave\n        slave_1 = server.add_slave(1)\n        # 添加一个block\n        slave_1.add_block(\'0\', cst.HOLDING_REGISTERS, 0, 100)\n        while True:\n            cmd = sys.stdin.readline()\n            args = cmd.split(\' \')\n            # 退出\n            if cmd.find(\'quit\') == 0:\n                sys.stdout.write(\'bye-bye\\r\\n\')\n                break\n            # 添加slave\n            elif args[0] == \'add_slave\':\n                slave_id = int(args[1])\n                server.add_slave(slave_id)\n                sys.stdout.write(\'done: slave %d added\\r\\n\' % slave_id)\n            # 添加block\n            elif args[0] == \'add_block\':\n                slave_id = int(args[1])\n                name = args[2]\n                block_type = int(args[3])\n                starting_address = int(args[4])\n                length = int(args[5])\n                slave = server.get_slave(slave_id)\n                slave.add_block(name, block_type, starting_address, length)\n                sys.stdout.write(\'done: block %s added\\r\\n\' % name)\n            # 写入数据\n            elif args[0] == \'set_values\':\n                slave_id = int(args[1])\n                name = args[2]\n                address = int(args[3])\n                values = []\n                for val in args[4:]:\n                    values.append(int(val))\n                slave = server.get_slave(slave_id)\n                slave.set_values(name, address, values)\n                values = slave.get_values(name, address, len(values))\n                sys.stdout.write(\'done: values written: %s\\r\\n\' % str(values))\n            # 读取数据\n            elif args[0] == \'get_values\':\n                slave_id = int(args[1])\n                name = args[2]\n                address = int(args[3])\n                length = int(args[4])\n                slave = server.get_slave(slave_id)\n                values = slave.get_values(name, address, length)\n                sys.stdout.write(\'done: values read: %s\\r\\n\' % str(values))\n            else:\n                sys.stdout.write("unknown command %s\\r\\n" % args[0])\n    finally:\n        server.stop()\n\n\nif __name__ == "__main__":\n    main()\n```\n\n#### 1.2.2 master\n```python\nfrom __future__ import print_function\n\nfrom zdpapi_modbus import cst, modbus_tcp, hooks, utils, modbus\nimport logging\n\n\ndef main():\n    """main"""\n    logger = utils.create_logger("console", level=logging.DEBUG)\n    # 读取数据之后的回调\n    def on_after_recv(data):\n        master, bytes_data = data\n        logger.info(bytes_data)\n    # 注册回调\n    hooks.install_hook(\'modbus.Master.after_recv\', on_after_recv)\n\n    try:\n        # 连接之前的回调\n        def on_before_connect(args):\n            master = args[0]\n            logger.debug("on_before_connect {0} {1}".format(master._host, master._port))\n        # 注册回调\n        hooks.install_hook("modbus_tcp.TcpMaster.before_connect", on_before_connect)\n        # 读取数据之后的回调\n        def on_after_recv(args):\n            response = args[1]\n            logger.debug("on_after_recv {0} bytes received".format(len(response)))\n        hooks.install_hook("modbus_tcp.TcpMaster.after_recv", on_after_recv)\n\n        # 连接到slave\n        master = modbus_tcp.TcpMaster()\n        master.set_timeout(5.0)\n        logger.info("connected")\n        # 读取数据\n        logger.info(master.execute(1, cst.READ_HOLDING_REGISTERS, 0, 3))\n\n        # logger.info(master.execute(1, cst.READ_HOLDING_REGISTERS, 0, 2, data_format=\'f\'))\n\n        # Read and write floats\n        # master.execute(1, cst.WRITE_MULTIPLE_REGISTERS, starting_address=0, output_value=[3.14], data_format=\'>f\')\n        # logger.info(master.execute(1, cst.READ_HOLDING_REGISTERS, 0, 2, data_format=\'>f\'))\n\n        # send some queries\n        # logger.info(master.execute(1, cst.READ_COILS, 0, 10))\n        # logger.info(master.execute(1, cst.READ_DISCRETE_INPUTS, 0, 8))\n        # logger.info(master.execute(1, cst.READ_INPUT_REGISTERS, 100, 3))\n        # logger.info(master.execute(1, cst.READ_HOLDING_REGISTERS, 100, 12))\n        # logger.info(master.execute(1, cst.WRITE_SINGLE_COIL, 7, output_value=1))\n        # logger.info(master.execute(1, cst.WRITE_SINGLE_REGISTER, 100, output_value=54))\n        # logger.info(master.execute(1, cst.WRITE_MULTIPLE_COILS, 0, output_value=[1, 1, 0, 1, 1, 0, 1, 1]))\n        # logger.info(master.execute(1, cst.WRITE_MULTIPLE_REGISTERS, 100, output_value=xrange(12)))\n\n    except modbus.ModbusError as exc:\n        logger.error("%s- Code=%d", exc, exc.get_exception_code())\n\n\nif __name__ == "__main__":\n    main()\n```\n\n### 1.3 批量写入和批量读取modbus\n\n### 1.3.1 slave\n```python\n"""\n按照1秒钟传递100台机组的数据，1台机组25个变量\n"""\n\nfrom zdpapi_modbus import cst, modbus_tcp, rand_float, trans_float_to_int\nimport time\n\n# 创建一个TCP服务\nserver = modbus_tcp.TcpServer()\n\n# 启动server\nserver.start()\n\n# 添加一个slave\nslave_id = 1\nslave_1 = server.add_slave(slave_id)\n\n# 添加一个block\nblock_name = "0"\nslave_1.add_block(block_name, cst.HOLDING_REGISTERS, 0, 3000)\n\n# 单台风机的数据\nvariables = [\n    "机舱X方向振动",\n    "机舱Y方向振动",\n    "限功率运行状态",\n    "电网有功功率",\n    "有功功率",\n    "风轮转速",\n    "环境温度",\n    "瞬时风向",\n    "瞬时风速",\n    "工作模式",\n    "测试写入主控变量1",\n    "1#风向仪瞬时风向",\n    "2#风向仪瞬时风向",\n    "机舱外风向",\n    "偏航方位角",\n    "测试（高频数据）1",\n    "测试（高频数据）2",\n    "测试（高频数据）3",\n    "测试（高频数据）4",\n    "测试（高频数据）5",\n    "测试（高频数据）6",\n    "测试（高频数据）7",\n    "测试（高频数据）8",\n    "测试（高频数据）9",\n    "测试（高频数据）10",\n]\n\n# 分两个slave传，一个传50台风机\n# 生成数据\ndata = []\naddress = 0\nfor i in range(1, 51):\n    for j in range(1, len(variables)+1):\n        control = {}\n        control["device_id"] = i\n        control["cname"] = variables[j-1]\n        control["name"] = f"v{i}_{j}"\n        address += 2\n        control["address"] = address\n        control["length"] = 2\n        control["func"] = 3\n        control["type"] = "F"\n        data.append(control)\n\n# 生成随机数\ndata_float = [rand_float(0, 100) for _ in data]\n\n# 不断的写入数据\nwhile True:\n    # 生成数据\n\n    # 写入数据\n    slave = server.get_slave(slave_id)  # slave\n    address = 0\n\n    values = trans_float_to_int(data_float)\n    value_length = len(values)\n    print("要传输的数据个数：", value_length)\n    index = 0\n    while True:\n        slave.set_values(block_name, index, values[index:index + 100])\n        \n        # 最后一次传输\n        value_length -= 100\n        if value_length <= 100:\n            slave.set_values(block_name, index, values[index:])\n            break\n        \n        # 每次传100个数\n        index += 100\n\n    time.sleep(1)\n```\n\n### 1.3.2 master\n```python\n"""\n从服务端获取100台机组的数据，每台机组有25个变量\n"""\nfrom zdpapi_modbus import cst, modbus_tcp, trans_int_to_float\nimport time\nimport random\n\nmaster = modbus_tcp.TcpMaster()\nmaster.set_timeout(5.0)\nslave_id = 1\n\n\n# 单台风机的数据\nvariables = [\n    "机舱X方向振动",\n    "机舱Y方向振动",\n    "限功率运行状态",\n    "电网有功功率",\n    "有功功率",\n    "风轮转速",\n    "环境温度",\n    "瞬时风向",\n    "瞬时风速",\n    "工作模式",\n    "测试写入主控变量1",\n    "1#风向仪瞬时风向",\n    "2#风向仪瞬时风向",\n    "机舱外风向",\n    "偏航方位角",\n    "测试（高频数据）1",\n    "测试（高频数据）2",\n    "测试（高频数据）3",\n    "测试（高频数据）4",\n    "测试（高频数据）5",\n    "测试（高频数据）6",\n    "测试（高频数据）7",\n    "测试（高频数据）8",\n    "测试（高频数据）9",\n    "测试（高频数据）10",\n]\n\n# 分两个slave传，一个传50台风机\n# 生成数据\ndata = []\naddress = 0\nfor i in range(1, 51):\n    for j in range(1, len(variables)+1):\n        control = {}\n        control["device_id"] = i\n        control["cname"] = variables[j-1]\n        control["name"] = f"v{i}_{j}"\n        address += 2\n        control["address"] = address\n        control["length"] = 2\n        control["func"] = 3\n        control["type"] = "F"\n        data.append(control)\n\nwhile True:\n    # 读取数据\n    data = []\n    data_length = 2500  # 要取出2500个数\n    index = 0\n    while True:\n        # 每次取出100个数\n        length = 100\n        values = master.execute(\n            slave_id, cst.READ_HOLDING_REGISTERS, index, length)\n        data.extend(values)\n\n        # 最后一次取\n        data_length -= 100\n        if data_length <= 100:\n            values = master.execute(\n                slave_id, cst.READ_HOLDING_REGISTERS, index, data_length)\n            data.extend(values)\n            break\n\n        index += 100\n\n    # print("data:", data, len(data))\n\n    # 解析为真实的数组\n    result = trans_int_to_float(data, keep_num=2)\n    print("最终结果：", result, len(result))\n\n    # 1s执行一次\n    time.sleep(1)\n```\n\n### 1.4 使用Slave和Master类\n#### 1.4.1 slave\n```python\n"""\n按照1秒钟传递100台机组的数据，1台机组25个变量\n"""\n\nfrom zdpapi_modbus import Slave, rand_float\n\nslave = Slave()\nslave.add_slave(1)\nslave.add_block(1, "0", 3)\n\n# 单台风机的数据\nvariables = [\n    "机舱X方向振动",\n    "机舱Y方向振动",\n    "限功率运行状态",\n    "电网有功功率",\n    "有功功率",\n    "风轮转速",\n    "环境温度",\n    "瞬时风向",\n    "瞬时风速",\n    "工作模式",\n    "测试写入主控变量1",\n    "1#风向仪瞬时风向",\n    "2#风向仪瞬时风向",\n    "机舱外风向",\n    "偏航方位角",\n    "测试（高频数据）1",\n    "测试（高频数据）2",\n    "测试（高频数据）3",\n    "测试（高频数据）4",\n    "测试（高频数据）5",\n    "测试（高频数据）6",\n    "测试（高频数据）7",\n    "测试（高频数据）8",\n    "测试（高频数据）9",\n    "测试（高频数据）10",\n]\n\n# 分两个slave传，一个传50台风机\n# 生成数据\ndata = []\naddress = 0\nfor i in range(1, 51):\n    for j in range(1, len(variables)+1):\n        control = {}\n        control["device_id"] = i\n        control["cname"] = variables[j-1]\n        control["name"] = f"v{i}_{j}"\n        address += 2\n        control["address"] = address\n        control["length"] = 2\n        control["func"] = 3\n        control["type"] = "F"\n        data.append(control)\n\n# 生成随机数\ndata_float = [rand_float(0, 100) for _ in data]\nslave.run(1, "0", data_float, random_data=True)\n```\n\n#### 1.4.2 master\n```python\n"""\n从服务端获取100台机组的数据，每台机组有25个变量\n"""\nfrom zdpapi_modbus import Master\n\nmaster = Master()\nslave_id = 1\n\n\n# 单台风机的数据\nvariables = [\n    "机舱X方向振动",\n    "机舱Y方向振动",\n    "限功率运行状态",\n    "电网有功功率",\n    "有功功率",\n    "风轮转速",\n    "环境温度",\n    "瞬时风向",\n    "瞬时风速",\n    "工作模式",\n    "测试写入主控变量1",\n    "1#风向仪瞬时风向",\n    "2#风向仪瞬时风向",\n    "机舱外风向",\n    "偏航方位角",\n    "测试（高频数据）1",\n    "测试（高频数据）2",\n    "测试（高频数据）3",\n    "测试（高频数据）4",\n    "测试（高频数据）5",\n    "测试（高频数据）6",\n    "测试（高频数据）7",\n    "测试（高频数据）8",\n    "测试（高频数据）9",\n    "测试（高频数据）10",\n]\n\n# 分两个slave传，一个传50台风机\n# 生成数据\ndata = []\naddress = 0\nfor i in range(1, 51):\n    for j in range(1, len(variables)+1):\n        control = {}\n        control["device_id"] = i\n        control["cname"] = variables[j-1]\n        control["name"] = f"v{i}_{j}"\n        address += 2\n        control["address"] = address\n        control["length"] = 2\n        control["func"] = 3\n        control["type"] = "F"\n        data.append(control)\n\nmaster.run_read_many_float(slave_id, 2500, console=True)\n```\n\n\n## 二、数据的打包和解包\n\n### 2.1 基本使用\n```python\nfrom zdpapi_modbus import *\n\ndata = [11, 22, 33]\n# 测试打包\nprint("============================================测试打包=====================================================")\nprint(pack_byte(data))\nprint(pack_int(data))\nprint(pack_long(data))\nprint(pack_float(data))\nprint(pack_double(data))\nprint("============================================测试完毕=====================================================\\n\\n")\n\n# 测试解包\nprint("============================================测试解包=====================================================")\nprint(unpack_byte(len(data), pack_byte(data)))\nprint(unpack_int(len(data), pack_int(data)))\nprint(unpack_long(len(data), pack_long(data)))\nprint(unpack_float(len(data), pack_float(data)))\nprint(unpack_double(len(data), pack_double(data)))\nprint("============================================测试完毕=====================================================\\n\\n")\n```\n\n### 2.2 数据类型转换\n```python\nfrom zdpapi_modbus import *\n\ndata = [11.11, 22.22, 33.33]\n\n# 将浮点数转换为整数，再将整数还原为浮点数\nprint(trans_float_to_int(data))\nprint(trans_int_to_float(trans_float_to_int(data)))\n```\n\n## 三、生成随机数\n\n### 3.1 生成随机浮点数\n```python\nfrom zdpapi_modbus import *\n\ndata = [rand_float(0, 100) for _ in range(50)]\nprint(data)\n\n# 将浮点数转换为整数，再将整数还原为浮点数\nprint(trans_float_to_int(data))\nprint(trans_int_to_float(trans_float_to_int(data), keep_num=6))\n```\n',
    'author': '张大鹏',
    'author_email': 'lxgzhw@163.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/zhangdapeng520/zdpapi_modbus',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
