# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['zdpapi_modbus',
 'zdpapi_modbus.libs',
 'zdpapi_modbus.libs.modbus_tk',
 'zdpapi_modbus.zstruct']

package_data = \
{'': ['*']}

setup_kwargs = {
    'name': 'zdpapi-modbus',
    'version': '1.0.0',
    'description': 'python版modbus协议快速开发工具库',
    'long_description': '# zdpapi_modbus\npython版modbus协议快速开发工具库\n\n## 一、快速入门\n\n### 1.1 实例1：读写数据\n\n#### 1.1.1 slave读写master数据\n```python\nfrom zdpapi_modbus import  cst, modbus_tcp\nimport time\nimport random\n\n# 创建一个TCP服务\nserver = modbus_tcp.TcpServer()\n# 启动server\nserver.start()\n# 添加一个slave\nslave_id = 1\nslave_1 = server.add_slave(slave_id)\n# 添加一个block\nblock_name = "0"\nslave_1.add_block(block_name, cst.HOLDING_REGISTERS, 0, 100)\n\n\n# 不断的写入数据\nwhile True:\n    # 写入数据\n    slave = server.get_slave(slave_id)\n    address = 0\n    values = [random.randint(0, 100) for _ in range(6)]\n    slave.set_values(block_name, address, values)\n    values = slave.get_values(block_name, address, len(values))\n    print("slave上的values是：", values)\n    # 读取数据\n    slave = server.get_slave(slave_id)\n    address = 10\n    values = slave.get_values(block_name, address, len(values))\n    print("slave接收到server传过来的数据：", values)\n    time.sleep(1)\n```\n\n#### 1.1.2 master从slave读数据\n```python\nfrom zdpapi_modbus import cst, modbus_tcp\nimport time\nimport random\n\nmaster = modbus_tcp.TcpMaster()\nmaster.set_timeout(5.0)\nslave_id = 1\n\nwhile True:\n    # 读取数据\n    values = master.execute(slave_id, cst.READ_HOLDING_REGISTERS, 0, 6)\n    print("values:", values)\n    # 写入数据\n    address = 10\n    values = [random.randint(10, 20) for _ in range(6)]\n    master.execute(slave_id, cst.WRITE_MULTIPLE_REGISTERS, address, output_value=values)\n    # 1s执行一次\n    time.sleep(1)\n```\n\n### 1.2 使用钩子\n\n#### 1.2.1 slave\n```python\nimport sys\nfrom zdpapi_modbus import cst, modbus_tcp, utils\nimport logging\n\n\ndef main():\n    logger = utils.create_logger(name="console", record_format="%(message)s")\n\n    try:\n        # 创建一个TCP服务\n        server = modbus_tcp.TcpServer()\n        logger.info("running...")\n        logger.info("enter \'quit\' for closing the server")\n        # 启动server\n        server.start()\n        # 添加一个slave\n        slave_1 = server.add_slave(1)\n        # 添加一个block\n        slave_1.add_block(\'0\', cst.HOLDING_REGISTERS, 0, 100)\n        while True:\n            cmd = sys.stdin.readline()\n            args = cmd.split(\' \')\n            # 退出\n            if cmd.find(\'quit\') == 0:\n                sys.stdout.write(\'bye-bye\\r\\n\')\n                break\n            # 添加slave\n            elif args[0] == \'add_slave\':\n                slave_id = int(args[1])\n                server.add_slave(slave_id)\n                sys.stdout.write(\'done: slave %d added\\r\\n\' % slave_id)\n            # 添加block\n            elif args[0] == \'add_block\':\n                slave_id = int(args[1])\n                name = args[2]\n                block_type = int(args[3])\n                starting_address = int(args[4])\n                length = int(args[5])\n                slave = server.get_slave(slave_id)\n                slave.add_block(name, block_type, starting_address, length)\n                sys.stdout.write(\'done: block %s added\\r\\n\' % name)\n            # 写入数据\n            elif args[0] == \'set_values\':\n                slave_id = int(args[1])\n                name = args[2]\n                address = int(args[3])\n                values = []\n                for val in args[4:]:\n                    values.append(int(val))\n                slave = server.get_slave(slave_id)\n                slave.set_values(name, address, values)\n                values = slave.get_values(name, address, len(values))\n                sys.stdout.write(\'done: values written: %s\\r\\n\' % str(values))\n            # 读取数据\n            elif args[0] == \'get_values\':\n                slave_id = int(args[1])\n                name = args[2]\n                address = int(args[3])\n                length = int(args[4])\n                slave = server.get_slave(slave_id)\n                values = slave.get_values(name, address, length)\n                sys.stdout.write(\'done: values read: %s\\r\\n\' % str(values))\n            else:\n                sys.stdout.write("unknown command %s\\r\\n" % args[0])\n    finally:\n        server.stop()\n\n\nif __name__ == "__main__":\n    main()\n```\n\n#### 1.2.2 master\n```python\nfrom __future__ import print_function\n\nfrom zdpapi_modbus import cst, modbus_tcp, hooks, utils, modbus\nimport logging\n\n\ndef main():\n    """main"""\n    logger = utils.create_logger("console", level=logging.DEBUG)\n    # 读取数据之后的回调\n    def on_after_recv(data):\n        master, bytes_data = data\n        logger.info(bytes_data)\n    # 注册回调\n    hooks.install_hook(\'modbus.Master.after_recv\', on_after_recv)\n\n    try:\n        # 连接之前的回调\n        def on_before_connect(args):\n            master = args[0]\n            logger.debug("on_before_connect {0} {1}".format(master._host, master._port))\n        # 注册回调\n        hooks.install_hook("modbus_tcp.TcpMaster.before_connect", on_before_connect)\n        # 读取数据之后的回调\n        def on_after_recv(args):\n            response = args[1]\n            logger.debug("on_after_recv {0} bytes received".format(len(response)))\n        hooks.install_hook("modbus_tcp.TcpMaster.after_recv", on_after_recv)\n\n        # 连接到slave\n        master = modbus_tcp.TcpMaster()\n        master.set_timeout(5.0)\n        logger.info("connected")\n        # 读取数据\n        logger.info(master.execute(1, cst.READ_HOLDING_REGISTERS, 0, 3))\n\n        # logger.info(master.execute(1, cst.READ_HOLDING_REGISTERS, 0, 2, data_format=\'f\'))\n\n        # Read and write floats\n        # master.execute(1, cst.WRITE_MULTIPLE_REGISTERS, starting_address=0, output_value=[3.14], data_format=\'>f\')\n        # logger.info(master.execute(1, cst.READ_HOLDING_REGISTERS, 0, 2, data_format=\'>f\'))\n\n        # send some queries\n        # logger.info(master.execute(1, cst.READ_COILS, 0, 10))\n        # logger.info(master.execute(1, cst.READ_DISCRETE_INPUTS, 0, 8))\n        # logger.info(master.execute(1, cst.READ_INPUT_REGISTERS, 100, 3))\n        # logger.info(master.execute(1, cst.READ_HOLDING_REGISTERS, 100, 12))\n        # logger.info(master.execute(1, cst.WRITE_SINGLE_COIL, 7, output_value=1))\n        # logger.info(master.execute(1, cst.WRITE_SINGLE_REGISTER, 100, output_value=54))\n        # logger.info(master.execute(1, cst.WRITE_MULTIPLE_COILS, 0, output_value=[1, 1, 0, 1, 1, 0, 1, 1]))\n        # logger.info(master.execute(1, cst.WRITE_MULTIPLE_REGISTERS, 100, output_value=xrange(12)))\n\n    except modbus.ModbusError as exc:\n        logger.error("%s- Code=%d", exc, exc.get_exception_code())\n\n\nif __name__ == "__main__":\n    main()\n```\n\n',
    'author': '张大鹏',
    'author_email': 'lxgzhw@163.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/zhangdapeng520/zdpapi_modbus',
    'packages': packages,
    'package_data': package_data,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
