# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['zdpapi_elastic_search']

package_data = \
{'': ['*']}

install_requires = \
['elasticsearch>=7.15.2,<8.0.0']

setup_kwargs = {
    'name': 'zdpapi-elastic-search',
    'version': '1.0.0',
    'description': 'python操作ElasticSearch的基础组件',
    'long_description': '# zdpapi_elastic_search\npython快速操作ElasticSearch的组件\n\n## 一、快速入门案例\n安装\n```shell\npip install zdpapi_elastic_search\n```\n\n增删改查案例\n```python\n# 使用python操作ElasticSearch\nfrom zdpapi_elastic_search import EsClient\n\n# 连接ES\nes = EsClient()\nprint(es.conn)\n\n# 查询\nquery = {\n  "query": {\n    "match_all": {}\n  }\n}\nresult = es.find(index="megacorp", body=query)\nprint(result)\n\n# 新增\n# 不指定id 自动生成\nes.add(index="megacorp",body={"first_name":"xiao","last_name":"xiao", \'age\': 25, \'about\': \'I love to go rock climbing\', \'interests\': [\'game\', \'play\']})\n# 指定IDwu\nes.add(index="megacorp",id=4,body={"first_name":"xiao","last_name":"wu", \'age\': 66, \'about\': \'I love to go rock climbing\', \'interests\': [\'sleep\', \'eat\']})\n\n# 根据ID删除\nes.delete(index=\'megacorp\', id=4)\n```\n\n## 二、常用功能\n\n### 2.1 查看集群的健康状态\n```python\n# 使用python操作ElasticSearch\nfrom zdpapi_elastic_search import EsClient\n\n# 连接ES\nes = EsClient()\n\n# 查看集群的健康状态\nprint(es.health())\n```\n\n### 2.2 查看集群的基本信息\n```python\n# 使用python操作ElasticSearch\nfrom zdpapi_elastic_search import EsClient\n\n# 连接ES\nes = EsClient()\n\n# 查看集群的基本信息\nprint(es.info())\n```\n\n### 2.3 查看集群其他信息\n```python\n# 使用python操作ElasticSearch\nfrom zdpapi_elastic_search import EsClient\n\n# 连接ES\nes = EsClient()\n\n# 查看集群的详细信息\nprint(es.detail())\n\n# 查看当前客户端信息\nprint(es.client_info())\n\n# 查看所有的索引\nprint(es.indexs())\n\n# 查看集群的更多信息\nprint(es.stats())\n```\n\n### 2.4 查看集群的任务\n```python\n# 使用python操作ElasticSearch\nfrom zdpapi_elastic_search import EsClient\n\n# 连接ES\nes = EsClient()\n\n# 查看集群的任务\nprint(es.tasks_get())\n\n# 查看集群的列表\nprint(es.tasks_list())\n```\n\n## 三、增删改查\n\n### 3.1 增加数据\n```python\n# 使用python操作ElasticSearch\nfrom zdpapi_elastic_search import EsClient\nfrom datetime import datetime\n\n# 连接ES\nes = EsClient()\n\n# 添加索引 已存在会报错\n# print(es.add_index("persons"))\n\n#index,doc_type,id都一致時會覆蓋\n#插入資料\nes.add(index="persons",doc_type="mytype",id=2,body={"name":"李四","age":20,"time":datetime.now()})\nes.add(index="persons", doc_type="mytype", id=4, body={\n       "name1": "李四", "name2": "張三", "age": 20, "time": datetime.now()})\nes.add(index="persons", doc_type="mytype", id=5, body={\n       "name1": "張三", "name2": "李四", "age": 20, "time": datetime.now()})\nes.add(index="persons", doc_type="mytype", id=1, body={\n       "name": "張三", "age": 18, "time": datetime.now()})\n\n#沒有索引就建立\nes.add(index="persons111", doc_type="mytype",id=3,body={"name":"王五","age":20,"time":datetime.now()})\n\n# 查询所有索引\nprint(es.find_all_index())\nprint(es.indexs())\n\n# 查询所有数据\nres = es.find()\nprint(res)\n```\n\n### 3.2 根据ID查询数据\n```python\n# 使用python操作ElasticSearch\nfrom zdpapi_elastic_search import EsClient\nfrom datetime import datetime\n\n# 连接ES\nes = EsClient()\n\n# 根据ID查询\nres = es.find(index="persons", doc_type="mytype", id=1)\nprint(res)\n```\n\n### 3.3 查询所有数据\n```python\n# 使用python操作ElasticSearch\nfrom zdpapi_elastic_search import EsClient\nfrom datetime import datetime\n\n# 连接ES\nes = EsClient()\n\n# 查询所有数据\nres = es.find(index="persons")\nprint(res)\n```\n\n### 3.4 更新数据\n```python\n# 使用python操作ElasticSearch\nfrom zdpapi_elastic_search import EsClient\nfrom datetime import datetime\n\n# 连接ES\nes = EsClient()\n\n#更新一條資料，需要指定index,doc_type,id\nprint(es.find(index="persons", id=1))\nes.update(index="persons", doc_type="mytype", id=1, body={"doc": {"age": 10}})\nprint(es.find(index="persons", id=1))\nprint("==================")\n\n# 条件更新\nquery = {"script": {\n    "source": "ctx._source[\'age\']=1"  # 改為字串時要加引號,"ctx._source[\'age\']=\'張三\'"\n},\n    \'query\': {\n    \'range\': {\n        \'age\': {\n            \'lt\': 30\n        }\n    }\n}\n}\nres = es.update(index="persons", doc_type="mytype", query=query)\nprint(res)\n```\n\n### 3.5 删除数据\n```python\n# 使用python操作ElasticSearch\nfrom zdpapi_elastic_search import EsClient\nfrom datetime import datetime\n\n# 连接ES\nes = EsClient()\n\n# 根据ID删除\nres = es.delete(index="persons", id=\'2\')\nprint(res)\n\n# 根据条件删除\nres = es.delete(index="persons", query={\'query\': {\'match\': {\'any\': \'data\'}}})\nprint(res)\n\n# 删除索引\nres = es.delete(\'persons\')\nprint(res)\n```\n\n## 四、查询\n\n### 4.1 查询年龄为20的数据\n```python\n# 使用python操作ElasticSearch\nfrom zdpapi_elastic_search import EsClient\nfrom datetime import datetime\n\n# 连接ES\nes = EsClient()\n\n# 查询所有数据\nbody = {\n    "query": {\n        "term": {\n            "age": 20\n        }\n    }\n}\nres = es.find(index="persons", body=body)\nprint(res)\n```\n\n### 4.2 查询年龄为18或20的数据\n```python\n# 使用python操作ElasticSearch\nfrom zdpapi_elastic_search import EsClient\nfrom datetime import datetime\n\n# 连接ES\nes = EsClient()\n\n# 查询年龄为18或20的数据\nbody = {\n    "query": {\n        "terms": {\n            "age": [\n                18, 20\n            ]\n        }\n    }\n}\nres = es.find(index="persons", body=body)\nprint(res)\n```\n\n### 4.3 查询名字包含“張”的数据\n```python\n# 使用python操作ElasticSearch\nfrom zdpapi_elastic_search import EsClient\nfrom datetime import datetime\n\n# 连接ES\nes = EsClient()\n\n# 查询名字包含“張”的数据\nbody = {\n    "query": {\n        "match": {\n            "name1": "張"\n        }\n    }\n}\n\nres = es.find(index="persons", body=body)\nprint(res)\n```\n\n### 4.4 查询name1和name2中都包含“四”的数据\n```python\n# 使用python操作ElasticSearch\nfrom zdpapi_elastic_search import EsClient\nfrom datetime import datetime\n\n# 连接ES\nes = EsClient()\n\n# 查询name1和name2中都包含"四"的数据\nbody = {\n    "query": {\n        "multi_match": {\n            "query": "四",\n            "fields": ["name1", "name2"]\n        }\n    }\n}\n\nres = es.find(index="persons", body=body)\nprint(res)\n```\n\n### 4.5 查询ID为1或2的数据\n```python\n# 使用python操作ElasticSearch\nfrom zdpapi_elastic_search import EsClient\nfrom datetime import datetime\n\n# 连接ES\nes = EsClient()\n\n# 查询ID为1或2的数据\nbody = {\n    "query": {\n        "ids": {\n            "values": [\n                "1", "2"\n            ]\n        }\n    }\n}\n\nres = es.find(index="persons", body=body)\nprint(res)\n```\n\n### 4.6 查询name1=张三或者age=20的数据\n```python\n# 使用python操作ElasticSearch\nfrom zdpapi_elastic_search import EsClient\nfrom datetime import datetime\n\n# 连接ES\nes = EsClient()\n\n# must(都滿足),should(其中一個滿足),must_not(都不滿足)\n# 查询name1=张三或者age=20的数据\nbody = {\n    "query": {\n        "bool": {\n            "should": [\n                {\n                    "term": {\n                        "name": "張三"\n                    }\n                },\n                {\n                    "term": {\n                        "age": 20\n                    }\n                }\n            ]\n        }\n    }\n}\n\nres = es.find(index="persons", body=body)\nprint(res)\n```\n\n### 4.7 查詢18<=age<=30的所有資料\n```python\n# 使用python操作ElasticSearch\nfrom zdpapi_elastic_search import EsClient\nfrom datetime import datetime\n\n# 连接ES\nes = EsClient()\n\n\'\'\'\nrange不支援:\n    eq 等於  \n    neq 不等於\n    \nrange支援:\n    gt: greater than 大於\n    gte: greater than or equal 大於等於\n    lt: less than 小於\n    lte: less than or equal 小於等於\n\'\'\'\n# 查詢18<=age<=30的所有資料\nbody = {\n    "query": {\n        "range": {\n            "age": {\n                "gte": 18,       # >=18\n                "lte": 30        # <=30\n            }\n        }\n    }\n}\n\nres = es.find(index="persons", body=body)\nprint(res)\n```\n\n### 4.8查询年龄最小的4条数据\n```python\n# 使用python操作ElasticSearch\nfrom zdpapi_elastic_search import EsClient\nfrom datetime import datetime\n\n# 连接ES\nes = EsClient()\n\n# 分页查询\nbody = {\n    "query": {\n        "match_all": {}\n    },\n\n    "sort": [{"age": {"order": "asc"}}],  # 排序,asc是指定列按升序排列，desc則是指定列按降序排列\n    "from": 0,    # 开始索引\n    "size": 4    # 获取4条数据\n}\n\nres = es.find(index="persons", body=body)\nprint(res)\n```\n\n### 4.9 查询name1以"張"开头的数据\n```python\n# 使用python操作ElasticSearch\nfrom zdpapi_elastic_search import EsClient\nfrom datetime import datetime\n\n# 连接ES\nes = EsClient()\n\n# 查询name1以"張"开头的数据\nbody = {\n    "query": {\n        "prefix": {\n            "name1": "張"\n        }\n    }\n}\nres = es.find(index="persons", body=body)\nprint(res)\n```\n\n### 4.10 查询name1以"三"结尾的数据\n```python\n# 使用python操作ElasticSearch\nfrom zdpapi_elastic_search import EsClient\nfrom datetime import datetime\n\n# 连接ES\nes = EsClient()\n\n# 查询name1以"三"结尾的数据\nbody = {\n    "query": {\n        "wildcard": {\n            "name1": "*三"\n        }\n    }\n}\n\nres = es.find(index="persons", body=body)\nprint(res)\n```\n\n### 4.11 查询所有数据并根据年龄升序\n```python\n# 使用python操作ElasticSearch\nfrom zdpapi_elastic_search import EsClient\nfrom datetime import datetime\n\n# 连接ES\nes = EsClient()\n\n# 查询所有数据并根据年龄升序\nbody = {\n    "query": {\n        "match_all": {}\n    },\n    "sort": {\n        "age": {                 # 根据年龄升序\n            "order": "asc"       # asc升序，desc降序\n        }\n    }\n}\n\nres = es.find(index="persons", body=body)\nprint(res)\n```\n\n### 4.12 查询所有数据并根据年龄升序且只获取ID\n```python\n# 使用python操作ElasticSearch\nfrom zdpapi_elastic_search import EsClient\nfrom datetime import datetime\n\n# 连接ES\nes = EsClient()\n\n# 查询所有数据并根据年龄升序且只获取ID\nbody = {\n    "query": {\n        "match_all": {}\n    },\n    "sort": {\n        "age": {                 # 根据年龄升序\n            "order": "asc"       # asc升序，desc降序\n        }\n    }\n}\n\nres = es.find(index="persons", body=body, filter_path=["hits.hits._id"])\nprint(res)\n```\n\n### 4.13 查询数据总数\n```python\n# 使用python操作ElasticSearch\nfrom zdpapi_elastic_search import EsClient\nfrom datetime import datetime\n\n# 连接ES\nes = EsClient()\n\n# 查询数据总数\nres = es.find_count()\nprint(res)\n\nres = es.find_count(index="persons")\nprint(res)\n```\n\n### 4.14 查询年龄最小的数据\n```python\n# 使用python操作ElasticSearch\nfrom zdpapi_elastic_search import EsClient\nfrom datetime import datetime\n\n# 连接ES\nes = EsClient()\n\n\'\'\'\nmin:最小\nmax:最大\nsum:求和\navg:平均值\n\'\'\'\n# 最小值\nbody = {\n    "query": {\n        "match_all": {}\n    },\n    "aggs": {                        # 聚合查詢\n        "min_age": {                 # 最小值的key\n            "min": {                 # 最小\n                "field": "age"       # 查詢"age"的最小值\n            }\n        }\n    }\n}\n\nres = es.find(index="persons", body=body)\nprint(res)\nprint(res[\'aggregations\'])\n```\n',
    'author': '张大鹏',
    'author_email': 'lxgzhw@163.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/zhangdapeng520/zdpapi_elastic_search',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
