# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['youdotcom']

package_data = \
{'': ['*']}

install_requires = \
['PyVirtualDisplay>=3.0,<4.0',
 'ascii-magic>=1.6,<2.0',
 'chromedriver-autoinstaller>=0.4.0,<0.5.0',
 'cloudscraper>=1.2.66,<2.0.0',
 'markdownify>=0.11.6,<0.12.0',
 'rich>=10.14,<14.0',
 'typer[all]>=0.4.0,<0.5.0',
 'undetected-chromedriver>=3.2.1,<4.0.0']

entry_points = \
{'console_scripts': ['youdotcom = youdotcom.__main__:app']}

setup_kwargs = {
    'name': 'youdotcom',
    'version': '1.0.4',
    'description': 'unofficial api wrapper for you.com and all of its apps',
    'long_description': '\n<h1 align="center">\n  <br>\n  <a href="https://github.com/SilkePilon/youdotcom/"><img src="https://github.com/SilkePilon/youdotcom/blob/main/youdotcom.png?raw=true" alt="Markdownify" width="200"></a>\n  <br>\n  <br>\n  YouDotCom for python v1.0.3\n  <br>\n</h1>\n\n<h4 align="center">An unofficial python library wrapper for <a href="http://you.com/" target="_blank">you.com</a> and all of its apps.</h4>\n\n<div align="center">\n\n  [![Python Version](https://img.shields.io/pypi/pyversions/youdotcom.svg)](https://pypi.org/project/youdotcom/)\n  [![Dependencies Status](https://img.shields.io/badge/dependencies-up%20to%20date-brightgreen.svg)](https://github.com/silkepilon/youdotcom/pulls?utf8=%E2%9C%93&q=is%3Apr%20author%3Aapp%2Fdependabot)\n\n  [![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)\n  [![Security: bandit](https://img.shields.io/badge/security-bandit-green.svg)](https://github.com/PyCQA/bandit)\n  [![Pre-commit](https://img.shields.io/badge/pre--commit-enabled-brightgreen?logo=pre-commit&logoColor=white)](https://github.com/silkepilon/youdotcom/blob/master/.pre-commit-config.yaml)\n  [![Semantic Versions](https://img.shields.io/badge/%20%20%F0%9F%93%A6%F0%9F%9A%80-semantic--versions-e10079.svg)](https://github.com/silkepilon/youdotcom/releases)\n  [![License](https://img.shields.io/github/license/silkepilon/youdotcom)](https://github.com/silkepilon/youdotcom/blob/master/LICENSE)\n  ![Coverage Report](assets/images/coverage.svg)\n  \n</div>\n\n<p align="center">\n  <a href="#about">About</a> •\n  <a href="#key-features">Key Features</a> •\n  <a href="#how-to-use">How To Use</a> •\n  <a href="#install">Install</a> •\n  <a href="#credits">Credits</a> •\n  <a href="#license">License</a>\n</p>\n\n<!-- ![screenshot](https://raw.githubusercontent.com/SilkePilon/youdotcom/main/assets/images/YouDotCom.jpg) -->\n\n## About\nWelcome to the YouDotCom Python Library!\n\nThis library allows users to easily access and utilize all of the functionality of the You.com platform through a simple and intuitive Python interface. With the library, users can access a variety of You.com apps and services, including but not limited to:\n\n* Search\n* ~~YouChat~~ (not suppoted yet by the you.com servers)\n* YouCode\n\nTo get started with the YouDotCom Python Library, simply <a href="#install">install</a> the package using pip and import it into your Python script. From there, you can use the provided functions and classes to easily interact with the You.com platform.\n\nWe hope you enjoy using the YouDotCom Python Library and all of the features it has to offer!\n> by Chat GPT\n\n\n## Key Features\n* Bypass CloudFlare\n* ~~Interact with YouChat~~\n* Find code examples\n* Server ready\n  - Supports non-gui operating systems.\n* Cross platform\n  - Windows, macOS and Linux ready.\n\n## How To Use\n\nTo help users get started with the YouDotCom Python Library, we have provided a selection of code examples that demonstrate common use cases for the library. These examples can be found below and cover a range of functionality.\n\nTo use the code examples, simply copy and paste the relevant code into your Python script and customize it to fit your specific needs. You can also use the examples as a starting point for your own code, using them as a guide to understand how the library functions can be used to build your own applications and integrations with the You.com platform.\n\nWe hope that these code examples will make it easier for users to get up and running with the YouDotCom Python Library and start building with the You.com platform.\n> :warning: **Warning!**\n> Do not spam or harm the you.com servers in any way!\n<details>\n<summary>YouChat example</summary>\n<br>\n\n> **Note**\n> YouChat is currently disabled because you.com does not yet support the trafic.\n\n\n```python\nfrom youdotcom import Init, Chat # import all the classes\n\ndriver = Init().driver  # setting up the webdriver. use `webdriver_path=` if the pre-installed one does not work.\n\n\nchat = Chat.send_message(driver=driver, message="how is your day?")  # send a message to YouChat. passing the driver and messages\n\ndriver.close()  # close the webdriver\n\n\nprint(chat)  # {\'message\': "It\'s been great! How about yours?", \'time\': \'11\', \'error\': \'False\'}\n```\n\nThis code imports two classes from the youdotcom library: Init and Chat. The Init class is used to set up a webdriver, which is a tool that allows you to automate web browsing tasks. The Chat class is used to send a message to the YouChat service.\n\nFirst, the Init class is instantiated with Init(). The driver attribute of the resulting object is then stored in the driver variable. The driver attribute returns a webdriver object that can be used to automate web browsing tasks.\n\nNext, the send_message method of the Chat class is called with driver and a message as arguments. This method sends the specified message to the YouChat service using the webdriver. The result of the method call is stored in the chat variable.\n\nFinally, the webdriver is closed with driver.close(), and the value of chat is printed to the console.\n  \n</details>\n\n<details>\n<summary>YouCode (only code search for now) example</summary>\n<br>\n  \n```python\nfrom youdotcom import Init, Code # import all the classes\n\ndriver = Init().driver # setting up the webdriver. use `webdriver_path=` if the pre-installed one does not work.\n\ncode = Code.find_code(driver, search="how to make an python loop?") # get all the code displayed on screen. passing the driver and search string.\n\nfor string in code[\'response\']: # loop through all the code\n    print(string) # print 1 at an time.\n    \nprint(code[\'time\']) # print the time taken to complete you search.\n```\n  \nThis code imports the Code and Init classes from the youdotcom library. The Code class is used to search for code snippets, while the Init class is used to set up a webdriver.\n\nFirst, the Init class is instantiated with Init(). The driver attribute of the resulting object is then stored in the driver variable. The driver attribute returns a webdriver object that can be used to automate web browsing tasks.\n\nNext, the find_code method of the Code class is called with driver and a search string as arguments. This method searches for code snippets related to the specified search string using the webdriver. The result of the method call is stored in the code variable.\n\nThe code variable is a dictionary containing a list of code snippets in the response field and the time taken to complete the search in the time field. The code then loops through the response list and prints each code snippet to the console one at a time. Finally, the time taken to complete the search is printed to the console.\n  \n</details>\n\n<details>\n<summary>Search example</summary>\n<br>\n  \n```python\nfrom youdotcom import Search # import the Search class\n\nsearch_results = Search.search_for("how to make an python loop?") # search! No need to use the Init class.\n\nprint(search_results[\'results\']) # print all the search results\n\nprint(search_results[\'time\']) # print the total time taken (les then 3 seconds on average)\n```\n  \nThis code imports the Search class from the youdotcom module. It then calls the search_for method of the Search class, passing in the string "how to make an python loop?" as an argument. The search_for method returns a dictionary with two keys: results and time. The code then prints the value associated with the results key, which is a list of search results. It also prints the value associated with the time key, which is the total time taken to perform the search.\n  \n</details>\n\nor use:\n\n```\nyoudotcom -example\n```\n\n> **Note**\n> YouDotCom is in Alpha and there will be bugs!\n\n\n## install\n\nTo install the YouDotCom Python Library, use the following command:\n\n```\npip install youdotcom\n```\nThis will install the latest version of the youdotcom package. To install a specific version, use:\n\n```\npip install youdotcom==0.3.0\n```\nOnce the installation is complete, you can use the youdotcom package in your Python scripts by importing it:\n\n```python\nimport youdotcom\n```\n\n## YouDotCom roadmap\n* [x] add youchat\n* [x] add youcode\n* [ ] swith to using you.com/api\n* [ ] make code faster\n* [ ] add code translate \n* [ ] add all of you.com apps\n\n\n## Discord\nIn addition to the YouDotCom Python Library, we also have an active [Discord server](https://discord.gg/SD7wZMFSvV) where you can chat with developers and get help with using the library. Our Discord community is a great place to ask questions, share your projects, and get feedback from other developers.\n\n\n## Credits\n\nThis software uses the following open source packages:\n\n- [undetected-chromedriver](https://github.com/ultrafunkamsterdam/undetected-chromedriver)\n\n\n## License\n\nMIT\n\n---\n\n\n',
    'author': 'youdotcom',
    'author_email': 'silkepilon2009@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/silkepilon/youdotcom',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
