import os, sys

def fimport(basename, methodname=None, basename_two=None, level=0, catch_lambda=None):
	"""
	The safe_import function is a helper function that helps to dynamically import modules.
	It is used by the other functions in this file, and it can be used for any python code
	that needs to import modules.  It works by importing the module name given as an argument,
	and if that fails (by raising an ImportError), then it attempts to install the package with:

	Example:
	* abspath = safe_import("os.path", "abspath")
	* rule_mgmt = safe_import("rules", "rule_mgmt", "pysrc.rules")
		* > This will try to import "rules.rule_mgmt"
		* > "rules.rule_mgmt" will fail, so it will try to import "pysrc.rules.rule_mgmt"

	:param basename: Specify the name of the module to import
	:param methodname=None (str or list): Specify the name of the class or function to import
	:param basename_two=None: Specify an alternate name to try importing the package as
	:param level=0: Import a module from the current folder
	:param catch_lambda: The lambda function to call (no args) if the import fails at any level
	:return: The output of the __import__ function
	:doc-author: Trelent
	"""
	if basename_two:
		try:
			__import__(basename,level=level)
		except Exception as e:
			basename = basename_two
			if catch_lambda:
				catch_lambda()

	try:
		__import__(basename,level=level)
	except Exception as e:
		os.system("{0} -m pip install --upgrade {1}".format(sys.executable, basename.split('.')[0]))
		if catch_lambda:
			catch_lambda()

	fromlist = basename.split('.')[1:] if "." in basename else []
	output = __import__(basename,fromlist=fromlist,level=level)

	if isinstance(methodname, str):
		return getattr(output, methodname)
	elif isinstance(methodname, list):
		return [
			getattr(output, method) for method in methodname
		]

	return output