# Code generated by TRAC

from __future__ import annotations
import typing as _tp  # noqa
import dataclasses as _dc  # noqa
import enum as _enum  # noqa

from .type import *  # noqa


class ObjectType(_enum.Enum):

    """
    Enumeration of TRAC's core object types.
    
    .. seealso::
        :class:`ObjectDefinition <ObjectDefinition>`
    """

    OBJECT_TYPE_NOT_SET = 0, 

    DATA = 1, 

    MODEL = 2, 

    FLOW = 3, 

    JOB = 4, 

    FILE = 5, 

    CUSTOM = 6, 

    STORAGE = 7, 

    SCHEMA = 8, 


@_dc.dataclass
class TagHeader:

    """
    A tag header describes the identity and version of an object.
    
    .. seealso::
        :class:`Tag <Tag>`,
        :class:`ObjectDefinition <ObjectDefinition>`
    """

    objectType: ObjectType = ObjectType.OBJECT_TYPE_NOT_SET

    """
    Object type of the object this tag is associated with.
    
    .. seealso::
        :class:`ObjectType <ObjectType>`
    """

    objectId: str = None

    """
    Object ID of the object this tag is associated with.
    
    Object IDs are UUIDs (RFC4122, https://www.ietf.org/rfc/rfc4122.txt)
    """

    objectVersion: int = None

    """Version of the object this tag is associated with."""

    objectTimestamp: DatetimeValue = None

    """Timestamp for when this version of the object was created."""

    tagVersion: int = None

    """Version of this tag."""

    tagTimestamp: DatetimeValue = None

    """Timestamp for when this version of the tag was created."""


@_dc.dataclass
class TagSelector:

    """
    A tag selector describes the selection of a unique object at a point in time.
    
    A tag selector refers to a single object ID and provides criteria for
    selecting the object version and tag version. The available selection
    criteria are:
    
     - Select an explicit version number
     - Select the latest available version
     - Select the version that was live at specific point in time
    
    A selector for an explicit version number will always match that exact
    version number. These "fixed" types of selector can be used to refer to
    elements of a repeatable job, because the versions they refer to will never
    change.
    
    A selector for the latest version will select different versions over time,
    as they become available. These "variable" types of selector can be used by
    client applications that want to query the latest state of an object. If a
    job is set up using variable selectors, TRAC will convert them to fixed
    selectors for the particular versions that were selected before saving the
    job definition.
    
    Criteria for object versions and tag versions can be "mixed and matched", so
    e.g. latestObject = true with tagVersion = 1 is allowed.
    
    .. seealso::
        :class:`Tag <Tag>`,
        :class:`TagHeader <TagHeader>`
    """

    objectType: ObjectType = ObjectType.OBJECT_TYPE_NOT_SET

    """
    Object type of the tag being selected.
    
    .. seealso::
        :class:`ObjectType <ObjectType>`
    """

    objectId: str = None

    """
    Object ID of the tag being selected.
    
    Object IDs are UUIDs (RFC4122, https://www.ietf.org/rfc/rfc4122.txt)
    """

    latestObject: _tp.Optional[bool] = None

    """
    Select the latest version of the object (the version that is live now).
    
    If this flag is specified, it must be set to true.
    """

    objectVersion: _tp.Optional[int] = None

    """Select an explicit version of the object."""

    objectAsOf: _tp.Optional[DatetimeValue] = None

    """
    Select the version of the object that was live as of a particular point
    in time. Represented using ISO 8601.
    """

    latestTag: _tp.Optional[bool] = None

    """
    Select the latest version of the tag (the version that is live now).
    
    If this flag is specified, it must be set to true.
    """

    tagVersion: _tp.Optional[int] = None

    """Select an explicit version of the tag."""

    tagAsOf: _tp.Optional[DatetimeValue] = None

    """
    Select the version of the tag that was live as of a particular point
    in time. Represented using ISO 8601.
    """
