# Code generated by TRAC

from __future__ import annotations
import typing as _tp  # noqa
import dataclasses as _dc  # noqa
import enum as _enum  # noqa

class BasicType(_enum.Enum):

    """Basic types provide the set of core types available in the TRAC type system."""

    BASIC_TYPE_NOT_SET = 0, 

    BOOLEAN = 1, """A true/false value"""

    INTEGER = 2, """64 bit signed integer"""

    FLOAT = 3, """64 bit signed floating point number (referred to as 'double' in many languages)"""

    STRING = 4, """UTF encoded string value of arbitrary length.
    
    The encoding used (e.g. UTF-8, UTF-16, UCS-16) varies between languages / platforms,
    generally TRAC will present strings using the standard encoding for a given language or
    protocol.
    """

    DECIMAL = 5, """A fixed-point decimal value with known precision and scale.
    
    The available precision and scale may vary between languages / platforms.
    
    For metadata attributes, TRAC provides the following guarantees on precision:
         precision >= 31
         scale >= 10
         precision - scale >= 21
    """

    DATE = 6, """A date value.
    
    Dates do not take any account of time zones or offsets from UTC.
    """

    DATETIME = 7, """A date-time value.
    
    Date-time values may be expressed with an offset from UTC, as per ISO 8601.
    The available sub-second precision may vary depending on language / platform.
    
    For metadata attributes, TRAC represents all date-times as in UTC with
    microsecond precision. Incoming values will be converted to UTC if they are
    supplied with an offset.
    """

    ARRAY = 8, """An array of values, which may be primitive or composite values.
    
    All items in an array must have the same type (i.e. the same type descriptor).
    """

    MAP = 9, """An key-value map with string keys, values may be primitive or composite values.
    
    Maps may be uniform, in which case all the values are of the same type, or non-
    uniform in which case values can be of any type. For uniform maps the type
    descriptor will specify the type contained in the map. For non-uniform maps the
    type descriptor can only specify that the map is non-uniform, values must be
    examined at run time to determine their type.
    
    .. seealso::
        :class:`TypeDescriptor <TypeDescriptor>`
    """


@_dc.dataclass
class TypeDescriptor:

    """
    A type descriptor describes a data type used in the TRAC platform.
    
    For complex types, the descriptor holds a full type description. E.g. for
    array types, the type being held in the array is described. At a later point,
    precision fields may be introduced for decimals, or field types for structs.
    """

    basicType: BasicType = BasicType.BASIC_TYPE_NOT_SET

    """The basic type being described."""

    arrayType: _tp.Optional[TypeDescriptor] = None

    """For array types only, describe the type contained in the array."""

    mapType: _tp.Optional[TypeDescriptor] = None

    """
    For map types only, describe the type contained in the map.
    
    To describe a uniform map the mapType descriptor must be set to a valid
    type descriptor, in this case all values in the map must match the type
    of the descriptor. If mapType is not set or is present but has
    basicType = BASIC_TYPE_NOT_SET then the map is non-uniform, values must
    be inspected individually to determine their type.
    """


@_dc.dataclass
class DecimalValue:

    """
    Represent a decimal value.
    
    .. seealso::
        :class:`DECIMAL <BasicType.DECIMAL>`
    """

    decimal: str = None


@_dc.dataclass
class DateValue:

    """
    Represent a date value.
    
    Dates are represented as strings in ISO 8601 format.
    
    .. seealso::
        :class:`DATE <BasicType.DATE>`
    """

    isoDate: str = None


@_dc.dataclass
class DatetimeValue:

    """
    Represent a date-time value.
    
    Date-times are represented as strings in ISO 8601 format.
    
    .. seealso::
        :class:`DATETIME <BasicType.DATETIME>`
    """

    isoDatetime: str = None


@_dc.dataclass
class Value:

    """
    A value expressed in the TRAC type system.
    
    A value can express a primitive value, or a composite value such as an array.
    Arbitrary nesting of composite types is permitted, although most functions
    will limit the set of acceptable types during validation.
    
    Values include a type descriptor field. For primitive values the type
    descriptor is optional. For composite types the root value must include a
    full valid type descriptor, i.e. a descriptor that goes down to the leaf
    types. Sub-values in a composite type are free to omit the type descriptor,
    even if there are multiple levels of nesting, however any extra descriptors
    that are provided must also be full and valid.
    
    TRAC will always provide values with the type descriptors "normalised". This
    means that a root value will always have a type descriptor (even if it is a
    primitive type) and sub-values will never have a type descriptor. It is not
    necessary or preferred for application code to send values to TRAC with
    normalised type descriptors, TRAC will always perform normalisation.
    
    .. seealso::
        :class:`TypeDescriptor <TypeDescriptor>`
    """

    type: TypeDescriptor = None

    """
    Type descriptor for the current value.
    
    A type descriptor is always required for values that are the root of a
    composite type, otherwise it is optional.
    """

    booleanValue: _tp.Optional[bool] = None

    """
    A boolean value.
    
    Represented natively in both protobuf and JSON.
    """

    integerValue: _tp.Optional[int] = None

    """
    A 64-bit signed integer value.
    
    Represented natively in both protobuf and JSON.
    
    In JavaScript and JSON, native integers may be limited to less than
    full range of a 64 bit integer. This is because JavaScript has a
    single Number type that represents both integers and floats. The safe
    limit for integers that can be expressed without a risk of rounding
    in JavaScript is Number.MAX_SAFE_INTEGER.
    """

    floatValue: _tp.Optional[float] = None

    """
    A 64-bit signed floating point value.
    
    Represented natively in both protobuf and JSON.
    """

    stringValue: _tp.Optional[str] = None

    """
    A string value.
    
    Protobuf encodes strings as UTF-8 on the wire. String values in JSON
    requests are also be encoded as UTF-8 on the wire, as per RFC 8259.
    When reading or writing string values in application code, they will
    be presented in the normal encoding scheme of application's coding
    language.
    """

    decimalValue: _tp.Optional[DecimalValue] = None

    """
    A decimal value with fixed precision and scale.
    
    .. seealso::
        :class:`DECIMAL <BasicType.DECIMAL>`
    """

    dateValue: _tp.Optional[DateValue] = None

    """
    A date value.
    
    .. seealso::
        :class:`DATE <BasicType.DATE>`,
        :class:`DateValue <DateValue>`
    """

    datetimeValue: _tp.Optional[DatetimeValue] = None

    """
    A date-time value.
    
    Date-times are represented as strings in ISO 8601 format.
    
    Date-time values support nanosecond precision, however in practice
    the available precision may be less than this. In particular,
    tag attributes are always stored at microsecond precision. Values
    passed into models or used in application code will be limited to the
    precision supported by date-time types in their own coding language.
    
    Time zone offsets are supported as described in ISO 8601. Date-time
    values should always include a zone offset to guarantee behaviour.
    If a zone offset is not supplied TRAC will normalized incoming values
    by applying a zone offset, currently the applied offset will be UTC.
    
    .. seealso::
        :class:`DATETIME <BasicType.DATETIME>`,
        :class:`DatetimeValue <DatetimeValue>`
    """

    arrayValue: _tp.Optional[ArrayValue] = None

    """
    An array of Values.
    
    All items in an array must have the same type.
    
    .. seealso::
        :class:`ARRAY <BasicType.ARRAY>`
    """

    mapValue: _tp.Optional[MapValue] = None

    """
    A map of string keys to Values.
    
    Maps may be uniform (holding all the same value type) or non-uniform
    (holding mixed value types) depending on the type descriptor of this
    Value.
    
    .. seealso::
        :class:`MAP <BasicType.MAP>`,
        :class:`TypeDescriptor <TypeDescriptor>`
    """


@_dc.dataclass
class ArrayValue:

    """
    An array value holds an array of other Values.
    
    All items in an array must have the same type.
    
    .. seealso::
        :class:`ARRAY <BasicType.ARRAY>`
    """

    items: _tp.List[Value] = _dc.field(default_factory=list)


@_dc.dataclass
class MapValue:

    """
    A map value holds a map of string keys to other Values.
    
    Maps may be uniform (holding all the same value type) or non-uniform (holding
    mixed value types) depending on the type descriptor of the Value that
    contains them.
    
    .. seealso::
        :class:`MAP <BasicType.MAP>`,
        :class:`TypeDescriptor <TypeDescriptor>`
    """

    entries: _tp.Dict[str, trac.metadata.Value] = _dc.field(default_factory=list)
