# Code generated by TRAC

from __future__ import annotations
import typing as _tp  # noqa
import dataclasses as _dc  # noqa
import enum as _enum  # noqa

from .type import *  # noqa
from .object_id import *  # noqa
from .object import *  # noqa


class TagOperation(_enum.Enum):

    """
    Enumeration of available TagUpdate operations.
    
    .. seealso::
        :class:`TagUpdate <TagUpdate>`
    """

    CREATE_OR_REPLACE_ATTR = 0, """Add an attribute to a tag or replace it if it already exists.
    
    This is the default operation if no operation is specified. If the
    attribute does not exist it will be created using CREATE_ATTR, otherwise
    it will replaced using REPLACE_ATTR.
    
    .. seealso::
        :class:`CREATE_ATTR <TagOperation.CREATE_ATTR>`,
        :class:`REPLACE_ATTR <TagOperation.REPLACE_ATTR>`
    """

    CREATE_OR_APPEND_ATTR = 1, """Add an attribute to a tag or append to it if it already exists.
    
    If the attribute does not exist it will be created using CREATE_ATTR,
    otherwise it will appended to using APPEND_ATTR.
    
    .. seealso::
        :class:`CREATE_ATTR <TagOperation.CREATE_ATTR>`,
        :class:`APPEND_ATTR <TagOperation.APPEND_ATTR>`
    """

    CREATE_ATTR = 2, """Add an attribute to a tag, fail if the attribute already exists."""

    REPLACE_ATTR = 3, """Replace an attribute on a tag, fail if the attribute does not exist.
    
    When replacing an attribute, the new attribute must be of the same basic
    type as the old one. It is allowed to replace a single-valued attribute
    with a multi-valued one and vice-versa (this is not considered to be
    changing the basic type).
    
    Changing the type of attributes is not recommended because it is likely
    to confuse applications that refer to those attributes. If you really
    need to change the type of an attribute (e.g. to correct an error), use
    DELETE_ATTR followed by CREATE_ATTR.
    """

    APPEND_ATTR = 4, """Append one or more values to an existing attribute, fail if the attribute
    does not exist.
    
    The existing attribute may be single- or multi-valued and the append
    operation may add one value or multiple values (i.e. all combinations are
    permitted). The appended value(s) must be of the same basic type as the
    existing value(s).
    """

    DELETE_ATTR = 5, """Remove an attribute from a tag, fail if the attribute does not exist."""

    CLEAR_ALL_ATTR = 6, """Remove all the attributes from a tag.
    
    This operation does not affect controlled attributes, which are still
    managed by TRAC according to its normal rules.
    """


@_dc.dataclass
class Tag:

    """
    Tags are the core informational element of TRAC's metadata model.
    
    A tag is a set of attributes (key-value pairs) associated with an object
    definition, intended for storing descriptive and informational data as well
    as application-level metadata that is not part of the object definition model.
    Here is an example of a set of tag attributes to illustrate some ways they can
    be used::
    
        # A descriptive field intended for human users.
    
        display_name: "Customer accounts for March 2020, corrected April 6th"
    
        # A classification that can be used for searching or indexing.
        # Client applications can also use this to find datasets of a certain
        # type; typically an application will define a set of attributes that are
        # "structural", i.e. the application uses those attributes to decide which
        # objects to present for certain purposes.
    
        dataset_class: "customer_accounts"
    
        # Properties of an item can be added as individual attributes so they can
        # be searched and displayed individually. This avoids the anti-pattern of
        # putting multiple attributes into a single name/label field:
        #    customer_accounts_mar20_scotland_commercial_approved
    
        accounting_date: (DATE) 2020-03-31
        region: "Scotland"
        book: "commercial_property"
        figures_approved: (BOOLEAN) true
    
        # Attributes can be multi-valued. This can be helpful for applying
        # regulatory classifiers, where multiple classifiers may apply to a
        # single item.
    
        data_classification: ["confidential", "gdpr_pii", "audited"]
    
        # TRAC records a number of "controlled" attributes, these are set by the
        # platform and cannot be modified directly through the metadata API.
        # Controlled attributes start with the prefix "trac_".
    
        trac_create_time: (DATETIME) 2020-04-01 10:37:05
        trac_create_user_id: "jane.doe"
        trac_create_user_name: "Jane Doe"
    
    Tags use immutable versioning in the same way as objects - each version of a
    tag is immutable and "updating" a tag means creating a new version with one or
    more modified attributes. Each version of an object has its own series of tags
    starting at tag version 1.
    
    As an example of this versioning, consider a partitioned dataset with daily
    account records. Version X of the dataset contains data up to a certain date
    and might have a tag saying it is signed off. A user/process then adds a new
    partition with the next day's data, creating version X+1. In this case, object
    version X would still be signed off while version X+1 is awaiting approval.
    When version X+1 is approved, the tag for that version can be "updated". The
    application could decide whether to show the most recent version of the data,
    or an earlier version that has the sign-off attribute set.
    
    .. seealso::
        :class:`TagHeader <TagHeader>`,
        :class:`ObjectDefinition <ObjectDefinition>`
    """

    header: TagHeader = None

    """
    The tag header uniquely identifies the current tag and the object it is
    associated with.
    
    .. seealso::
        :class:`TagHeader <TagHeader>`
    """

    attrs: _tp.Dict[str, trac.metadata.Value] = _dc.field(default_factory=list)

    """
    Tag attributes are key-value pairs where the value is a metadata Value.
    
    Attribute values are restricted to primitive types (which are interpreted
    as single-valued attributes) or arrays of primitive types (which are
    interpreted as multi-valued attributes). Any attribute may be single- or
    multi-valued, except BOOLEAN attributes which are always single-valued.
    
    An attribute may change from single- to multi-valued or vice versa when a
    tag is updated, e.g. is a classification is added or removed. An array
    containing a single item is treated as a single-valued attribute, i.e.
    there is no distinction between a single value and an array of one item.
    Single-valued attributes are always returned as primitive types when
    querying the metadata API.
    
    Single- and multi-valued attributes have different search semantics. For
    example, inequalities are not defined on multi-valued attributes. See
    SearchParameters for more details.
    
    .. seealso::
        :class:`SearchParameters <SearchParameters>`
    """

    definition: _tp.Optional[ObjectDefinition] = None

    """
    The object definition that the tag is associated with.
    
    Sometimes the definition may be omitted, for example the results of a
    metadata search include only headers and attributes.
    
    .. seealso::
        :class:`ObjectDefinition <ObjectDefinition>`
    """


@_dc.dataclass
class TagUpdate:

    """
    A tag update is a request for a single update operation on a tag.
    
    Tag updates can be supplied to TRAC via an API call to request updates to a
    tag. They may also be included in TRAC policy objects or client application
    logic, to describe a set of operations that is performed in response to a
    particular action.
    
    .. seealso::
        :class:`MetadataWriteRequest <MetadataWriteRequest>`
    """

    operation: TagOperation = TagOperation.CREATE_OR_REPLACE_ATTR

    """
    The operation requested in this update
    
    .. seealso::
        :class:`TagOperation <TagOperation>`
    """

    attrName: str = None

    """
    Name of the attribute this update refers to.
    
    This field must be supplied for operations that refer to a single
    attribute, otherwise it should be left blank.
    """

    value: _tp.Optional[Value] = None

    """
    Attribute value to use for this update.
    
    This field must be supplied for operations that use a value, otherwise it
    should be omitted.
    
    .. seealso::
        :class:`Value <metadata.Value>`
    """
