"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import tinkoff.invest.grpc.common_pb2
import typing
import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor = ...

class _OperationState:
    ValueType = typing.NewType('ValueType', builtins.int)
    V: typing_extensions.TypeAlias = ValueType
class _OperationStateEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_OperationState.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor = ...
    OPERATION_STATE_UNSPECIFIED: OperationState.ValueType = ...  # 0
    """Статус операции не определён"""

    OPERATION_STATE_EXECUTED: OperationState.ValueType = ...  # 1
    """Исполнена"""

    OPERATION_STATE_CANCELED: OperationState.ValueType = ...  # 2
    """Отменена"""

class OperationState(_OperationState, metaclass=_OperationStateEnumTypeWrapper):
    """Статус запрашиваемых операций"""
    pass

OPERATION_STATE_UNSPECIFIED: OperationState.ValueType = ...  # 0
"""Статус операции не определён"""

OPERATION_STATE_EXECUTED: OperationState.ValueType = ...  # 1
"""Исполнена"""

OPERATION_STATE_CANCELED: OperationState.ValueType = ...  # 2
"""Отменена"""

global___OperationState = OperationState


class _OperationType:
    ValueType = typing.NewType('ValueType', builtins.int)
    V: typing_extensions.TypeAlias = ValueType
class _OperationTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_OperationType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor = ...
    OPERATION_TYPE_UNSPECIFIED: OperationType.ValueType = ...  # 0
    """Тип операции не определён"""

    OPERATION_TYPE_INPUT: OperationType.ValueType = ...  # 1
    """Завод денежных средств"""

    OPERATION_TYPE_BOND_TAX: OperationType.ValueType = ...  # 2
    """Удержание налога по купонам"""

    OPERATION_TYPE_OUTPUT_SECURITIES: OperationType.ValueType = ...  # 3
    """Вывод ЦБ"""

    OPERATION_TYPE_OVERNIGHT: OperationType.ValueType = ...  # 4
    """Доход по сделке РЕПО овернайт"""

    OPERATION_TYPE_TAX: OperationType.ValueType = ...  # 5
    """Удержание налога"""

    OPERATION_TYPE_BOND_REPAYMENT_FULL: OperationType.ValueType = ...  # 6
    """Полное погашение облигаций"""

    OPERATION_TYPE_SELL_CARD: OperationType.ValueType = ...  # 7
    """Продажа ЦБ с карты"""

    OPERATION_TYPE_DIVIDEND_TAX: OperationType.ValueType = ...  # 8
    """Удержание налога по дивидендам"""

    OPERATION_TYPE_OUTPUT: OperationType.ValueType = ...  # 9
    """Вывод денежных средств"""

    OPERATION_TYPE_BOND_REPAYMENT: OperationType.ValueType = ...  # 10
    """Частичное погашение облигаций"""

    OPERATION_TYPE_TAX_CORRECTION: OperationType.ValueType = ...  # 11
    """Корректировка налога"""

    OPERATION_TYPE_SERVICE_FEE: OperationType.ValueType = ...  # 12
    """Удержание комиссии за обслуживание брокерского счёта"""

    OPERATION_TYPE_BENEFIT_TAX: OperationType.ValueType = ...  # 13
    """Удержание налога за материальную выгоду"""

    OPERATION_TYPE_MARGIN_FEE: OperationType.ValueType = ...  # 14
    """Удержание комиссии за непокрытую позицию"""

    OPERATION_TYPE_BUY: OperationType.ValueType = ...  # 15
    """Покупка ЦБ"""

    OPERATION_TYPE_BUY_CARD: OperationType.ValueType = ...  # 16
    """Покупка ЦБ с карты"""

    OPERATION_TYPE_INPUT_SECURITIES: OperationType.ValueType = ...  # 17
    """Завод ЦБ"""

    OPERATION_TYPE_SELL_MARGIN: OperationType.ValueType = ...  # 18
    """Продажа в результате Margin-call"""

    OPERATION_TYPE_BROKER_FEE: OperationType.ValueType = ...  # 19
    """Удержание комиссии за операцию"""

    OPERATION_TYPE_BUY_MARGIN: OperationType.ValueType = ...  # 20
    """Покупка в результате Margin-call"""

    OPERATION_TYPE_DIVIDEND: OperationType.ValueType = ...  # 21
    """Выплата дивидендов"""

    OPERATION_TYPE_SELL: OperationType.ValueType = ...  # 22
    """Продажа ЦБ"""

    OPERATION_TYPE_COUPON: OperationType.ValueType = ...  # 23
    """Выплата купонов"""

    OPERATION_TYPE_SUCCESS_FEE: OperationType.ValueType = ...  # 24
    """Удержание комиссии SuccessFee"""

    OPERATION_TYPE_DIVIDEND_TRANSFER: OperationType.ValueType = ...  # 25
    """Передача дивидендного дохода"""

    OPERATION_TYPE_ACCRUING_VARMARGIN: OperationType.ValueType = ...  # 26
    """Зачисление вариационной маржи"""

    OPERATION_TYPE_WRITING_OFF_VARMARGIN: OperationType.ValueType = ...  # 27
    """Списание вариационной маржи"""

    OPERATION_TYPE_DELIVERY_BUY: OperationType.ValueType = ...  # 28
    """Покупка в рамках экспирации фьючерсного контракта"""

    OPERATION_TYPE_DELIVERY_SELL: OperationType.ValueType = ...  # 29
    """Продажа в рамках экспирации фьючерсного контракта"""

    OPERATION_TYPE_TRACK_MFEE: OperationType.ValueType = ...  # 30
    """Комиссия за управление по счёту автоследования"""

    OPERATION_TYPE_TRACK_PFEE: OperationType.ValueType = ...  # 31
    """Комиссия за результат по счёту автоследования"""

    OPERATION_TYPE_TAX_PROGRESSIVE: OperationType.ValueType = ...  # 32
    """Удержание налога по ставке 15%"""

    OPERATION_TYPE_BOND_TAX_PROGRESSIVE: OperationType.ValueType = ...  # 33
    """Удержание налога по купонам по ставке 15%"""

    OPERATION_TYPE_DIVIDEND_TAX_PROGRESSIVE: OperationType.ValueType = ...  # 34
    """Удержание налога по дивидендам по ставке 15%"""

    OPERATION_TYPE_BENEFIT_TAX_PROGRESSIVE: OperationType.ValueType = ...  # 35
    """Удержание налога за материальную выгоду по ставке 15%"""

    OPERATION_TYPE_TAX_CORRECTION_PROGRESSIVE: OperationType.ValueType = ...  # 36
    """Корректировка налога по ставке 15%"""

    OPERATION_TYPE_TAX_REPO_PROGRESSIVE: OperationType.ValueType = ...  # 37
    """Удержание налога за возмещение по сделкам РЕПО по ставке 15%"""

    OPERATION_TYPE_TAX_REPO: OperationType.ValueType = ...  # 38
    """Удержание налога за возмещение по сделкам РЕПО"""

    OPERATION_TYPE_TAX_REPO_HOLD: OperationType.ValueType = ...  # 39
    """Удержание налога по сделкам РЕПО"""

    OPERATION_TYPE_TAX_REPO_REFUND: OperationType.ValueType = ...  # 40
    """Возврат налога по сделкам РЕПО"""

    OPERATION_TYPE_TAX_REPO_HOLD_PROGRESSIVE: OperationType.ValueType = ...  # 41
    """Удержание налога по сделкам РЕПО по ставке 15%"""

    OPERATION_TYPE_TAX_REPO_REFUND_PROGRESSIVE: OperationType.ValueType = ...  # 42
    """Возврат налога по сделкам РЕПО по ставке 15%"""

    OPERATION_TYPE_DIV_EXT: OperationType.ValueType = ...  # 43
    """Выплата дивидендов на карту"""

class OperationType(_OperationType, metaclass=_OperationTypeEnumTypeWrapper):
    """Тип операции"""
    pass

OPERATION_TYPE_UNSPECIFIED: OperationType.ValueType = ...  # 0
"""Тип операции не определён"""

OPERATION_TYPE_INPUT: OperationType.ValueType = ...  # 1
"""Завод денежных средств"""

OPERATION_TYPE_BOND_TAX: OperationType.ValueType = ...  # 2
"""Удержание налога по купонам"""

OPERATION_TYPE_OUTPUT_SECURITIES: OperationType.ValueType = ...  # 3
"""Вывод ЦБ"""

OPERATION_TYPE_OVERNIGHT: OperationType.ValueType = ...  # 4
"""Доход по сделке РЕПО овернайт"""

OPERATION_TYPE_TAX: OperationType.ValueType = ...  # 5
"""Удержание налога"""

OPERATION_TYPE_BOND_REPAYMENT_FULL: OperationType.ValueType = ...  # 6
"""Полное погашение облигаций"""

OPERATION_TYPE_SELL_CARD: OperationType.ValueType = ...  # 7
"""Продажа ЦБ с карты"""

OPERATION_TYPE_DIVIDEND_TAX: OperationType.ValueType = ...  # 8
"""Удержание налога по дивидендам"""

OPERATION_TYPE_OUTPUT: OperationType.ValueType = ...  # 9
"""Вывод денежных средств"""

OPERATION_TYPE_BOND_REPAYMENT: OperationType.ValueType = ...  # 10
"""Частичное погашение облигаций"""

OPERATION_TYPE_TAX_CORRECTION: OperationType.ValueType = ...  # 11
"""Корректировка налога"""

OPERATION_TYPE_SERVICE_FEE: OperationType.ValueType = ...  # 12
"""Удержание комиссии за обслуживание брокерского счёта"""

OPERATION_TYPE_BENEFIT_TAX: OperationType.ValueType = ...  # 13
"""Удержание налога за материальную выгоду"""

OPERATION_TYPE_MARGIN_FEE: OperationType.ValueType = ...  # 14
"""Удержание комиссии за непокрытую позицию"""

OPERATION_TYPE_BUY: OperationType.ValueType = ...  # 15
"""Покупка ЦБ"""

OPERATION_TYPE_BUY_CARD: OperationType.ValueType = ...  # 16
"""Покупка ЦБ с карты"""

OPERATION_TYPE_INPUT_SECURITIES: OperationType.ValueType = ...  # 17
"""Завод ЦБ"""

OPERATION_TYPE_SELL_MARGIN: OperationType.ValueType = ...  # 18
"""Продажа в результате Margin-call"""

OPERATION_TYPE_BROKER_FEE: OperationType.ValueType = ...  # 19
"""Удержание комиссии за операцию"""

OPERATION_TYPE_BUY_MARGIN: OperationType.ValueType = ...  # 20
"""Покупка в результате Margin-call"""

OPERATION_TYPE_DIVIDEND: OperationType.ValueType = ...  # 21
"""Выплата дивидендов"""

OPERATION_TYPE_SELL: OperationType.ValueType = ...  # 22
"""Продажа ЦБ"""

OPERATION_TYPE_COUPON: OperationType.ValueType = ...  # 23
"""Выплата купонов"""

OPERATION_TYPE_SUCCESS_FEE: OperationType.ValueType = ...  # 24
"""Удержание комиссии SuccessFee"""

OPERATION_TYPE_DIVIDEND_TRANSFER: OperationType.ValueType = ...  # 25
"""Передача дивидендного дохода"""

OPERATION_TYPE_ACCRUING_VARMARGIN: OperationType.ValueType = ...  # 26
"""Зачисление вариационной маржи"""

OPERATION_TYPE_WRITING_OFF_VARMARGIN: OperationType.ValueType = ...  # 27
"""Списание вариационной маржи"""

OPERATION_TYPE_DELIVERY_BUY: OperationType.ValueType = ...  # 28
"""Покупка в рамках экспирации фьючерсного контракта"""

OPERATION_TYPE_DELIVERY_SELL: OperationType.ValueType = ...  # 29
"""Продажа в рамках экспирации фьючерсного контракта"""

OPERATION_TYPE_TRACK_MFEE: OperationType.ValueType = ...  # 30
"""Комиссия за управление по счёту автоследования"""

OPERATION_TYPE_TRACK_PFEE: OperationType.ValueType = ...  # 31
"""Комиссия за результат по счёту автоследования"""

OPERATION_TYPE_TAX_PROGRESSIVE: OperationType.ValueType = ...  # 32
"""Удержание налога по ставке 15%"""

OPERATION_TYPE_BOND_TAX_PROGRESSIVE: OperationType.ValueType = ...  # 33
"""Удержание налога по купонам по ставке 15%"""

OPERATION_TYPE_DIVIDEND_TAX_PROGRESSIVE: OperationType.ValueType = ...  # 34
"""Удержание налога по дивидендам по ставке 15%"""

OPERATION_TYPE_BENEFIT_TAX_PROGRESSIVE: OperationType.ValueType = ...  # 35
"""Удержание налога за материальную выгоду по ставке 15%"""

OPERATION_TYPE_TAX_CORRECTION_PROGRESSIVE: OperationType.ValueType = ...  # 36
"""Корректировка налога по ставке 15%"""

OPERATION_TYPE_TAX_REPO_PROGRESSIVE: OperationType.ValueType = ...  # 37
"""Удержание налога за возмещение по сделкам РЕПО по ставке 15%"""

OPERATION_TYPE_TAX_REPO: OperationType.ValueType = ...  # 38
"""Удержание налога за возмещение по сделкам РЕПО"""

OPERATION_TYPE_TAX_REPO_HOLD: OperationType.ValueType = ...  # 39
"""Удержание налога по сделкам РЕПО"""

OPERATION_TYPE_TAX_REPO_REFUND: OperationType.ValueType = ...  # 40
"""Возврат налога по сделкам РЕПО"""

OPERATION_TYPE_TAX_REPO_HOLD_PROGRESSIVE: OperationType.ValueType = ...  # 41
"""Удержание налога по сделкам РЕПО по ставке 15%"""

OPERATION_TYPE_TAX_REPO_REFUND_PROGRESSIVE: OperationType.ValueType = ...  # 42
"""Возврат налога по сделкам РЕПО по ставке 15%"""

OPERATION_TYPE_DIV_EXT: OperationType.ValueType = ...  # 43
"""Выплата дивидендов на карту"""

global___OperationType = OperationType


class OperationsRequest(google.protobuf.message.Message):
    """Запрос получения списка операций по счёту."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    ACCOUNT_ID_FIELD_NUMBER: builtins.int
    FROM_FIELD_NUMBER: builtins.int
    TO_FIELD_NUMBER: builtins.int
    STATE_FIELD_NUMBER: builtins.int
    FIGI_FIELD_NUMBER: builtins.int
    account_id: typing.Text = ...
    """Идентификатор счёта клиента"""

    @property
    def to(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Окончание периода (по UTC)"""
        pass
    state: global___OperationState.ValueType = ...
    """Статус запрашиваемых операций"""

    figi: typing.Text = ...
    """Figi-идентификатор инструмента для фильтрации"""

    def __init__(self,
        *,
        account_id : typing.Text = ...,
        to : typing.Optional[google.protobuf.timestamp_pb2.Timestamp] = ...,
        state : global___OperationState.ValueType = ...,
        figi : typing.Text = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["from",b"from","to",b"to"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["account_id",b"account_id","figi",b"figi","from",b"from","state",b"state","to",b"to"]) -> None: ...
global___OperationsRequest = OperationsRequest

class OperationsResponse(google.protobuf.message.Message):
    """Список операций."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    OPERATIONS_FIELD_NUMBER: builtins.int
    @property
    def operations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Operation]:
        """Массив операций"""
        pass
    def __init__(self,
        *,
        operations : typing.Optional[typing.Iterable[global___Operation]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["operations",b"operations"]) -> None: ...
global___OperationsResponse = OperationsResponse

class Operation(google.protobuf.message.Message):
    """Данные по операции."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    ID_FIELD_NUMBER: builtins.int
    PARENT_OPERATION_ID_FIELD_NUMBER: builtins.int
    CURRENCY_FIELD_NUMBER: builtins.int
    PAYMENT_FIELD_NUMBER: builtins.int
    PRICE_FIELD_NUMBER: builtins.int
    STATE_FIELD_NUMBER: builtins.int
    QUANTITY_FIELD_NUMBER: builtins.int
    QUANTITY_REST_FIELD_NUMBER: builtins.int
    FIGI_FIELD_NUMBER: builtins.int
    INSTRUMENT_TYPE_FIELD_NUMBER: builtins.int
    DATE_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    OPERATION_TYPE_FIELD_NUMBER: builtins.int
    id: typing.Text = ...
    """Идентификатор операции"""

    parent_operation_id: typing.Text = ...
    """Идентификатор родительской операции"""

    currency: typing.Text = ...
    """Валюта операции"""

    @property
    def payment(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
        """Сумма операции"""
        pass
    @property
    def price(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
        """Цена операции"""
        pass
    state: global___OperationState.ValueType = ...
    """Статус операции"""

    quantity: builtins.int = ...
    """Количество лотов инструмента"""

    quantity_rest: builtins.int = ...
    """Неисполненный остаток по сделке"""

    figi: typing.Text = ...
    """Figi-идентификатор инструмента, связанного с операцией"""

    instrument_type: typing.Text = ...
    """Тип инструмента. Возможные значения: </br>**bond** — облигация; </br>**share** — акция; </br>**currency** — валюта; </br>**etf** — фонд; </br>**futures** — фьючерс."""

    @property
    def date(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Дата и время операции в формате часовом поясе UTC"""
        pass
    type: typing.Text = ...
    """Текстовое описание типа операции"""

    operation_type: global___OperationType.ValueType = ...
    """Тип операции"""

    def __init__(self,
        *,
        id : typing.Text = ...,
        parent_operation_id : typing.Text = ...,
        currency : typing.Text = ...,
        payment : typing.Optional[tinkoff.invest.grpc.common_pb2.MoneyValue] = ...,
        price : typing.Optional[tinkoff.invest.grpc.common_pb2.MoneyValue] = ...,
        state : global___OperationState.ValueType = ...,
        quantity : builtins.int = ...,
        quantity_rest : builtins.int = ...,
        figi : typing.Text = ...,
        instrument_type : typing.Text = ...,
        date : typing.Optional[google.protobuf.timestamp_pb2.Timestamp] = ...,
        type : typing.Text = ...,
        operation_type : global___OperationType.ValueType = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["date",b"date","payment",b"payment","price",b"price"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["currency",b"currency","date",b"date","figi",b"figi","id",b"id","instrument_type",b"instrument_type","operation_type",b"operation_type","parent_operation_id",b"parent_operation_id","payment",b"payment","price",b"price","quantity",b"quantity","quantity_rest",b"quantity_rest","state",b"state","type",b"type"]) -> None: ...
global___Operation = Operation

class PortfolioRequest(google.protobuf.message.Message):
    """Запрос получения текущего портфеля по счёту."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    ACCOUNT_ID_FIELD_NUMBER: builtins.int
    account_id: typing.Text = ...
    """Идентификатор счёта пользователя"""

    def __init__(self,
        *,
        account_id : typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["account_id",b"account_id"]) -> None: ...
global___PortfolioRequest = PortfolioRequest

class PortfolioResponse(google.protobuf.message.Message):
    """Текущий портфель по счёту."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    TOTAL_AMOUNT_SHARES_FIELD_NUMBER: builtins.int
    TOTAL_AMOUNT_BONDS_FIELD_NUMBER: builtins.int
    TOTAL_AMOUNT_ETF_FIELD_NUMBER: builtins.int
    TOTAL_AMOUNT_CURRENCIES_FIELD_NUMBER: builtins.int
    TOTAL_AMOUNT_FUTURES_FIELD_NUMBER: builtins.int
    EXPECTED_YIELD_FIELD_NUMBER: builtins.int
    POSITIONS_FIELD_NUMBER: builtins.int
    @property
    def total_amount_shares(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
        """Общая стоимость акций в портфеле в рублях"""
        pass
    @property
    def total_amount_bonds(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
        """Общая стоимость облигаций в портфеле в рублях"""
        pass
    @property
    def total_amount_etf(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
        """Общая стоимость фондов в портфеле в рублях"""
        pass
    @property
    def total_amount_currencies(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
        """Общая стоимость валют в портфеле в рублях"""
        pass
    @property
    def total_amount_futures(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
        """Общая стоимость фьючерсов в портфеле в рублях"""
        pass
    @property
    def expected_yield(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Текущая доходность портфеля"""
        pass
    @property
    def positions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___PortfolioPosition]:
        """Список позиций портфеля"""
        pass
    def __init__(self,
        *,
        total_amount_shares : typing.Optional[tinkoff.invest.grpc.common_pb2.MoneyValue] = ...,
        total_amount_bonds : typing.Optional[tinkoff.invest.grpc.common_pb2.MoneyValue] = ...,
        total_amount_etf : typing.Optional[tinkoff.invest.grpc.common_pb2.MoneyValue] = ...,
        total_amount_currencies : typing.Optional[tinkoff.invest.grpc.common_pb2.MoneyValue] = ...,
        total_amount_futures : typing.Optional[tinkoff.invest.grpc.common_pb2.MoneyValue] = ...,
        expected_yield : typing.Optional[tinkoff.invest.grpc.common_pb2.Quotation] = ...,
        positions : typing.Optional[typing.Iterable[global___PortfolioPosition]] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["expected_yield",b"expected_yield","total_amount_bonds",b"total_amount_bonds","total_amount_currencies",b"total_amount_currencies","total_amount_etf",b"total_amount_etf","total_amount_futures",b"total_amount_futures","total_amount_shares",b"total_amount_shares"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["expected_yield",b"expected_yield","positions",b"positions","total_amount_bonds",b"total_amount_bonds","total_amount_currencies",b"total_amount_currencies","total_amount_etf",b"total_amount_etf","total_amount_futures",b"total_amount_futures","total_amount_shares",b"total_amount_shares"]) -> None: ...
global___PortfolioResponse = PortfolioResponse

class PositionsRequest(google.protobuf.message.Message):
    """Запрос позиций портфеля по счёту."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    ACCOUNT_ID_FIELD_NUMBER: builtins.int
    account_id: typing.Text = ...
    """Идентификатор счёта пользователя"""

    def __init__(self,
        *,
        account_id : typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["account_id",b"account_id"]) -> None: ...
global___PositionsRequest = PositionsRequest

class PositionsResponse(google.protobuf.message.Message):
    """Список позиций по счёту."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    MONEY_FIELD_NUMBER: builtins.int
    BLOCKED_FIELD_NUMBER: builtins.int
    SECURITIES_FIELD_NUMBER: builtins.int
    LIMITS_LOADING_IN_PROGRESS_FIELD_NUMBER: builtins.int
    FUTURES_FIELD_NUMBER: builtins.int
    @property
    def money(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[tinkoff.invest.grpc.common_pb2.MoneyValue]:
        """Массив валютных позиций портфеля"""
        pass
    @property
    def blocked(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[tinkoff.invest.grpc.common_pb2.MoneyValue]:
        """Массив заблокированных валютных позиций портфеля"""
        pass
    @property
    def securities(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___PositionsSecurities]:
        """Список ценно-бумажных позиций портфеля"""
        pass
    limits_loading_in_progress: builtins.bool = ...
    """Признак идущей в данный момент выгрузки лимитов"""

    @property
    def futures(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___PositionsFutures]:
        """Список фьючерсов портфеля"""
        pass
    def __init__(self,
        *,
        money : typing.Optional[typing.Iterable[tinkoff.invest.grpc.common_pb2.MoneyValue]] = ...,
        blocked : typing.Optional[typing.Iterable[tinkoff.invest.grpc.common_pb2.MoneyValue]] = ...,
        securities : typing.Optional[typing.Iterable[global___PositionsSecurities]] = ...,
        limits_loading_in_progress : builtins.bool = ...,
        futures : typing.Optional[typing.Iterable[global___PositionsFutures]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["blocked",b"blocked","futures",b"futures","limits_loading_in_progress",b"limits_loading_in_progress","money",b"money","securities",b"securities"]) -> None: ...
global___PositionsResponse = PositionsResponse

class WithdrawLimitsRequest(google.protobuf.message.Message):
    """Запрос доступного для вывода остатка."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    ACCOUNT_ID_FIELD_NUMBER: builtins.int
    account_id: typing.Text = ...
    """Идентификатор счёта пользователя"""

    def __init__(self,
        *,
        account_id : typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["account_id",b"account_id"]) -> None: ...
global___WithdrawLimitsRequest = WithdrawLimitsRequest

class WithdrawLimitsResponse(google.protobuf.message.Message):
    """Доступный для вывода остаток."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    MONEY_FIELD_NUMBER: builtins.int
    BLOCKED_FIELD_NUMBER: builtins.int
    BLOCKED_GUARANTEE_FIELD_NUMBER: builtins.int
    @property
    def money(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[tinkoff.invest.grpc.common_pb2.MoneyValue]:
        """Массив валютных позиций портфеля"""
        pass
    @property
    def blocked(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[tinkoff.invest.grpc.common_pb2.MoneyValue]:
        """Массив заблокированных валютных позиций портфеля"""
        pass
    @property
    def blocked_guarantee(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[tinkoff.invest.grpc.common_pb2.MoneyValue]:
        """Заблокировано под гарантийное обеспечение фьючерсов"""
        pass
    def __init__(self,
        *,
        money : typing.Optional[typing.Iterable[tinkoff.invest.grpc.common_pb2.MoneyValue]] = ...,
        blocked : typing.Optional[typing.Iterable[tinkoff.invest.grpc.common_pb2.MoneyValue]] = ...,
        blocked_guarantee : typing.Optional[typing.Iterable[tinkoff.invest.grpc.common_pb2.MoneyValue]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["blocked",b"blocked","blocked_guarantee",b"blocked_guarantee","money",b"money"]) -> None: ...
global___WithdrawLimitsResponse = WithdrawLimitsResponse

class PortfolioPosition(google.protobuf.message.Message):
    """Позиции портфеля."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    FIGI_FIELD_NUMBER: builtins.int
    INSTRUMENT_TYPE_FIELD_NUMBER: builtins.int
    QUANTITY_FIELD_NUMBER: builtins.int
    AVERAGE_POSITION_PRICE_FIELD_NUMBER: builtins.int
    EXPECTED_YIELD_FIELD_NUMBER: builtins.int
    CURRENT_NKD_FIELD_NUMBER: builtins.int
    AVERAGE_POSITION_PRICE_PT_FIELD_NUMBER: builtins.int
    CURRENT_PRICE_FIELD_NUMBER: builtins.int
    figi: typing.Text = ...
    """Figi-идентификатора инструмента"""

    instrument_type: typing.Text = ...
    """Тип инструмента"""

    @property
    def quantity(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Количество инструмента в портфеле в штуках"""
        pass
    @property
    def average_position_price(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
        """Средняя цена лота в позиции"""
        pass
    @property
    def expected_yield(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Текущая рассчитанная доходность"""
        pass
    @property
    def current_nkd(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
        """Текущий НКД"""
        pass
    @property
    def average_position_price_pt(self) -> tinkoff.invest.grpc.common_pb2.Quotation:
        """Средняя цена лота в позиции в пунктах (для фьючерсов)"""
        pass
    @property
    def current_price(self) -> tinkoff.invest.grpc.common_pb2.MoneyValue:
        """Текущая цена инструмента"""
        pass
    def __init__(self,
        *,
        figi : typing.Text = ...,
        instrument_type : typing.Text = ...,
        quantity : typing.Optional[tinkoff.invest.grpc.common_pb2.Quotation] = ...,
        average_position_price : typing.Optional[tinkoff.invest.grpc.common_pb2.MoneyValue] = ...,
        expected_yield : typing.Optional[tinkoff.invest.grpc.common_pb2.Quotation] = ...,
        current_nkd : typing.Optional[tinkoff.invest.grpc.common_pb2.MoneyValue] = ...,
        average_position_price_pt : typing.Optional[tinkoff.invest.grpc.common_pb2.Quotation] = ...,
        current_price : typing.Optional[tinkoff.invest.grpc.common_pb2.MoneyValue] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["average_position_price",b"average_position_price","average_position_price_pt",b"average_position_price_pt","current_nkd",b"current_nkd","current_price",b"current_price","expected_yield",b"expected_yield","quantity",b"quantity"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["average_position_price",b"average_position_price","average_position_price_pt",b"average_position_price_pt","current_nkd",b"current_nkd","current_price",b"current_price","expected_yield",b"expected_yield","figi",b"figi","instrument_type",b"instrument_type","quantity",b"quantity"]) -> None: ...
global___PortfolioPosition = PortfolioPosition

class PositionsSecurities(google.protobuf.message.Message):
    """Баланс позиции ценной бумаги."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    FIGI_FIELD_NUMBER: builtins.int
    BLOCKED_FIELD_NUMBER: builtins.int
    BALANCE_FIELD_NUMBER: builtins.int
    figi: typing.Text = ...
    """Figi-идентификатор бумаги"""

    blocked: builtins.int = ...
    """Заблокировано"""

    balance: builtins.int = ...
    """Текущий баланс"""

    def __init__(self,
        *,
        figi : typing.Text = ...,
        blocked : builtins.int = ...,
        balance : builtins.int = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["balance",b"balance","blocked",b"blocked","figi",b"figi"]) -> None: ...
global___PositionsSecurities = PositionsSecurities

class PositionsFutures(google.protobuf.message.Message):
    """Баланс фьючерса."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    FIGI_FIELD_NUMBER: builtins.int
    BLOCKED_FIELD_NUMBER: builtins.int
    BALANCE_FIELD_NUMBER: builtins.int
    figi: typing.Text = ...
    """Figi-идентификатор фьючерса"""

    blocked: builtins.int = ...
    """Заблокировано"""

    balance: builtins.int = ...
    """Текущий баланс"""

    def __init__(self,
        *,
        figi : typing.Text = ...,
        blocked : builtins.int = ...,
        balance : builtins.int = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["balance",b"balance","blocked",b"blocked","figi",b"figi"]) -> None: ...
global___PositionsFutures = PositionsFutures
