from setuptools import setup, find_packages

with open('requirements.txt') as f:
    requirements = f.read()

requirements = requirements.splitlines()

with open('README.md') as f:
    readme = f.read()

packages = find_packages()

setup(
    name='superannotate',
    version='1.5.7',
    description='Python SDK to SuperAnnotate platform',
    license='MIT',
    author='Hovnatan Karapetyan',
    author_email='hovnatan@superannotate.com',
    url='https://github.com/superannotateai/superannotate-python-sdk',
    long_description=readme,
    long_description_content_type='text/markdown',
    install_requires=requirements,
    setup_requires=['wheel'],
    packages=find_packages(exclude=('tests', )),
    # entry_points={
    #     'console_scripts': ['superannotate = superannotate.__main__:main']
    # },
    python_requires='>=3.6'
)
