"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SuperDomain = exports.ELBtype = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const certmgr = require("@aws-cdk/aws-certificatemanager");
const r53 = require("@aws-cdk/aws-route53");
const r53tg = require("@aws-cdk/aws-route53-targets");
const cdk = require("@aws-cdk/core");
/**
 * @experimental
 */
var ELBtype;
(function (ELBtype) {
    ELBtype["ALB"] = "ALB";
    ELBtype["NLB"] = "NLB";
})(ELBtype = exports.ELBtype || (exports.ELBtype = {}));
/**
 * @experimental
 */
class SuperDomain extends cdk.Construct {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _b;
        super(scope, id);
        this.zone = this._setzone(props);
        this.acm = (_b = props.acm) !== null && _b !== void 0 ? _b : this._setacm(props);
        this.record = this._setaliasrecord(props);
    }
    _setzone(props) {
        return r53.HostedZone.fromHostedZoneAttributes(this, 'zone', {
            hostedZoneId: props.hostedZoneId,
            zoneName: props.zoneName,
        });
    }
    _setacm(props) {
        return new certmgr.Certificate(this, 'cert', {
            domainName: `*.${props.zoneName}`,
            validation: certmgr.CertificateValidation.fromDns(this.zone),
        });
    }
    _setaliasrecord(props) {
        var _b;
        return new r53.ARecord(this, 'alias-alb', {
            zone: this.zone,
            target: r53.RecordTarget.fromAlias(new r53tg.LoadBalancerTarget(props.loadbalancer)),
            recordName: props.recordName,
            ttl: (_b = props.ttl) !== null && _b !== void 0 ? _b : cdk.Duration.minutes(5),
        });
    }
}
exports.SuperDomain = SuperDomain;
_a = JSII_RTTI_SYMBOL_1;
SuperDomain[_a] = { fqn: "@cdk-constructs-zone/super-ec2.SuperDomain", version: "0.0.87" };
//# sourceMappingURL=data:application/json;base64,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