"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NodeProject = exports.AutoRelease = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const common_1 = require("./common");
const auto_merge_1 = require("./github/auto-merge");
const ignore_file_1 = require("./ignore-file");
const jest_1 = require("./jest");
const license_1 = require("./license");
const node_package_1 = require("./node-package");
const project_1 = require("./project");
const projen_upgrade_1 = require("./projen-upgrade");
const publisher_1 = require("./publisher");
const tasks_1 = require("./tasks");
const version_1 = require("./version");
const PROJEN_SCRIPT = 'projen';
/**
 * (experimental) Automatic bump modes.
 *
 * @experimental
 */
var AutoRelease;
(function (AutoRelease) {
    AutoRelease[AutoRelease["EVERY_COMMIT"] = 0] = "EVERY_COMMIT";
    AutoRelease[AutoRelease["DAILY"] = 1] = "DAILY";
})(AutoRelease = exports.AutoRelease || (exports.AutoRelease = {}));
/**
 * (experimental) Node.js project.
 *
 * @experimental
 */
class NodeProject extends project_1.Project {
    /**
     * @experimental
     */
    constructor(options) {
        var _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s, _t, _u, _v, _w, _x, _y, _z, _0, _1, _2, _3, _4, _5, _6;
        super(options);
        this.package = new node_package_1.NodePackage(this, options);
        this.runScriptCommand = (() => {
            switch (this.packageManager) {
                case node_package_1.NodePackageManager.NPM: return 'npm run';
                case node_package_1.NodePackageManager.YARN: return 'yarn run';
                case node_package_1.NodePackageManager.PNPM: return 'pnpm run';
                default: throw new Error(`unexpected package manager ${this.packageManager}`);
            }
        })();
        this.nodeVersion = (_b = options.workflowNodeVersion) !== null && _b !== void 0 ? _b : this.package.minNodeVersion;
        // add PATH for all tasks which includes the project's npm .bin list
        this.tasks.addEnvironment('PATH', '$(npx -c "node -e \\\"console.log(process.env.PATH)\\\"")');
        this.compileTask = this.addTask('compile', {
            description: 'Only compile',
            category: tasks_1.TaskCategory.BUILD,
        });
        this.testCompileTask = this.addTask('test:compile', {
            description: 'compiles the test code',
            category: tasks_1.TaskCategory.TEST,
        });
        this.testTask = this.addTask('test', {
            description: 'Run tests',
            category: tasks_1.TaskCategory.TEST,
        });
        this.testTask.spawn(this.testCompileTask);
        this.buildTask = this.addTask('build', {
            description: 'Full release build (test+compile)',
            category: tasks_1.TaskCategory.BUILD,
        });
        this.addLicense(options);
        this.npmDistTag = this.package.npmDistTag;
        this.npmRegistry = this.package.npmRegistry;
        if ((_c = options.npmignoreEnabled) !== null && _c !== void 0 ? _c : true) {
            this.npmignore = new ignore_file_1.IgnoreFile(this, '.npmignore');
        }
        this.addDefaultGitIgnore();
        if ((_d = options.gitignore) === null || _d === void 0 ? void 0 : _d.length) {
            for (const i of options.gitignore) {
                this.gitignore.exclude(i);
            }
        }
        if ((_e = options.npmignore) === null || _e === void 0 ? void 0 : _e.length) {
            if (!this.npmignore) {
                throw new Error('.npmignore is not defined for an APP project type. Add "npmIgnore: true" to override this');
            }
            for (const i of options.npmignore) {
                this.npmignore.exclude(i);
            }
        }
        this.setScript(PROJEN_SCRIPT, this.package.projenCommand);
        this.setScript('start', `${this.package.projenCommand} start`);
        (_f = this.npmignore) === null || _f === void 0 ? void 0 : _f.exclude(`/${common_1.PROJEN_RC}`);
        (_g = this.npmignore) === null || _g === void 0 ? void 0 : _g.exclude(`/${common_1.PROJEN_DIR}`);
        this.gitignore.include(`/${common_1.PROJEN_RC}`);
        const projen = (_h = options.projenDevDependency) !== null && _h !== void 0 ? _h : true;
        if (projen) {
            const projenVersion = (_j = options.projenVersion) !== null && _j !== void 0 ? _j : `^${common_1.PROJEN_VERSION}`;
            this.addDevDeps(`projen@${projenVersion}`);
        }
        if (!options.defaultReleaseBranch) {
            throw new Error('"defaultReleaseBranch" is temporarily a required option while we migrate its default value from "master" to "main"');
        }
        const defaultReleaseBranch = (_k = options.defaultReleaseBranch) !== null && _k !== void 0 ? _k : 'main';
        // version is read from a committed file called version.json which is how we bump
        this._version = new version_1.Version(this, { releaseBranch: defaultReleaseBranch });
        this.package.addVersion(this._version.currentVersion);
        const buildEnabled = (_l = options.buildWorkflow) !== null && _l !== void 0 ? _l : (this.parent ? false : true);
        const mutableBuilds = (_m = options.mutableBuild) !== null && _m !== void 0 ? _m : true;
        // indicate if we have anti-tamper configured in our workflows. used by e.g. Jest
        // to decide if we can always run with --updateSnapshot
        this.antitamper = buildEnabled && ((_o = options.antitamper) !== null && _o !== void 0 ? _o : true);
        // configure jest if enabled
        // must be before the build/release workflows
        if ((_p = options.jest) !== null && _p !== void 0 ? _p : true) {
            this.jest = new jest_1.Jest(this, options.jestOptions);
        }
        if ((_q = options.buildWorkflow) !== null && _q !== void 0 ? _q : (this.parent ? false : true)) {
            const branch = '${{ github.event.pull_request.head.ref }}';
            const repo = '${{ github.event.pull_request.head.repo.full_name }}';
            const { workflow, buildJobId } = this.createBuildWorkflow('Build', {
                trigger: {
                    pull_request: {},
                },
                checkoutWith: mutableBuilds ? {
                    ref: branch,
                    repository: repo,
                } : undefined,
                postSteps: [
                    {
                        name: 'Commit and push changes (if any)',
                        run: `git diff --exit-code || (git commit -am "chore: self mutation" && git push origin HEAD:${branch})`,
                    },
                ],
                antitamperDisabled: mutableBuilds,
                image: options.workflowContainerImage,
                codeCov: (_r = options.codeCov) !== null && _r !== void 0 ? _r : false,
                codeCovTokenSecret: options.codeCovTokenSecret,
            });
            this.buildWorkflow = workflow;
            this.buildWorkflowJobId = buildJobId;
        }
        if ((_s = options.releaseWorkflow) !== null && _s !== void 0 ? _s : (this.parent ? false : true)) {
            const releaseBranches = (_t = options.releaseBranches) !== null && _t !== void 0 ? _t : [defaultReleaseBranch];
            const trigger = {};
            if ((_u = options.releaseEveryCommit) !== null && _u !== void 0 ? _u : true) {
                trigger.push = { branches: releaseBranches };
            }
            if (options.releaseSchedule) {
                trigger.schedule = { cron: options.releaseSchedule };
            }
            const artifactDirectory = (_v = options.artifactsDirectory) !== null && _v !== void 0 ? _v : 'dist';
            const { workflow, buildJobId } = this.createBuildWorkflow('Release', {
                trigger,
                preBuildSteps: [{
                        name: 'Bump to next version',
                        run: this.runTaskCommand(this._version.bumpTask),
                    }],
                postSteps: [
                    {
                        name: 'Push commits',
                        run: 'git push origin HEAD:${{ github.ref }}',
                    },
                    {
                        name: 'Push tags',
                        run: 'git push --follow-tags origin ${{ github.ref }}',
                    },
                ],
                artifactDirectory,
                image: options.workflowContainerImage,
                codeCov: (_w = options.codeCov) !== null && _w !== void 0 ? _w : false,
                codeCovTokenSecret: options.codeCovTokenSecret,
                checkoutWith: {
                    // we must use 'fetch-depth=0' in order to fetch all tags
                    // otherwise tags are not checked out
                    'fetch-depth': 0,
                },
            });
            this.releaseWorkflow = workflow;
            this.publisher = new publisher_1.Publisher(this, {
                workflow: this.releaseWorkflow,
                artifactName: artifactDirectory,
                buildJobId,
                jsiiReleaseVersion: options.jsiiReleaseVersion,
            });
            if ((_x = options.releaseToNpm) !== null && _x !== void 0 ? _x : false) {
                this.publisher.publishToNpm({
                    distTag: this.package.npmDistTag,
                    registry: this.package.npmRegistry,
                });
            }
        }
        else {
            // validate that no release options are selected if the release workflow is disabled.
            if (options.releaseToNpm) {
                throw new Error('"releaseToNpm" is not supported for APP projects');
            }
            if (options.releaseBranches) {
                throw new Error('"releaseBranches" is not supported for APP projects');
            }
            if (options.releaseEveryCommit) {
                throw new Error('"releaseEveryCommit" is not supported for APP projects');
            }
            if (options.releaseSchedule) {
                throw new Error('"releaseSchedule" is not supported for APP projects');
            }
        }
        if ((_y = options.mergify) !== null && _y !== void 0 ? _y : true) {
            this.autoMerge = new auto_merge_1.AutoMerge(this, {
                autoMergeLabel: options.mergifyAutoMergeLabel,
                buildJob: this.buildWorkflowJobId,
            });
            (_z = this.npmignore) === null || _z === void 0 ? void 0 : _z.exclude('/.mergify.yml');
        }
        if ((_0 = options.dependabot) !== null && _0 !== void 0 ? _0 : true) {
            (_1 = this.github) === null || _1 === void 0 ? void 0 : _1.addDependabot(options.dependabotOptions);
        }
        const projenAutoMerge = (_2 = options.projenUpgradeAutoMerge) !== null && _2 !== void 0 ? _2 : true;
        new projen_upgrade_1.ProjenUpgrade(this, {
            autoUpgradeSecret: options.projenUpgradeSecret,
            autoUpgradeSchedule: options.projenUpgradeSchedule,
            labels: (projenAutoMerge && ((_3 = this.autoMerge) === null || _3 === void 0 ? void 0 : _3.autoMergeLabel))
                ? [this.autoMerge.autoMergeLabel]
                : [],
        });
        if ((_4 = options.pullRequestTemplate) !== null && _4 !== void 0 ? _4 : true) {
            (_5 = this.github) === null || _5 === void 0 ? void 0 : _5.addPullRequestTemplate(...(_6 = options.pullRequestTemplateContents) !== null && _6 !== void 0 ? _6 : []);
        }
    }
    /**
     * @deprecated use `package.allowLibraryDependencies`
     */
    get allowLibraryDependencies() { return this.package.allowLibraryDependencies; }
    /**
     * @deprecated use `package.entrypoint`
     */
    get entrypoint() { return this.package.entrypoint; }
    /**
     * (experimental) Minimum node.js version required by this package.
     *
     * @experimental
     */
    get minNodeVersion() { return this.package.minNodeVersion; }
    /**
     * (experimental) Maximum node version required by this pacakge.
     *
     * @experimental
     */
    get maxNodeVersion() { return this.package.maxNodeVersion; }
    /**
     * (deprecated) The package manager to use.
     *
     * @deprecated use `package.packageManager`
     */
    get packageManager() { return this.package.packageManager; }
    /**
     * (deprecated) Determines how tasks are executed when invoked as npm scripts (yarn/npm run xyz).
     *
     * @deprecated use `package.npmTaskExecution`
     */
    get npmTaskExecution() { return this.package.npmTaskExecution; }
    /**
     * (experimental) The command to use in order to run the projen CLI.
     *
     * @experimental
     */
    get projenCommand() { return this.package.projenCommand; }
    /**
     * @deprecated use `package.addField(x, y)`
     */
    get manifest() {
        return this.package.manifest;
    }
    /**
     * @experimental
     */
    addBins(bins) {
        this.package.addBin(bins);
    }
    /**
     * (experimental) Replaces the contents of an npm package.json script.
     *
     * @param name The script name.
     * @param command The command to execute.
     * @experimental
     */
    setScript(name, command) {
        this.package.setScript(name, command);
    }
    /**
     * (experimental) Removes the npm script (always successful).
     *
     * @param name The name of the script.
     * @experimental
     */
    removeScript(name) {
        this.package.removeScript(name);
    }
    /**
     * (experimental) Indicates if a script by the name name is defined.
     *
     * @param name The name of the script.
     * @experimental
     */
    hasScript(name) {
        return this.package.hasScript(name);
    }
    /**
     * (deprecated) DEPRECATED.
     *
     * @deprecated use `project.compileTask.exec()`
     */
    addCompileCommand(...commands) {
        for (const c of commands) {
            this.compileTask.exec(c);
        }
    }
    /**
     * (deprecated) DEPRECATED.
     *
     * @deprecated use `project.testTask.exec()`
     */
    addTestCommand(...commands) {
        for (const c of commands) {
            this.testTask.exec(c);
        }
    }
    /**
     * (deprecated) DEPRECATED.
     *
     * @deprecated use `project.buildTask.exec()`
     */
    addBuildCommand(...commands) {
        for (const c of commands) {
            this.buildTask.exec(c);
        }
    }
    /**
     * (experimental) Directly set fields in `package.json`.
     *
     * @param fields The fields to set.
     * @experimental
     */
    addFields(fields) {
        for (const [name, value] of Object.entries(fields)) {
            this.package.addField(name, value);
        }
    }
    /**
     * (experimental) Adds keywords to package.json (deduplicated).
     *
     * @param keywords The keywords to add.
     * @experimental
     */
    addKeywords(...keywords) {
        this.package.addKeywords(...keywords);
    }
    /**
     * @experimental
     */
    get installWorkflowSteps() {
        const install = new Array();
        if (this.nodeVersion) {
            install.push({
                name: 'Setup Node.js',
                uses: 'actions/setup-node@v1',
                with: { 'node-version': this.nodeVersion },
            });
        }
        install.push({
            name: 'Install dependencies',
            run: this.package.installCommand,
        });
        // run "projen"
        install.push({
            name: 'Synthesize project files',
            run: this.package.projenCommand,
        });
        return install;
    }
    /**
     * (experimental) Defines normal dependencies.
     *
     * @param deps Names modules to install.
     * @experimental
     */
    addDeps(...deps) {
        return this.package.addDeps(...deps);
    }
    /**
     * (experimental) Defines development/test dependencies.
     *
     * @param deps Names modules to install.
     * @experimental
     */
    addDevDeps(...deps) {
        return this.package.addDevDeps(...deps);
    }
    /**
     * (experimental) Defines peer dependencies.
     *
     * When adding peer dependencies, a devDependency will also be added on the
     * pinned version of the declared peer. This will ensure that you are testing
     * your code against the minimum version required from your consumers.
     *
     * @param deps Names modules to install.
     * @experimental
     */
    addPeerDeps(...deps) {
        return this.package.addPeerDeps(...deps);
    }
    /**
     * (experimental) Defines bundled dependencies.
     *
     * Bundled dependencies will be added as normal dependencies as well as to the
     * `bundledDependencies` section of your `package.json`.
     *
     * @param deps Names modules to install.
     * @experimental
     */
    addBundledDeps(...deps) {
        return this.package.addBundledDeps(...deps);
    }
    addLicense(options) {
        var _b;
        if (this.package.license) {
            new license_1.License(this, this.package.license, {
                copyrightOwner: (_b = options.copyrightOwner) !== null && _b !== void 0 ? _b : options.authorName,
                copyrightPeriod: options.copyrightPeriod,
            });
        }
    }
    addDefaultGitIgnore() {
        this.gitignore.exclude('# Logs', 'logs', '*.log', 'npm-debug.log*', 'yarn-debug.log*', 'yarn-error.log*', 'lerna-debug.log*', '# Diagnostic reports (https://nodejs.org/api/report.html)', 'report.[0-9]*.[0-9]*.[0-9]*.[0-9]*.json', '# Runtime data', 'pids', '*.pid', '*.seed', '*.pid.lock', '# Directory for instrumented libs generated by jscoverage/JSCover', 'lib-cov', '# Coverage directory used by tools like istanbul', 'coverage', '*.lcov', '# nyc test coverage', '.nyc_output', '# Compiled binary addons (https://nodejs.org/api/addons.html)', 'build/Release', '# Dependency directories', 'node_modules/', 'jspm_packages/', '# TypeScript cache', '*.tsbuildinfo', '# Optional eslint cache', '.eslintcache', '# Output of \'npm pack\'', '*.tgz', '# Yarn Integrity file', '.yarn-integrity', '# parcel-bundler cache (https://parceljs.org/)', '.cache');
    }
    createBuildWorkflow(name, options) {
        var _b, _c, _d, _e;
        const buildJobId = 'build';
        const github = this.github;
        if (!github) {
            throw new Error('no github support');
        }
        const workflow = github.addWorkflow(name);
        if (options.trigger) {
            if (options.trigger.issue_comment) {
                throw new Error('"issue_comment" should not be used as a trigger due to a security issue');
            }
            workflow.on(options.trigger);
        }
        workflow.on({
            workflow_dispatch: {},
        });
        const condition = options.condition ? { if: options.condition } : {};
        const preBuildSteps = (_b = options.preBuildSteps) !== null && _b !== void 0 ? _b : [];
        const preCheckoutSteps = (_c = options.preCheckoutSteps) !== null && _c !== void 0 ? _c : [];
        const checkoutWith = options.checkoutWith ? { with: options.checkoutWith } : {};
        const postSteps = (_d = options.postSteps) !== null && _d !== void 0 ? _d : [];
        const antitamperSteps = (options.antitamperDisabled || !this.antitamper) ? [] : [{
                name: 'Anti-tamper check',
                run: 'git diff --exit-code',
            }];
        const job = {
            'runs-on': 'ubuntu-latest',
            'env': {
                CI: 'true',
            },
            ...condition,
            'steps': [
                ...preCheckoutSteps,
                // check out sources.
                {
                    name: 'Checkout',
                    uses: 'actions/checkout@v2',
                    ...checkoutWith,
                },
                // install dependencies
                ...this.installWorkflowSteps,
                // perform an anti-tamper check immediately after we run projen.
                ...antitamperSteps,
                // sets git identity so we can push later
                {
                    name: 'Set git identity',
                    run: [
                        'git config user.name "Auto-bump"',
                        'git config user.email "github-actions@github.com"',
                    ].join('\n'),
                },
                // if there are changes, creates a bump commit
                ...preBuildSteps,
                // build (compile + test)
                {
                    name: 'Build',
                    run: this.runTaskCommand(this.buildTask),
                },
                // run codecov if enabled or a secret token name is passed in
                // AND jest must be configured
                ...(options.codeCov || options.codeCovTokenSecret) && ((_e = this.jest) === null || _e === void 0 ? void 0 : _e.config) ? [{
                        name: 'Upload coverage to Codecov',
                        uses: 'codecov/codecov-action@v1',
                        with: options.codeCovTokenSecret ? {
                            token: `\${{ secrets.${options.codeCovTokenSecret} }}`,
                            directory: this.jest.config.coverageDirectory,
                        } : {
                            directory: this.jest.config.coverageDirectory,
                        },
                    }] : [],
                // anti-tamper check (fails if there were changes to committed files)
                // this will identify any non-committed files generated during build (e.g. test snapshots)
                ...antitamperSteps,
                ...postSteps,
            ],
        };
        if (options.image) {
            job.container = { image: options.image };
        }
        if (options.artifactDirectory) {
            job.steps.push({
                name: 'Upload artifact',
                uses: 'actions/upload-artifact@v2.1.1',
                with: {
                    name: options.artifactDirectory,
                    path: options.artifactDirectory,
                },
            });
        }
        workflow.addJobs({ [buildJobId]: job });
        return { workflow, buildJobId };
    }
    /**
     * (experimental) Returns the shell command to execute in order to run a task.
     *
     * If
     * npmTaskExecution is set to PROJEN, the command will be `npx projen TASK`.
     * If it is set to SHELL, the command will be `yarn run TASK` (or `npm run
     * TASK`).
     *
     * @param task The task for which the command is required.
     * @experimental
     */
    runTaskCommand(task) {
        switch (this.package.npmTaskExecution) {
            case node_package_1.NpmTaskExecution.PROJEN: return `${this.package.projenCommand} ${task.name}`;
            case node_package_1.NpmTaskExecution.SHELL: return `${this.runScriptCommand} ${task.name}`;
            default:
                throw new Error(`invalid npmTaskExecution mode: ${this.package.npmTaskExecution}`);
        }
    }
}
exports.NodeProject = NodeProject;
_a = JSII_RTTI_SYMBOL_1;
NodeProject[_a] = { fqn: "projen.NodeProject", version: "0.17.20" };
//# sourceMappingURL=data:application/json;base64,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