import * as ec2 from '@aws-cdk/aws-ec2';
import * as cdk from '@aws-cdk/core';
import { AmiOSType } from './ami';
/**
 * @experimental
 */
export interface ISuperEC2BaseProps {
    /**
     * (experimental) Super EC2 OS you want.
     *
     * @default - Amzaon Linux 2.
     * @experimental
     */
    amiOSType?: AmiOSType;
    /**
     * (experimental) Super EC2 Vpc.
     *
     * @default - Create a new Vpc.
     * @experimental
     */
    vpc?: ec2.IVpc;
    /**
     * (experimental) Super EC2 Instance Type.
     *
     * @default - t3.small.
     * @experimental
     */
    instanceType?: ec2.InstanceType;
}
/**
 * @experimental
 */
export declare abstract class SuperEC2Base extends cdk.Construct {
    /**
     * @experimental
     */
    readonly instance: ec2.IInstance;
    /**
     * @experimental
     */
    readonly vpc: ec2.IVpc;
    /**
     * @experimental
     */
    readonly userData: ec2.UserData;
    /**
     * @experimental
     */
    readonly defaultSecurityGroup: ec2.SecurityGroup;
    /**
     * @experimental
     */
    constructor(scope: cdk.Construct, id: string, props: ISuperEC2BaseProps);
}
