"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.amiFinder = exports.AmiOSType = void 0;
const ec2 = require("@aws-cdk/aws-ec2");
/**
 * @experimental
 */
var AmiOSType;
(function (AmiOSType) {
    AmiOSType["UBUNTU_18_04"] = "UBUNTU_18_04";
    AmiOSType["UBUNTU_20_04"] = "UBUNTU_20_04";
    AmiOSType["CENTOS_7"] = "CENTOS_7";
    AmiOSType["CENTOS_8"] = "CENTOS_8";
    AmiOSType["AMAZON_LINUX_2"] = "AMAZON_LINUX_2";
    AmiOSType["AMAZON_LINUX"] = "AMAZON_LINUX";
})(AmiOSType = exports.AmiOSType || (exports.AmiOSType = {}));
function amiFinder(amiostype) {
    switch (amiostype) {
        case AmiOSType.CENTOS_7:
            return ec2.MachineImage.lookup({
                filters: {
                    ['product-code']: ['aw0evgkw8e5c1q413zgy5pjce'],
                },
                name: '*CentOS*',
                owners: ['aws-marketplace'],
            });
        case AmiOSType.CENTOS_8:
            return ec2.MachineImage.lookup({
                filters: {
                    ['product-code']: ['aw0evgkw8e5c1q413zgy5pjce'],
                },
                name: '*CentOS*',
                owners: ['aws-marketplace'],
            });
        case AmiOSType.UBUNTU_18_04:
            return ec2.MachineImage.lookup({
                //name: '*ubuntu/images/hvm-ssd/ubuntu-focal-20.04-amd64-server*',
                name: '*ubuntu-bionic-18.04-amd64-*',
                owners: ['099720109477'],
                filters: {
                    ['root-device-type']: ['ebs'],
                },
            });
        case AmiOSType.UBUNTU_20_04:
            return ec2.MachineImage.lookup({
                name: '*ubuntu/images/hvm-ssd/ubuntu-focal-20.04-amd64-server*',
                owners: ['099720109477'],
                filters: {
                    ['root-device-type']: ['ebs'],
                },
            });
        case AmiOSType.AMAZON_LINUX:
            return ec2.MachineImage.latestAmazonLinux();
        case AmiOSType.AMAZON_LINUX_2:
            return ec2.MachineImage.latestAmazonLinux({ generation: ec2.AmazonLinuxGeneration.AMAZON_LINUX_2 });
    }
}
exports.amiFinder = amiFinder;
//# sourceMappingURL=data:application/json;base64,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