"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TypedocDocgen = void 0;
const tasks_1 = require("./tasks");
/**
  Adds a simple Typescript documentation generator
 */
class TypedocDocgen {
    constructor(project) {
        project.addDevDeps('typedoc@^0.20.35');
        const docgen = project.addTask('docgen', {
            description: `Generate TypeScript API reference ${project.docsDirectory}`,
            category: tasks_1.TaskCategory.RELEASE,
            exec: 'typedoc --out ' + project.docsDirectory,
        });
        project.buildTask.spawn(docgen);
    }
}
exports.TypedocDocgen = TypedocDocgen;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidHlwZXNjcmlwdC10eXBlZG9jLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vc3JjL3R5cGVzY3JpcHQtdHlwZWRvYy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSxtQ0FBdUM7QUFHdkM7O0dBRUc7QUFDSCxNQUFhLGFBQWE7SUFDeEIsWUFBWSxPQUEwQjtRQUNwQyxPQUFPLENBQUMsVUFBVSxDQUFDLGtCQUFrQixDQUFDLENBQUM7UUFFdkMsTUFBTSxNQUFNLEdBQUcsT0FBTyxDQUFDLE9BQU8sQ0FBQyxRQUFRLEVBQUU7WUFDdkMsV0FBVyxFQUFFLHFDQUFxQyxPQUFPLENBQUMsYUFBYSxFQUFFO1lBQ3pFLFFBQVEsRUFBRSxvQkFBWSxDQUFDLE9BQU87WUFDOUIsSUFBSSxFQUFFLGdCQUFnQixHQUFHLE9BQU8sQ0FBQyxhQUFhO1NBQy9DLENBQUMsQ0FBQztRQUVILE9BQU8sQ0FBQyxTQUFTLENBQUMsS0FBSyxDQUFDLE1BQU0sQ0FBQyxDQUFDO0lBQ2xDLENBQUM7Q0FDRjtBQVpELHNDQVlDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgVGFza0NhdGVnb3J5IH0gZnJvbSAnLi90YXNrcyc7XG5pbXBvcnQgeyBUeXBlU2NyaXB0UHJvamVjdCB9IGZyb20gJy4vdHlwZXNjcmlwdCc7XG5cbi8qKlxuICBBZGRzIGEgc2ltcGxlIFR5cGVzY3JpcHQgZG9jdW1lbnRhdGlvbiBnZW5lcmF0b3JcbiAqL1xuZXhwb3J0IGNsYXNzIFR5cGVkb2NEb2NnZW4ge1xuICBjb25zdHJ1Y3Rvcihwcm9qZWN0OiBUeXBlU2NyaXB0UHJvamVjdCkge1xuICAgIHByb2plY3QuYWRkRGV2RGVwcygndHlwZWRvY0BeMC4yMC4zNScpO1xuXG4gICAgY29uc3QgZG9jZ2VuID0gcHJvamVjdC5hZGRUYXNrKCdkb2NnZW4nLCB7XG4gICAgICBkZXNjcmlwdGlvbjogYEdlbmVyYXRlIFR5cGVTY3JpcHQgQVBJIHJlZmVyZW5jZSAke3Byb2plY3QuZG9jc0RpcmVjdG9yeX1gLFxuICAgICAgY2F0ZWdvcnk6IFRhc2tDYXRlZ29yeS5SRUxFQVNFLFxuICAgICAgZXhlYzogJ3R5cGVkb2MgLS1vdXQgJyArIHByb2plY3QuZG9jc0RpcmVjdG9yeSxcbiAgICB9KTtcblxuICAgIHByb2plY3QuYnVpbGRUYXNrLnNwYXduKGRvY2dlbik7XG4gIH1cbn1cbiJdfQ==