"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.JenkinsEC2 = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const ec2 = require("@aws-cdk/aws-ec2");
const super_ec2_1 = require("./super-ec2");
;
/**
 * @experimental
 */
class JenkinsEC2 extends super_ec2_1.SuperEC2Base {
    /**
     * @experimental
     */
    constructor(scope, id, props = {}) {
        super(scope, id, props);
        this.userData.addCommands(...this.jenkinsUserData());
        this._addIngressRule(this.defaultSecurityGroup, [22, 80, 8080, 443]);
    }
    /**
     * @experimental
     */
    jenkinsUserData() {
        return ['yum install docker -y',
            'systemctl start docker',
            'usermod -aG docker ec2-user',
            'usermod -aG docker ssm-user',
            'chmod +x /var/run/docker.sock',
            'systemctl restart docker && systemctl enable docker',
            'mkdir /home/ec2-user/jenkins-data',
            'docker run --name jks --rm -d -u root -p 8080:8080 -p 50000:50000 -v /home/ec2-user/jenkins-data:/var/jenkins_home -v /var/run/docker.sock:/var/run/docker.sock -v /home/ec2-user:/home jenkinsci/blueocean'];
    }
    ;
    _addIngressRule(SecurityGroup, Ports) {
        Ports.forEach(port => {
            SecurityGroup.addIngressRule(ec2.Peer.anyIpv4(), ec2.Port.tcp(port));
        });
        return SecurityGroup;
    }
}
exports.JenkinsEC2 = JenkinsEC2;
_a = JSII_RTTI_SYMBOL_1;
JenkinsEC2[_a] = { fqn: "@cdk-constructs-zone/super-ec2.JenkinsEC2", version: "0.0.7" };
//# sourceMappingURL=data:application/json;base64,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