"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.JenkinsEC2 = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const ec2 = require("@aws-cdk/aws-ec2");
const elbv2 = require("@aws-cdk/aws-elasticloadbalancingv2");
const targets = require("@aws-cdk/aws-elasticloadbalancingv2-targets");
const super_ec2_1 = require("./super-ec2");
const super_ec2_interfaces_1 = require("./super-ec2-interfaces");
;
/**
 * @experimental
 */
class JenkinsEC2 extends super_ec2_1.SuperEC2Base {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _b;
        super(scope, id, props);
        this.userData.addCommands(...this.jenkinsUserData());
        this._addIngressRule(this.defaultSecurityGroup, [22, 8080, 50000]);
        this.loadbalancer = (_b = props.loadbalancer) !== null && _b !== void 0 ? _b : this._setloadbalancer(props.loadbalancerType);
        if (props.domain) {
            this.domain = new super_ec2_interfaces_1.SuperDomain(this, 'superDomain', { ...props.domain, loadbalancer: this.loadbalancer });
            this._setlistener(this.domain.acm);
        }
        else {
            this._set80listener();
        }
    }
    /**
     * @experimental
     */
    jenkinsUserData() {
        return ['yum install docker -y',
            'systemctl start docker',
            'usermod -aG docker ec2-user',
            'usermod -aG docker ssm-user',
            'chmod +x /var/run/docker.sock',
            'systemctl restart docker && systemctl enable docker',
            'mkdir /home/ec2-user/jenkins-data',
            'docker run --name jks --rm -d -u root -p 8080:8080 -p 50000:50000 -v /home/ec2-user/jenkins-data:/var/jenkins_home -v /var/run/docker.sock:/var/run/docker.sock -v /home/ec2-user:/home jenkinsci/blueocean'];
    }
    ;
    _addIngressRule(SecurityGroup, Ports) {
        Ports.forEach(port => {
            SecurityGroup.addIngressRule(ec2.Peer.anyIpv4(), ec2.Port.tcp(port));
        });
        return SecurityGroup;
    }
    _setloadbalancer(loadbalancerType) {
        switch (loadbalancerType) {
            case super_ec2_interfaces_1.ELBtype.ALB:
                return new elbv2.ApplicationLoadBalancer(this, 'jksALB', {
                    vpc: this.vpc,
                    loadBalancerName: 'jksALB',
                    internetFacing: true,
                });
            case super_ec2_interfaces_1.ELBtype.NLB:
                return new elbv2.NetworkLoadBalancer(this, 'jksNLB', {
                    vpc: this.vpc,
                    loadBalancerName: 'jksNLB',
                    internetFacing: true,
                });
            default: {
                return new elbv2.ApplicationLoadBalancer(this, 'jksALB', {
                    vpc: this.vpc,
                    loadBalancerName: 'jksALB',
                    internetFacing: true,
                });
            }
        }
    }
    _setlistener(acm) {
        const httpslistener = this.loadbalancer.addListener('httpsListener', {
            certificates: [elbv2.ListenerCertificate.fromArn(acm.certificateArn)],
            port: 443,
        });
        if (this.loadbalancer instanceof elbv2.ApplicationLoadBalancer) {
            this.loadbalancer.addListener('httpListener', {
                port: 80,
                open: true,
                defaultAction: elbv2.ListenerAction.redirect({
                    protocol: 'HTTPS',
                    host: '#{host}',
                    path: '/#{path}',
                    query: '/#{query}',
                    port: '443',
                }),
            });
        }
        if (httpslistener instanceof elbv2.ApplicationListener) {
            httpslistener.addTargets('Targets', {
                port: 8080,
                protocol: elbv2.ApplicationProtocol.HTTP,
                targets: [new targets.InstanceTarget(this.instance)],
            });
            httpslistener.connections.allowTo(this.instance, ec2.Port.tcp(8080));
        }
        else if (httpslistener instanceof elbv2.NetworkListener) {
            httpslistener.addTargets('Targets', {
                port: 8080,
                protocol: elbv2.Protocol.TCP,
                targets: [new targets.InstanceTarget(this.instance)],
            });
        }
    }
    _set80listener() {
        const httplistener = this.loadbalancer.addListener('httpListener', {
            port: 80,
        });
        if (httplistener instanceof elbv2.ApplicationListener) {
            httplistener.addTargets('Targets', {
                port: 8080,
                protocol: elbv2.ApplicationProtocol.HTTP,
                targets: [new targets.InstanceTarget(this.instance)],
            });
            httplistener.connections.allowTo(this.instance, ec2.Port.tcp(8080));
        }
        else if (httplistener instanceof elbv2.NetworkListener) {
            httplistener.addTargets('Targets', {
                port: 8080,
                protocol: elbv2.Protocol.TCP,
                targets: [new targets.InstanceTarget(this.instance)],
            });
        }
    }
}
exports.JenkinsEC2 = JenkinsEC2;
_a = JSII_RTTI_SYMBOL_1;
JenkinsEC2[_a] = { fqn: "@cdk-constructs-zone/super-ec2.JenkinsEC2", version: "0.0.48" };
//# sourceMappingURL=data:application/json;base64,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