"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnJson = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const custom_resource_1 = require("./custom-resource");
const cfn_utils_provider_1 = require("./private/cfn-utils-provider");
const stack_1 = require("./stack");
const stack_trace_1 = require("./stack-trace");
// v2 - keep this import as a separate section to reduce merge conflict when forward merging with the v2 branch.
// eslint-disable-next-line
const construct_compat_1 = require("./construct-compat");
/**
 * Captures a synthesis-time JSON object a CloudFormation reference which
 * resolves during deployment to the resolved values of the JSON object.
 *
 * The main use case for this is to overcome a limitation in CloudFormation that
 * does not allow using intrinsic functions as dictionary keys (because
 * dictionary keys in JSON must be strings). Specifically this is common in IAM
 * conditions such as `StringEquals: { lhs: "rhs" }` where you want "lhs" to be
 * a reference.
 *
 * This object is resolvable, so it can be used as a value.
 *
 * This construct is backed by a custom resource.
 */
class CfnJson extends construct_compat_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.creationStack = [];
        try {
            jsiiDeprecationWarnings._aws_cdk_core_CfnJsonProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnJson);
            }
            throw error;
        }
        this.creationStack = stack_trace_1.captureStackTrace();
        // stringify the JSON object in a token-aware way.
        this.jsonString = stack_1.Stack.of(this).toJsonString(props.value);
        const resource = new custom_resource_1.CustomResource(this, 'Resource', {
            serviceToken: cfn_utils_provider_1.CfnUtilsProvider.getOrCreate(this),
            resourceType: "Custom::AWSCDKCfnJson" /* CFN_JSON */,
            properties: {
                Value: this.jsonString,
            },
        });
        this.value = resource.getAtt('Value');
    }
    /**
     * This is required in case someone JSON.stringifys an object which refrences
     * this object. Otherwise, we'll get a cyclic JSON reference.
     */
    toJSON() {
        return this.jsonString;
    }
    resolve(_) {
        try {
            jsiiDeprecationWarnings._aws_cdk_core_IResolveContext(_);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.resolve);
            }
            throw error;
        }
        return this.value;
    }
}
exports.CfnJson = CfnJson;
_a = JSII_RTTI_SYMBOL_1;
CfnJson[_a] = { fqn: "@aws-cdk/core.CfnJson", version: "1.198.1" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY2ZuLWpzb24uanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJjZm4tanNvbi50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7QUFDQSx1REFBbUQ7QUFDbkQscUVBQWdFO0FBSWhFLG1DQUFnQztBQUNoQywrQ0FBa0Q7QUFFbEQsZ0hBQWdIO0FBQ2hILDJCQUEyQjtBQUMzQix5REFBZ0U7QUFVaEU7Ozs7Ozs7Ozs7Ozs7R0FhRztBQUNILE1BQWEsT0FBUSxTQUFRLDRCQUFhO0lBY3hDLFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBbUI7UUFDM0QsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQWRILGtCQUFhLEdBQWEsRUFBRSxDQUFDOzs7Ozs7K0NBRGxDLE9BQU87Ozs7UUFpQmhCLElBQUksQ0FBQyxhQUFhLEdBQUcsK0JBQWlCLEVBQUUsQ0FBQztRQUV6QyxrREFBa0Q7UUFDbEQsSUFBSSxDQUFDLFVBQVUsR0FBRyxhQUFLLENBQUMsRUFBRSxDQUFDLElBQUksQ0FBQyxDQUFDLFlBQVksQ0FBQyxLQUFLLENBQUMsS0FBSyxDQUFDLENBQUM7UUFFM0QsTUFBTSxRQUFRLEdBQUcsSUFBSSxnQ0FBYyxDQUFDLElBQUksRUFBRSxVQUFVLEVBQUU7WUFDcEQsWUFBWSxFQUFFLHFDQUFnQixDQUFDLFdBQVcsQ0FBQyxJQUFJLENBQUM7WUFDaEQsWUFBWSx3Q0FBK0I7WUFDM0MsVUFBVSxFQUFFO2dCQUNWLEtBQUssRUFBRSxJQUFJLENBQUMsVUFBVTthQUN2QjtTQUNGLENBQUMsQ0FBQztRQUVILElBQUksQ0FBQyxLQUFLLEdBQUcsUUFBUSxDQUFDLE1BQU0sQ0FBQyxPQUFPLENBQUMsQ0FBQztLQUN2QztJQUVEOzs7T0FHRztJQUNJLE1BQU07UUFDWCxPQUFPLElBQUksQ0FBQyxVQUFVLENBQUM7S0FDeEI7SUFFTSxPQUFPLENBQUMsQ0FBa0I7Ozs7Ozs7Ozs7UUFDL0IsT0FBTyxJQUFJLENBQUMsS0FBSyxDQUFDO0tBQ25COztBQTNDSCwwQkE0Q0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcbmltcG9ydCB7IEN1c3RvbVJlc291cmNlIH0gZnJvbSAnLi9jdXN0b20tcmVzb3VyY2UnO1xuaW1wb3J0IHsgQ2ZuVXRpbHNQcm92aWRlciB9IGZyb20gJy4vcHJpdmF0ZS9jZm4tdXRpbHMtcHJvdmlkZXInO1xuaW1wb3J0IHsgQ2ZuVXRpbHNSZXNvdXJjZVR5cGUgfSBmcm9tICcuL3ByaXZhdGUvY2ZuLXV0aWxzLXByb3ZpZGVyL2NvbnN0cyc7XG5pbXBvcnQgeyBSZWZlcmVuY2UgfSBmcm9tICcuL3JlZmVyZW5jZSc7XG5pbXBvcnQgeyBJUmVzb2x2YWJsZSwgSVJlc29sdmVDb250ZXh0IH0gZnJvbSAnLi9yZXNvbHZhYmxlJztcbmltcG9ydCB7IFN0YWNrIH0gZnJvbSAnLi9zdGFjayc7XG5pbXBvcnQgeyBjYXB0dXJlU3RhY2tUcmFjZSB9IGZyb20gJy4vc3RhY2stdHJhY2UnO1xuXG4vLyB2MiAtIGtlZXAgdGhpcyBpbXBvcnQgYXMgYSBzZXBhcmF0ZSBzZWN0aW9uIHRvIHJlZHVjZSBtZXJnZSBjb25mbGljdCB3aGVuIGZvcndhcmQgbWVyZ2luZyB3aXRoIHRoZSB2MiBicmFuY2guXG4vLyBlc2xpbnQtZGlzYWJsZS1uZXh0LWxpbmVcbmltcG9ydCB7IENvbnN0cnVjdCBhcyBDb3JlQ29uc3RydWN0IH0gZnJvbSAnLi9jb25zdHJ1Y3QtY29tcGF0JztcblxuZXhwb3J0IGludGVyZmFjZSBDZm5Kc29uUHJvcHMge1xuICAvKipcbiAgICogVGhlIHZhbHVlIHRvIHJlc29sdmUuIENhbiBiZSBhbnkgSmF2YVNjcmlwdCBvYmplY3QsIGluY2x1ZGluZyB0b2tlbnMgYW5kXG4gICAqIHJlZmVyZW5jZXMgaW4ga2V5cyBvciB2YWx1ZXMuXG4gICAqL1xuICByZWFkb25seSB2YWx1ZTogYW55O1xufVxuXG4vKipcbiAqIENhcHR1cmVzIGEgc3ludGhlc2lzLXRpbWUgSlNPTiBvYmplY3QgYSBDbG91ZEZvcm1hdGlvbiByZWZlcmVuY2Ugd2hpY2hcbiAqIHJlc29sdmVzIGR1cmluZyBkZXBsb3ltZW50IHRvIHRoZSByZXNvbHZlZCB2YWx1ZXMgb2YgdGhlIEpTT04gb2JqZWN0LlxuICpcbiAqIFRoZSBtYWluIHVzZSBjYXNlIGZvciB0aGlzIGlzIHRvIG92ZXJjb21lIGEgbGltaXRhdGlvbiBpbiBDbG91ZEZvcm1hdGlvbiB0aGF0XG4gKiBkb2VzIG5vdCBhbGxvdyB1c2luZyBpbnRyaW5zaWMgZnVuY3Rpb25zIGFzIGRpY3Rpb25hcnkga2V5cyAoYmVjYXVzZVxuICogZGljdGlvbmFyeSBrZXlzIGluIEpTT04gbXVzdCBiZSBzdHJpbmdzKS4gU3BlY2lmaWNhbGx5IHRoaXMgaXMgY29tbW9uIGluIElBTVxuICogY29uZGl0aW9ucyBzdWNoIGFzIGBTdHJpbmdFcXVhbHM6IHsgbGhzOiBcInJoc1wiIH1gIHdoZXJlIHlvdSB3YW50IFwibGhzXCIgdG8gYmVcbiAqIGEgcmVmZXJlbmNlLlxuICpcbiAqIFRoaXMgb2JqZWN0IGlzIHJlc29sdmFibGUsIHNvIGl0IGNhbiBiZSB1c2VkIGFzIGEgdmFsdWUuXG4gKlxuICogVGhpcyBjb25zdHJ1Y3QgaXMgYmFja2VkIGJ5IGEgY3VzdG9tIHJlc291cmNlLlxuICovXG5leHBvcnQgY2xhc3MgQ2ZuSnNvbiBleHRlbmRzIENvcmVDb25zdHJ1Y3QgaW1wbGVtZW50cyBJUmVzb2x2YWJsZSB7XG4gIHB1YmxpYyByZWFkb25seSBjcmVhdGlvblN0YWNrOiBzdHJpbmdbXSA9IFtdO1xuXG4gIC8qKlxuICAgKiBBbiBGbjo6R2V0QXR0IHRvIHRoZSBKU09OIG9iamVjdCBwYXNzZWQgdGhyb3VnaCBgdmFsdWVgIGFuZCByZXNvbHZlZCBkdXJpbmdcbiAgICogc3ludGhlc2lzLlxuICAgKlxuICAgKiBOb3JtYWxseSB0aGVyZSBpcyBubyBuZWVkIHRvIHVzZSB0aGlzIHByb3BlcnR5IHNpbmNlIGBDZm5Kc29uYCBpcyBhblxuICAgKiBJUmVzb2x2YWJsZSwgc28gaXQgY2FuIGJlIHNpbXBseSB1c2VkIGFzIGEgdmFsdWUuXG4gICAqL1xuICBwdWJsaWMgcmVhZG9ubHkgdmFsdWU6IFJlZmVyZW5jZTtcblxuICBwcml2YXRlIHJlYWRvbmx5IGpzb25TdHJpbmc6IHN0cmluZztcblxuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogQ2ZuSnNvblByb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkKTtcblxuICAgIHRoaXMuY3JlYXRpb25TdGFjayA9IGNhcHR1cmVTdGFja1RyYWNlKCk7XG5cbiAgICAvLyBzdHJpbmdpZnkgdGhlIEpTT04gb2JqZWN0IGluIGEgdG9rZW4tYXdhcmUgd2F5LlxuICAgIHRoaXMuanNvblN0cmluZyA9IFN0YWNrLm9mKHRoaXMpLnRvSnNvblN0cmluZyhwcm9wcy52YWx1ZSk7XG5cbiAgICBjb25zdCByZXNvdXJjZSA9IG5ldyBDdXN0b21SZXNvdXJjZSh0aGlzLCAnUmVzb3VyY2UnLCB7XG4gICAgICBzZXJ2aWNlVG9rZW46IENmblV0aWxzUHJvdmlkZXIuZ2V0T3JDcmVhdGUodGhpcyksXG4gICAgICByZXNvdXJjZVR5cGU6IENmblV0aWxzUmVzb3VyY2VUeXBlLkNGTl9KU09OLFxuICAgICAgcHJvcGVydGllczoge1xuICAgICAgICBWYWx1ZTogdGhpcy5qc29uU3RyaW5nLFxuICAgICAgfSxcbiAgICB9KTtcblxuICAgIHRoaXMudmFsdWUgPSByZXNvdXJjZS5nZXRBdHQoJ1ZhbHVlJyk7XG4gIH1cblxuICAvKipcbiAgICogVGhpcyBpcyByZXF1aXJlZCBpbiBjYXNlIHNvbWVvbmUgSlNPTi5zdHJpbmdpZnlzIGFuIG9iamVjdCB3aGljaCByZWZyZW5jZXNcbiAgICogdGhpcyBvYmplY3QuIE90aGVyd2lzZSwgd2UnbGwgZ2V0IGEgY3ljbGljIEpTT04gcmVmZXJlbmNlLlxuICAgKi9cbiAgcHVibGljIHRvSlNPTigpIHtcbiAgICByZXR1cm4gdGhpcy5qc29uU3RyaW5nO1xuICB9XG5cbiAgcHVibGljIHJlc29sdmUoXzogSVJlc29sdmVDb250ZXh0KTogYW55IHtcbiAgICByZXR1cm4gdGhpcy52YWx1ZTtcbiAgfVxufVxuIl19