"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NestedStackSynthesizer = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const _shared_1 = require("./_shared");
const stack_synthesizer_1 = require("./stack-synthesizer");
/**
 * Synthesizer for a nested stack
 *
 * Forwards all calls to the parent stack's synthesizer.
 *
 * This synthesizer is automatically used for `NestedStack` constructs.
 * App builder do not need to use this class directly.
 */
class NestedStackSynthesizer extends stack_synthesizer_1.StackSynthesizer {
    constructor(parentDeployment) {
        super();
        this.parentDeployment = parentDeployment;
        try {
            jsiiDeprecationWarnings._aws_cdk_core_IStackSynthesizer(parentDeployment);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, NestedStackSynthesizer);
            }
            throw error;
        }
    }
    bind(stack) {
        try {
            jsiiDeprecationWarnings._aws_cdk_core_Stack(stack);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        if (this.stack !== undefined) {
            throw new Error('A StackSynthesizer can only be used for one Stack: create a new instance to use with a different Stack');
        }
        this.stack = stack;
    }
    addFileAsset(asset) {
        try {
            jsiiDeprecationWarnings._aws_cdk_core_FileAssetSource(asset);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addFileAsset);
            }
            throw error;
        }
        // Forward to parent deployment. By the magic of cross-stack references any parameter
        // returned and used will magically be forwarded to the nested stack.
        return this.parentDeployment.addFileAsset(asset);
    }
    addDockerImageAsset(asset) {
        try {
            jsiiDeprecationWarnings._aws_cdk_core_DockerImageAssetSource(asset);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addDockerImageAsset);
            }
            throw error;
        }
        // Forward to parent deployment. By the magic of cross-stack references any parameter
        // returned and used will magically be forwarded to the nested stack.
        return this.parentDeployment.addDockerImageAsset(asset);
    }
    synthesize(session) {
        try {
            jsiiDeprecationWarnings._aws_cdk_core_ISynthesisSession(session);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.synthesize);
            }
            throw error;
        }
        _shared_1.assertBound(this.stack);
        // Synthesize the template, but don't emit as a cloud assembly artifact.
        // It will be registered as an S3 asset of its parent instead.
        this.synthesizeStackTemplate(this.stack, session);
    }
}
exports.NestedStackSynthesizer = NestedStackSynthesizer;
_a = JSII_RTTI_SYMBOL_1;
NestedStackSynthesizer[_a] = { fqn: "@aws-cdk/core.NestedStackSynthesizer", version: "1.197.0" };
//# sourceMappingURL=data:application/json;base64,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