"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Jest = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const semver = require("semver");
const tasks_1 = require("./tasks");
const typescript_config_1 = require("./typescript-config");
const DEFAULT_TEST_REPORTS_DIR = 'test-reports';
/**
 * (experimental) Installs the following npm scripts:.
 *
 * - `test` will run `jest --passWithNoTests`
 * - `test:watch` will run `jest --watch`
 * - `test:update` will run `jest -u`
 *
 * @experimental
 */
class Jest {
    /**
     * @experimental
     */
    constructor(project, options = {}) {
        var _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s, _t, _u, _v, _w, _x, _y, _z, _0, _1, _2, _3;
        this.project = project;
        // Jest snapshot files are generated files!
        (_b = project.root.github) === null || _b === void 0 ? void 0 : _b.annotateGenerated('*.snap');
        const jestDep = options.jestVersion ? `jest@${options.jestVersion}` : 'jest';
        project.addDevDeps(jestDep);
        this.jestConfig = options.jestConfig;
        this.typescriptConfig = options.typescriptConfig;
        this.ignorePatterns = (_e = (_d = (_c = this.jestConfig) === null || _c === void 0 ? void 0 : _c.testPathIgnorePatterns) !== null && _d !== void 0 ? _d : options.ignorePatterns) !== null && _e !== void 0 ? _e : ['/node_modules/'];
        this.watchIgnorePatterns = (_g = (_f = this.jestConfig) === null || _f === void 0 ? void 0 : _f.watchPathIgnorePatterns) !== null && _g !== void 0 ? _g : ['/node_modules/'];
        this.coverageReporters = (_j = (_h = this.jestConfig) === null || _h === void 0 ? void 0 : _h.coverageReporters) !== null && _j !== void 0 ? _j : ['json', 'lcov', 'clover'];
        this.testMatch = (_l = (_k = this.jestConfig) === null || _k === void 0 ? void 0 : _k.testMatch) !== null && _l !== void 0 ? _l : ['**\/__tests__/**\/*.[jt]s?(x)', '**\/?(*.)+(spec|test).[tj]s?(x)'];
        const coverageDirectory = (_o = (_m = this.jestConfig) === null || _m === void 0 ? void 0 : _m.coverageDirectory) !== null && _o !== void 0 ? _o : 'coverage';
        this.reporters = [];
        if ((_p = options.preserveDefaultReporters) !== null && _p !== void 0 ? _p : true) {
            this.reporters.unshift('default');
        }
        this.config = {
            ...this.jestConfig,
            clearMocks: (_r = (_q = this.jestConfig) === null || _q === void 0 ? void 0 : _q.clearMocks) !== null && _r !== void 0 ? _r : true,
            collectCoverage: (_u = (_s = options.coverage) !== null && _s !== void 0 ? _s : (_t = this.jestConfig) === null || _t === void 0 ? void 0 : _t.collectCoverage) !== null && _u !== void 0 ? _u : true,
            coverageReporters: this.coverageReporters,
            coverageDirectory: coverageDirectory,
            coveragePathIgnorePatterns: (_w = (_v = this.jestConfig) === null || _v === void 0 ? void 0 : _v.coveragePathIgnorePatterns) !== null && _w !== void 0 ? _w : this.ignorePatterns,
            testPathIgnorePatterns: this.ignorePatterns,
            watchPathIgnorePatterns: this.watchIgnorePatterns,
            testMatch: this.testMatch,
            reporters: this.reporters,
            snapshotResolver: (() => this._snapshotResolver),
        };
        if ((_x = options.junitReporting) !== null && _x !== void 0 ? _x : true) {
            const reportsDir = DEFAULT_TEST_REPORTS_DIR;
            this.addReporter([
                'jest-junit',
                { outputDirectory: reportsDir },
            ]);
            project.addDevDeps('jest-junit@^12');
            project.gitignore.exclude('# jest-junit artifacts', `/${reportsDir}/`, 'junit.xml');
            (_y = project.npmignore) === null || _y === void 0 ? void 0 : _y.exclude('# jest-junit artifacts', `/${reportsDir}/`, 'junit.xml');
        }
        if ((_z = this.jestConfig) === null || _z === void 0 ? void 0 : _z.reporters) {
            for (const reporter of this.jestConfig.reporters) {
                this.addReporter(reporter);
            }
        }
        if ((_0 = this.jestConfig) === null || _0 === void 0 ? void 0 : _0.coverageThreshold) {
            this.config.coverageThreshold = {
                global: (_1 = this.jestConfig) === null || _1 === void 0 ? void 0 : _1.coverageThreshold,
            };
        }
        this.configureTestCommand();
        project.addFields({ jest: this.config });
        const coverageDirectoryPath = path.posix.join('/', coverageDirectory);
        (_2 = project.npmignore) === null || _2 === void 0 ? void 0 : _2.exclude(coverageDirectoryPath);
        project.gitignore.exclude(coverageDirectoryPath);
        if ((_3 = options.coverageText) !== null && _3 !== void 0 ? _3 : true) {
            this.coverageReporters.push('text');
        }
    }
    /**
     * (experimental) Adds a test match pattern.
     *
     * @param pattern glob pattern to match for tests.
     * @experimental
     */
    addTestMatch(pattern) {
        this.testMatch.push(pattern);
    }
    /**
     * (experimental) Adds a watch ignore pattern.
     *
     * @param pattern The pattern (regular expression).
     * @experimental
     */
    addWatchIgnorePattern(pattern) {
        this.watchIgnorePatterns.push(pattern);
    }
    /**
     * @experimental
     */
    addIgnorePattern(pattern) {
        this.ignorePatterns.push(pattern);
    }
    /**
     * @experimental
     */
    addReporter(reporter) {
        this.reporters.push(reporter);
    }
    /**
     * @experimental
     */
    addSnapshotResolver(file) {
        this._snapshotResolver = file;
    }
    /**
     * (experimental) Merges passed in typescript config options with jest configured typescript options from .projenrc Add Jest config settings for typescript options.
     *
     * @param options TypescriptConfigOptions.
     * @experimental
     */
    generateTypescriptConfig(options) {
        var _b, _c, _d, _e, _f, _g, _h, _j;
        const tsconfig = new typescript_config_1.TypescriptConfig(this.project, {
            fileName: (_b = options.fileName) !== null && _b !== void 0 ? _b : 'tsconfig.jest.json',
            include: [
                ...options.include ? options.include : [],
                ...((_c = this.typescriptConfig) === null || _c === void 0 ? void 0 : _c.include) ? (_d = this.typescriptConfig) === null || _d === void 0 ? void 0 : _d.include : [],
            ],
            exclude: [
                ...options.exclude ? options.exclude : [],
                ...((_e = this.typescriptConfig) === null || _e === void 0 ? void 0 : _e.exclude) ? (_f = this.typescriptConfig) === null || _f === void 0 ? void 0 : _f.exclude : [],
            ],
            compilerOptions: {
                ...options.compilerOptions,
                ...(_g = this.typescriptConfig) === null || _g === void 0 ? void 0 : _g.compilerOptions,
            },
        });
        this.config.preset = 'ts-jest';
        // only process .ts files
        this.config.testMatch = (_j = (_h = this.jestConfig) === null || _h === void 0 ? void 0 : _h.testMatch) !== null && _j !== void 0 ? _j : [
            '**/__tests__/**/*.ts?(x)',
            '**/?(*.)+(spec|test).ts?(x)',
        ];
        // specify tsconfig.json
        this.config.globals = {
            'ts-jest': {
                tsconfig: tsconfig.fileName,
            },
        };
        // add relevant deps
        this.project.addDevDeps('@types/jest', 'ts-jest');
        return tsconfig;
    }
    configureTestCommand() {
        const jestOpts = ['--passWithNoTests', '--all'];
        // if the project has anti-tamper configured, it should be safe to always run tests
        // with --updateSnapshot because if we forget to commit a snapshot change the CI build will fail.
        if (this.project.antitamper) {
            jestOpts.push('--updateSnapshot');
        }
        // as recommended in the jest docs, node > 14 may use native v8 coverage collection
        // https://jestjs.io/docs/en/cli#--coverageproviderprovider
        if (this.project.package.minNodeVersion && semver.gte(this.project.package.minNodeVersion, '14.0.0')) {
            jestOpts.push('--coverageProvider=v8');
        }
        this.project.testTask.exec(`jest ${jestOpts.join(' ')}`);
        this.project.addTask('test:watch', {
            description: 'Run jest in watch mode',
            category: tasks_1.TaskCategory.TEST,
            exec: 'jest --watch',
        });
        this.project.addTask('test:update', {
            description: 'Update jest snapshots',
            category: tasks_1.TaskCategory.TEST,
            exec: 'jest --updateSnapshot',
        });
    }
}
exports.Jest = Jest;
_a = JSII_RTTI_SYMBOL_1;
Jest[_a] = { fqn: "projen.Jest", version: "0.17.92" };
//# sourceMappingURL=data:application/json;base64,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