"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Pom = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const _resolve_1 = require("../_resolve");
const component_1 = require("../component");
const deps_1 = require("../deps");
const semver_1 = require("../util/semver");
const xmlfile_1 = require("../xmlfile");
const POM_XML_ATTRS = {
    '@xsi:schemaLocation': 'http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd',
    '@xmlns': 'http://maven.apache.org/POM/4.0.0',
    '@xmlns:xsi': 'http://www.w3.org/2001/XMLSchema-instance',
};
/**
 * (experimental) A Project Object Model or POM is the fundamental unit of work in Maven.
 *
 * It is
 * an XML file that contains information about the project and configuration
 * details used by Maven to build the project.
 *
 * @experimental
 */
class Pom extends component_1.Component {
    /**
     * @experimental
     */
    constructor(project, options) {
        var _b;
        super(project);
        this.properties = {};
        this.fileName = 'pom.xml';
        this.groupId = options.groupId;
        this.artifactId = options.artifactId;
        this.version = options.version;
        this.packaging = (_b = options.packaging) !== null && _b !== void 0 ? _b : 'jar';
        this.name = project.name;
        this.description = options.description;
        this.url = options.url;
        new xmlfile_1.XmlFile(project, this.fileName, { obj: () => this.synthPom() });
    }
    /**
     * (experimental) Adds a key/value property to the pom.
     *
     * @param key the key.
     * @param value the value.
     * @experimental
     */
    addProperty(key, value) {
        this.properties[key] = value;
    }
    /**
     * (experimental) Adds a runtime dependency.
     *
     * @param spec Format `<groupId>/<artifactId>@<semver>`.
     * @experimental
     */
    addDependency(spec) {
        this.project.deps.addDependency(spec, deps_1.DependencyType.RUNTIME);
    }
    /**
     * (experimental) Adds a test dependency.
     *
     * @param spec Format `<groupId>/<artifactId>@<semver>`.
     * @experimental
     */
    addTestDependency(spec) {
        this.project.deps.addDependency(spec, deps_1.DependencyType.TEST);
    }
    /**
     * (experimental) Adds a build plugin to the pom.
     *
     * The plug in is also added as a BUILD dep to the project.
     *
     * @param spec dependency spec (`group/artifact@version`).
     * @param options plugin options.
     * @experimental
     */
    addPlugin(spec, options = {}) {
        var _b;
        for (const dep of (_b = options.dependencies) !== null && _b !== void 0 ? _b : []) {
            this.project.deps.addDependency(dep, deps_1.DependencyType.BUILD);
        }
        return this.project.deps.addDependency(spec, deps_1.DependencyType.BUILD, options);
    }
    synthPom() {
        return _resolve_1.resolve({
            project: {
                ...POM_XML_ATTRS,
                modelVersion: '4.0.0',
                groupId: this.groupId,
                artifactId: this.artifactId,
                version: this.version,
                packaging: this.packaging,
                name: this.name,
                description: this.description,
                url: this.url,
                properties: this.properties,
                ...this.synthDependencies(),
            },
        }, { omitEmpty: true });
    }
    synthDependencies() {
        const deps = this.project.deps.all;
        if (deps.length === 0) {
            return;
        }
        const dependencies = [];
        const plugins = [];
        for (const dep of deps) {
            switch (dep.type) {
                case deps_1.DependencyType.PEER:
                case deps_1.DependencyType.RUNTIME:
                    dependencies.push(mavenCoords(dep));
                    break;
                case deps_1.DependencyType.TEST:
                    dependencies.push({
                        ...mavenCoords(dep),
                        scope: 'test',
                    });
                    break;
                // build maps to plugins
                case deps_1.DependencyType.BUILD:
                    plugins.push({
                        ...mavenCoords(dep),
                        ...pluginConfig(dep.metadata),
                    });
                    break;
                default:
                    throw new Error(`unsupported dependency type: ${dep.type}`);
            }
        }
        return {
            build: { plugins: { plugin: plugins } },
            dependencies: { dependency: dependencies },
        };
    }
}
exports.Pom = Pom;
_a = JSII_RTTI_SYMBOL_1;
Pom[_a] = { fqn: "projen.java.Pom", version: "0.17.92" };
/**
 * Parses maven groupId and artifactId from a dependency name.
 *
 *     name    <=> <groupId>/<artifactId>
 *     version <=> <version>
 */
function mavenCoords(dep) {
    const name = dep.name;
    const parts = name.split('/');
    if (parts.length !== 2) {
        throw new Error(`invalid maven coordinates in dependency named "${name}". format is "<groupId>/<artifactId>". For example "org.junit.jupiter/junit-jupiter-engine"`);
    }
    return {
        groupId: parts[0],
        artifactId: parts[1],
        version: dep.version ? semver_1.toMavenVersionRange(dep.version) : undefined,
    };
}
function pluginConfig(options = {}) {
    var _b, _c;
    return {
        configuration: options.configuration,
        dependencies: (options.dependencies && options.dependencies.length > 0)
            ? { dependency: (_b = options.dependencies) === null || _b === void 0 ? void 0 : _b.map(d => mavenCoords(deps_1.Dependencies.parseDependency(d))) }
            : undefined,
        executions: (_c = options.executions) === null || _c === void 0 ? void 0 : _c.map(e => ({
            execution: {
                id: e.id,
                goals: e.goals.map(goal => ({ goal })),
            },
        })),
    };
}
//# sourceMappingURL=data:application/json;base64,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