"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudFormationStackArtifact = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const path = require("path");
const cxschema = require("@aws-cdk/cloud-assembly-schema");
const cloud_artifact_1 = require("../cloud-artifact");
const environment_1 = require("../environment");
class CloudFormationStackArtifact extends cloud_artifact_1.CloudArtifact {
    constructor(assembly, artifactId, artifact) {
        super(assembly, artifactId, artifact);
        try {
            jsiiDeprecationWarnings._aws_cdk_cx_api_CloudAssembly(assembly);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CloudFormationStackArtifact);
            }
            throw error;
        }
        const properties = (this.manifest.properties || {});
        if (!properties.templateFile) {
            throw new Error('Invalid CloudFormation stack artifact. Missing "templateFile" property in cloud assembly manifest');
        }
        if (!artifact.environment) {
            throw new Error('Invalid CloudFormation stack artifact. Missing environment');
        }
        this.environment = environment_1.EnvironmentUtils.parse(artifact.environment);
        this.templateFile = properties.templateFile;
        this.parameters = properties.parameters ?? {};
        // We get the tags from 'properties' if available (cloud assembly format >= 6.0.0), otherwise
        // from the stack metadata
        this.tags = properties.tags ?? this.tagsFromMetadata();
        this.assumeRoleArn = properties.assumeRoleArn;
        this.assumeRoleExternalId = properties.assumeRoleExternalId;
        this.cloudFormationExecutionRoleArn = properties.cloudFormationExecutionRoleArn;
        this.stackTemplateAssetObjectUrl = properties.stackTemplateAssetObjectUrl;
        this.requiresBootstrapStackVersion = properties.requiresBootstrapStackVersion;
        this.bootstrapStackVersionSsmParameter = properties.bootstrapStackVersionSsmParameter;
        this.terminationProtection = properties.terminationProtection;
        this.validateOnSynth = properties.validateOnSynth;
        this.lookupRole = properties.lookupRole;
        this.stackName = properties.stackName || artifactId;
        this.assets = this.findMetadataByType(cxschema.ArtifactMetadataEntryType.ASSET).map(e => e.data);
        this.displayName = this.stackName === artifactId
            ? this.hierarchicalId
            : `${this.hierarchicalId} (${this.stackName})`;
        this.name = this.stackName; // backwards compat
        this.originalName = this.stackName;
    }
    /**
     * Full path to the template file
     */
    get templateFullPath() {
        return path.join(this.assembly.directory, this.templateFile);
    }
    /**
     * The CloudFormation template for this stack.
     */
    get template() {
        if (this._template === undefined) {
            this._template = JSON.parse(fs.readFileSync(this.templateFullPath, 'utf-8'));
        }
        return this._template;
    }
    tagsFromMetadata() {
        const ret = {};
        for (const metadataEntry of this.findMetadataByType(cxschema.ArtifactMetadataEntryType.STACK_TAGS)) {
            for (const tag of (metadataEntry.data ?? [])) {
                ret[tag.key] = tag.value;
            }
        }
        return ret;
    }
}
exports.CloudFormationStackArtifact = CloudFormationStackArtifact;
_a = JSII_RTTI_SYMBOL_1;
CloudFormationStackArtifact[_a] = { fqn: "@aws-cdk/cx-api.CloudFormationStackArtifact", version: "1.187.0" };
//# sourceMappingURL=data:application/json;base64,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