"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !exports.hasOwnProperty(p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.scrutinizableResourceTypes = exports.scrutinizablePropertyNames = exports.filteredSpecification = exports.namespaces = exports.resourceTypes = exports.propertySpecification = exports.cfnLintAnnotations = exports.resourceAugmentation = exports.typeDocs = exports.resourceSpecification = exports.docs = exports.specification = exports.schema = void 0;
const crypto = require("crypto");
const schema = require("./schema");
exports.schema = schema;
const schema_1 = require("./schema");
__exportStar(require("./canned-metrics"), exports);
/**
 * The complete AWS CloudFormation Resource specification, having any CDK patches and enhancements included in it.
 */
function specification() {
    var _a;
    // eslint-disable-next-line @typescript-eslint/no-require-imports
    const spec = require('../spec/specification.json');
    // Modify spec in place, remove complex attributes
    for (const resource of Object.values(spec.ResourceTypes)) {
        resource.Attributes = Object.fromEntries(Object.entries((_a = resource.Attributes) !== null && _a !== void 0 ? _a : [])
            .filter(([_, attr]) => schema_1.isPrimitiveAttribute(attr) || schema_1.isListAttribute(attr) || schema_1.isMapAttribute(attr)));
    }
    return spec;
}
exports.specification = specification;
/**
 * The complete AWS CloudFormation Resource specification, having any CDK patches and enhancements included in it.
 */
function docs() {
    // eslint-disable-next-line @typescript-eslint/no-require-imports
    return require('../spec/cfn-docs.json');
}
exports.docs = docs;
/**
 * Return the resource specification for the given typename
 *
 * Validates that the resource exists. If you don't want this validating behavior, read from
 * specification() directly.
 */
function resourceSpecification(typeName) {
    const ret = specification().ResourceTypes[typeName];
    if (!ret) {
        throw new Error(`No such resource type: ${typeName}`);
    }
    return ret;
}
exports.resourceSpecification = resourceSpecification;
/**
 * Return documentation for the given type
 */
function typeDocs(resourceName, propertyTypeName) {
    const key = propertyTypeName ? `${resourceName}.${propertyTypeName}` : resourceName;
    const ret = docs().Types[key];
    if (!ret) {
        return {
            description: '',
            properties: {},
        };
    }
    return ret;
}
exports.typeDocs = typeDocs;
/**
 * Get the resource augmentations for a given type
 */
function resourceAugmentation(typeName) {
    const fileName = typeName.replace(/::/g, '_');
    try {
        // eslint-disable-next-line @typescript-eslint/no-require-imports
        return require(`./augmentations/${fileName}.json`);
    }
    catch (e) {
        return {};
    }
}
exports.resourceAugmentation = resourceAugmentation;
/**
 * Get the resource augmentations for a given type
 */
function cfnLintAnnotations(typeName) {
    var _a, _b;
    // eslint-disable-next-line @typescript-eslint/no-require-imports
    const allAnnotations = require('../spec/cfn-lint.json');
    return {
        stateful: !!allAnnotations.StatefulResources.ResourceTypes[typeName],
        mustBeEmptyToDelete: (_b = (_a = allAnnotations.StatefulResources.ResourceTypes[typeName]) === null || _a === void 0 ? void 0 : _a.DeleteRequiresEmptyResource) !== null && _b !== void 0 ? _b : false,
    };
}
exports.cfnLintAnnotations = cfnLintAnnotations;
/**
 * Return the property specification for the given resource's property
 */
function propertySpecification(typeName, propertyName) {
    const ret = resourceSpecification(typeName).Properties[propertyName];
    if (!ret) {
        throw new Error(`Resource ${typeName} has no property: ${propertyName}`);
    }
    return ret;
}
exports.propertySpecification = propertySpecification;
/**
 * The list of resource type names defined in the ``specification``.
 */
function resourceTypes() {
    return Object.keys(specification().ResourceTypes);
}
exports.resourceTypes = resourceTypes;
/**
 * The list of namespaces defined in the ``specification``, that is resource name prefixes down to the second ``::``.
 */
function namespaces() {
    return Array.from(new Set(resourceTypes().map(n => n.split('::', 2).join('::'))));
}
exports.namespaces = namespaces;
/**
 * Obtain a filtered version of the AWS CloudFormation specification.
 *
 * @param filter the predicate to be used in order to filter which resource types from the ``Specification`` to extract.
 *         When passed as a ``string``, only the specified resource type will be extracted. When passed as a
 *         ``RegExp``, all matching resource types will be extracted. When passed as a ``function``, all resource
 *         types for which the function returned ``true`` will be extracted.
 *
 * @return a coherent sub-set of the AWS CloudFormation Resource specification, including all property types related
 *     to the selected resource types.
 */
function filteredSpecification(filter) {
    const spec = specification();
    const result = { ResourceTypes: {}, PropertyTypes: {}, Fingerprint: spec.Fingerprint };
    const predicate = makePredicate(filter);
    for (const type of resourceTypes()) {
        if (!predicate(type)) {
            continue;
        }
        result.ResourceTypes[type] = spec.ResourceTypes[type];
        const prefix = `${type}.`;
        for (const propType of Object.keys(spec.PropertyTypes).filter(n => n.startsWith(prefix))) {
            result.PropertyTypes[propType] = spec.PropertyTypes[propType];
        }
    }
    result.Fingerprint = crypto.createHash('sha256').update(JSON.stringify(result)).digest('base64');
    return result;
}
exports.filteredSpecification = filteredSpecification;
/**
 * Creates a predicate function from a given filter.
 *
 * @param filter when provided as a ``string``, performs an exact match comparison.
 *         when provided as a ``RegExp``, performs uses ``str.match(RegExp)``.
 *         when provided as a ``function``, use the function as-is.
 *
 * @returns a predicate function.
 */
function makePredicate(filter) {
    if (typeof filter === 'string') {
        return s => s === filter;
    }
    else if (typeof filter === 'function') {
        return filter;
    }
    else {
        return s => s.match(filter) != null;
    }
}
/**
 * Return the properties of the given type that require the given scrutiny type
 */
function scrutinizablePropertyNames(resourceType, scrutinyTypes) {
    const impl = specification().ResourceTypes[resourceType];
    if (!impl) {
        return [];
    }
    const ret = new Array();
    for (const [propertyName, propertySpec] of Object.entries(impl.Properties || {})) {
        if (scrutinyTypes.includes(propertySpec.ScrutinyType || schema.PropertyScrutinyType.None)) {
            ret.push(propertyName);
        }
    }
    return ret;
}
exports.scrutinizablePropertyNames = scrutinizablePropertyNames;
/**
 * Return the names of the resource types that need to be subjected to additional scrutiny
 */
function scrutinizableResourceTypes(scrutinyTypes) {
    const ret = new Array();
    for (const [resourceType, resourceSpec] of Object.entries(specification().ResourceTypes)) {
        if (scrutinyTypes.includes(resourceSpec.ScrutinyType || schema.ResourceScrutinyType.None)) {
            ret.push(resourceType);
        }
    }
    return ret;
}
exports.scrutinizableResourceTypes = scrutinizableResourceTypes;
//# sourceMappingURL=data:application/json;base64,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