"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SuperDomain = exports.ELBtype = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const certmgr = require("@aws-cdk/aws-certificatemanager");
const r53 = require("@aws-cdk/aws-route53");
const r53tg = require("@aws-cdk/aws-route53-targets");
const cdk = require("@aws-cdk/core");
var ELBtype;
(function (ELBtype) {
    /**
     * Application Load Balancer
     */
    ELBtype["ALB"] = "ALB";
    /**
     * Network Load Balancer
     */
    ELBtype["NLB"] = "NLB";
})(ELBtype = exports.ELBtype || (exports.ELBtype = {}));
class SuperDomain extends cdk.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.zone = this._setzone(props);
        this.acm = props.acm ?? this._setacm(props);
        this.record = this._setaliasrecord(props);
    }
    _setzone(props) {
        return r53.HostedZone.fromHostedZoneAttributes(this, 'zone', {
            hostedZoneId: props.hostedZoneId,
            zoneName: props.zoneName,
        });
    }
    _setacm(props) {
        return new certmgr.Certificate(this, 'cert', {
            domainName: `*.${props.zoneName}`,
            validation: certmgr.CertificateValidation.fromDns(this.zone),
        });
    }
    _setaliasrecord(props) {
        return new r53.ARecord(this, 'alias-alb', {
            zone: this.zone,
            target: r53.RecordTarget.fromAlias(new r53tg.LoadBalancerTarget(props.loadbalancer)),
            recordName: props.recordName,
            ttl: props.ttl ?? cdk.Duration.minutes(5),
        });
    }
}
exports.SuperDomain = SuperDomain;
_a = JSII_RTTI_SYMBOL_1;
SuperDomain[_a] = { fqn: "@cdk-constructs-zone/super-ec2.SuperDomain", version: "0.0.364" };
//# sourceMappingURL=data:application/json;base64,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