import * as cxschema from '@aws-cdk/cloud-assembly-schema';
import { CloudArtifact } from '../cloud-artifact';
import type { CloudAssembly } from '../cloud-assembly';
/**
 * Asset manifest is a description of a set of assets which need to be built and published
 */
export declare class NestedCloudAssemblyArtifact extends CloudArtifact {
    /**
     * The relative directory name of the asset manifest
     */
    readonly directoryName: string;
    /**
     * Display name
     */
    readonly displayName: string;
    constructor(assembly: CloudAssembly, name: string, artifact: cxschema.ArtifactManifest);
    /**
     * Full path to the nested assembly directory
     */
    get fullPath(): string;
}
export interface NestedCloudAssemblyArtifact {
    /**
     * The nested Assembly
     */
    readonly nestedAssembly: CloudAssembly;
}
