"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.JenkinsEC2 = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const ec2 = require("@aws-cdk/aws-ec2");
const elbv2 = require("@aws-cdk/aws-elasticloadbalancingv2");
const targets = require("@aws-cdk/aws-elasticloadbalancingv2-targets");
const super_ec2_1 = require("./super-ec2");
const super_ec2_interfaces_1 = require("./super-ec2-interfaces");
;
class JenkinsEC2 extends super_ec2_1.SuperEC2Base {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.userData.addCommands(...this.jenkinsUserData());
        this._addIngressRule(this.defaultSecurityGroup, [22, 8080, 50000]);
        this.loadbalancer = props.loadbalancer ?? this._setloadbalancer(props.loadbalancerType);
        if (props.domain) {
            this.domain = new super_ec2_interfaces_1.SuperDomain(this, 'superDomain', { ...props.domain, loadbalancer: this.loadbalancer });
            this._setlistener(this.domain.acm);
        }
        else {
            this._set80listener();
        }
    }
    jenkinsUserData() {
        return ['yum install docker -y',
            'systemctl start docker',
            'usermod -aG docker ec2-user',
            'usermod -aG docker ssm-user',
            'chmod +x /var/run/docker.sock',
            'systemctl restart docker && systemctl enable docker',
            'mkdir /home/ec2-user/jenkins-data',
            'docker run --name jks --rm -d -u root -p 8080:8080 -p 50000:50000 -v /home/ec2-user/jenkins-data:/var/jenkins_home -v /var/run/docker.sock:/var/run/docker.sock -v /home/ec2-user:/home jenkinsci/blueocean'];
    }
    ;
    _addIngressRule(SecurityGroup, Ports) {
        Ports.forEach(port => {
            SecurityGroup.addIngressRule(ec2.Peer.anyIpv4(), ec2.Port.tcp(port));
        });
        return SecurityGroup;
    }
    _setloadbalancer(loadbalancerType) {
        switch (loadbalancerType) {
            case super_ec2_interfaces_1.ELBtype.ALB:
                return new elbv2.ApplicationLoadBalancer(this, 'jksALB', {
                    vpc: this.vpc,
                    loadBalancerName: 'jksALB',
                    internetFacing: true,
                });
            case super_ec2_interfaces_1.ELBtype.NLB:
                return new elbv2.NetworkLoadBalancer(this, 'jksNLB', {
                    vpc: this.vpc,
                    loadBalancerName: 'jksNLB',
                    internetFacing: true,
                });
            default: {
                return new elbv2.ApplicationLoadBalancer(this, 'jksALB', {
                    vpc: this.vpc,
                    loadBalancerName: 'jksALB',
                    internetFacing: true,
                });
            }
        }
    }
    _setlistener(acm) {
        const httpslistener = this.loadbalancer.addListener('httpsListener', {
            certificates: [elbv2.ListenerCertificate.fromArn(acm.certificateArn)],
            port: 443,
        });
        if (this.loadbalancer instanceof elbv2.ApplicationLoadBalancer) {
            this.loadbalancer.addListener('httpListener', {
                port: 80,
                open: true,
                defaultAction: elbv2.ListenerAction.redirect({
                    protocol: 'HTTPS',
                    host: '#{host}',
                    path: '/#{path}',
                    query: '/#{query}',
                    port: '443',
                }),
            });
        }
        if (httpslistener instanceof elbv2.ApplicationListener) {
            httpslistener.addTargets('Targets', {
                port: 8080,
                protocol: elbv2.ApplicationProtocol.HTTP,
                targets: [new targets.InstanceTarget(this.instance)],
            });
            httpslistener.connections.allowTo(this.instance, ec2.Port.tcp(8080));
        }
        else if (httpslistener instanceof elbv2.NetworkListener) {
            httpslistener.addTargets('Targets', {
                port: 8080,
                protocol: elbv2.Protocol.TCP,
                targets: [new targets.InstanceTarget(this.instance)],
            });
        }
    }
    _set80listener() {
        const httplistener = this.loadbalancer.addListener('httpListener', {
            port: 80,
        });
        if (httplistener instanceof elbv2.ApplicationListener) {
            httplistener.addTargets('Targets', {
                port: 8080,
                protocol: elbv2.ApplicationProtocol.HTTP,
                targets: [new targets.InstanceTarget(this.instance)],
            });
            httplistener.connections.allowTo(this.instance, ec2.Port.tcp(8080));
        }
        else if (httplistener instanceof elbv2.NetworkListener) {
            httplistener.addTargets('Targets', {
                port: 8080,
                protocol: elbv2.Protocol.TCP,
                targets: [new targets.InstanceTarget(this.instance)],
            });
        }
    }
}
exports.JenkinsEC2 = JenkinsEC2;
_a = JSII_RTTI_SYMBOL_1;
JenkinsEC2[_a] = { fqn: "@cdk-constructs-zone/super-ec2.JenkinsEC2", version: "0.0.358" };
//# sourceMappingURL=data:application/json;base64,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