"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StackSynthesizer = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const _shared_1 = require("./_shared");
/**
 * Base class for implementing an IStackSynthesizer
 *
 * This class needs to exist to provide public surface area for external
 * implementations of stack synthesizers. The protected methods give
 * access to functions that are otherwise @_internal to the framework
 * and could not be accessed by external implementors.
 */
class StackSynthesizer {
    /**
     * Have the stack write out its template
     */
    synthesizeStackTemplate(stack, session) {
        try {
            jsiiDeprecationWarnings._aws_cdk_core_Stack(stack);
            jsiiDeprecationWarnings._aws_cdk_core_ISynthesisSession(session);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.synthesizeStackTemplate);
            }
            throw error;
        }
        stack._synthesizeTemplate(session);
    }
    /**
     * Write the stack artifact to the session
     *
     * Use default settings to add a CloudFormationStackArtifact artifact to
     * the given synthesis session.
     */
    emitStackArtifact(stack, session, options = {}) {
        try {
            jsiiDeprecationWarnings._aws_cdk_core_Stack(stack);
            jsiiDeprecationWarnings._aws_cdk_core_ISynthesisSession(session);
            jsiiDeprecationWarnings._aws_cdk_core_SynthesizeStackArtifactOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.emitStackArtifact);
            }
            throw error;
        }
        _shared_1.addStackArtifactToAssembly(session, stack, options ?? {}, options.additionalDependencies ?? []);
    }
}
exports.StackSynthesizer = StackSynthesizer;
_a = JSII_RTTI_SYMBOL_1;
StackSynthesizer[_a] = { fqn: "@aws-cdk/core.StackSynthesizer", version: "1.163.1" };
//# sourceMappingURL=data:application/json;base64,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