import * as certmgr from '@aws-cdk/aws-certificatemanager';
import * as elbv2 from '@aws-cdk/aws-elasticloadbalancingv2';
import * as r53 from '@aws-cdk/aws-route53';
import * as cdk from '@aws-cdk/core';
export declare enum ELBtype {
    /**
     * Application Load Balancer
     */
    ALB = "ALB",
    /**
     * Network Load Balancer
     */
    NLB = "NLB"
}
export interface IDomainProps {
    /**
     * Provide a certificate
     * @default - Create a new certificate (validate from DNS)
     */
    acm?: certmgr.ICertificate;
    /**
     * HostZoneID
     */
    hostedZoneId: string;
    /**
     * zonename (e.g., `cdk-construct-zone.com`)
     */
    zoneName: string;
    /**
     * recordname (e.g., superjks)
     */
    recordName: string;
    /**
     * record cache time
     * @deafult - 5 mins.
     */
    ttl?: cdk.Duration;
}
export interface ISuperDomainProps extends IDomainProps {
    loadbalancer: elbv2.ApplicationLoadBalancer | elbv2.NetworkLoadBalancer;
}
export declare class SuperDomain extends cdk.Construct {
    readonly acm: certmgr.ICertificate;
    readonly record: r53.ARecord;
    readonly zone: r53.IHostedZone;
    constructor(scope: cdk.Construct, id: string, props: ISuperDomainProps);
    private _setzone;
    private _setacm;
    private _setaliasrecord;
}
