"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudArtifact = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cxschema = require("@aws-cdk/cloud-assembly-schema");
const metadata_1 = require("./metadata");
/**
 * Represents an artifact within a cloud assembly.
 */
class CloudArtifact {
    constructor(assembly, id, manifest) {
        this.assembly = assembly;
        this.id = id;
        try {
            jsiiDeprecationWarnings._aws_cdk_cx_api_CloudAssembly(assembly);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CloudArtifact);
            }
            throw error;
        }
        this.manifest = manifest;
        this.messages = this.renderMessages();
        this._dependencyIDs = manifest.dependencies || [];
    }
    /**
     * Returns a subclass of `CloudArtifact` based on the artifact type defined in the artifact manifest.
     *
     * @param assembly The cloud assembly from which to load the artifact
     * @param id The artifact ID
     * @param artifact The artifact manifest
     * @returns the `CloudArtifact` that matches the artifact type or `undefined` if it's an artifact type that is unrecognized by this module.
     */
    static fromManifest(assembly, id, artifact) {
        try {
            jsiiDeprecationWarnings._aws_cdk_cx_api_CloudAssembly(assembly);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromManifest);
            }
            throw error;
        }
        // Implementation is defined in a separate file to break cyclic dependencies
        void (assembly), void (id), void (artifact);
        throw new Error('Implementation not overridden yet');
    }
    /**
     * Returns all the artifacts that this artifact depends on.
     */
    get dependencies() {
        if (this._deps) {
            return this._deps;
        }
        this._deps = this._dependencyIDs.map(id => {
            const dep = this.assembly.tryGetArtifact(id);
            if (!dep) {
                throw new Error(`Artifact ${this.id} depends on non-existing artifact ${id}`);
            }
            return dep;
        });
        return this._deps;
    }
    /**
     * @returns all the metadata entries of a specific type in this artifact.
     * @param type
     */
    findMetadataByType(type) {
        const result = new Array();
        for (const path of Object.keys(this.manifest.metadata || {})) {
            for (const entry of (this.manifest.metadata || {})[path]) {
                if (entry.type === type) {
                    result.push({ path, ...entry });
                }
            }
        }
        return result;
    }
    renderMessages() {
        const messages = new Array();
        for (const [id, metadata] of Object.entries(this.manifest.metadata || {})) {
            for (const entry of metadata) {
                let level;
                switch (entry.type) {
                    case cxschema.ArtifactMetadataEntryType.WARN:
                        level = metadata_1.SynthesisMessageLevel.WARNING;
                        break;
                    case cxschema.ArtifactMetadataEntryType.ERROR:
                        level = metadata_1.SynthesisMessageLevel.ERROR;
                        break;
                    case cxschema.ArtifactMetadataEntryType.INFO:
                        level = metadata_1.SynthesisMessageLevel.INFO;
                        break;
                    default:
                        continue;
                }
                messages.push({ level, entry, id });
            }
        }
        return messages;
    }
    /**
     * An identifier that shows where this artifact is located in the tree
     * of nested assemblies, based on their manifests. Defaults to the normal
     * id. Should only be used in user interfaces.
     */
    get hierarchicalId() {
        return this.manifest.displayName ?? this.id;
    }
}
exports.CloudArtifact = CloudArtifact;
_a = JSII_RTTI_SYMBOL_1;
CloudArtifact[_a] = { fqn: "@aws-cdk/cx-api.CloudArtifact", version: "1.161.0" };
//# sourceMappingURL=data:application/json;base64,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