"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.attachCustomSynthesis = exports.App = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cxapi = require("@aws-cdk/cx-api");
const synthesis_1 = require("./private/synthesis");
const tree_metadata_1 = require("./private/tree-metadata");
const stage_1 = require("./stage");
const APP_SYMBOL = Symbol.for('@aws-cdk/core.App');
/**
 * A construct which represents an entire CDK app. This construct is normally
 * the root of the construct tree.
 *
 * You would normally define an `App` instance in your program's entrypoint,
 * then define constructs where the app is used as the parent scope.
 *
 * After all the child constructs are defined within the app, you should call
 * `app.synth()` which will emit a "cloud assembly" from this app into the
 * directory specified by `outdir`. Cloud assemblies includes artifacts such as
 * CloudFormation templates and assets that are needed to deploy this app into
 * the AWS cloud.
 *
 * @see https://docs.aws.amazon.com/cdk/latest/guide/apps.html
 */
class App extends stage_1.Stage {
    /**
     * Initializes a CDK application.
     * @param props initialization properties
     */
    constructor(props = {}) {
        super(undefined, '', {
            outdir: props.outdir ?? process.env[cxapi.OUTDIR_ENV],
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_core_AppProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, App);
            }
            throw error;
        }
        Object.defineProperty(this, APP_SYMBOL, { value: true });
        this.loadContext(props.context);
        if (props.stackTraces === false) {
            this.node.setContext(cxapi.DISABLE_METADATA_STACK_TRACE, true);
        }
        const analyticsReporting = props.analyticsReporting ?? props.runtimeInfo;
        if (analyticsReporting !== undefined) {
            this.node.setContext(cxapi.ANALYTICS_REPORTING_ENABLED_CONTEXT, analyticsReporting);
        }
        const autoSynth = props.autoSynth ?? cxapi.OUTDIR_ENV in process.env;
        if (autoSynth) {
            // synth() guarantuees it will only execute once, so a default of 'true'
            // doesn't bite manual calling of the function.
            process.once('beforeExit', () => this.synth());
        }
        if (props.treeMetadata === undefined || props.treeMetadata) {
            new tree_metadata_1.TreeMetadata(this);
        }
    }
    /**
     * Checks if an object is an instance of the `App` class.
     * @returns `true` if `obj` is an `App`.
     * @param obj The object to evaluate
     */
    static isApp(obj) {
        return APP_SYMBOL in obj;
    }
    loadContext(defaults = {}) {
        // prime with defaults passed through constructor
        for (const [k, v] of Object.entries(defaults)) {
            this.node.setContext(k, v);
        }
        // read from environment
        const contextJson = process.env[cxapi.CONTEXT_ENV];
        const contextFromEnvironment = contextJson
            ? JSON.parse(contextJson)
            : {};
        for (const [k, v] of Object.entries(contextFromEnvironment)) {
            this.node.setContext(k, v);
        }
    }
}
exports.App = App;
_a = JSII_RTTI_SYMBOL_1;
App[_a] = { fqn: "@aws-cdk/core.App", version: "1.160.0" };
/**
 * Add a custom synthesis for the given construct
 *
 * When the construct is being synthesized, this allows it to add additional items
 * into the Cloud Assembly output.
 *
 * This feature is intended for use by official AWS CDK libraries only; 3rd party
 * library authors and CDK users should not use this function. That's why it's not
 * exposed via jsii.
 */
function attachCustomSynthesis(construct, synthesis) {
    // synthesis.ts where the implementation lives is not exported. So
    // this function is just a re-export of that function.
    synthesis_1.addCustomSynthesis(construct, synthesis);
}
exports.attachCustomSynthesis = attachCustomSynthesis;
//# sourceMappingURL=data:application/json;base64,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