"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TreeCloudArtifact = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cloud_artifact_1 = require("../cloud-artifact");
class TreeCloudArtifact extends cloud_artifact_1.CloudArtifact {
    constructor(assembly, name, artifact) {
        super(assembly, name, artifact);
        try {
            jsiiDeprecationWarnings._aws_cdk_cx_api_CloudAssembly(assembly);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        const properties = (this.manifest.properties || {});
        if (!properties.file) {
            throw new Error('Invalid TreeCloudArtifact. Missing "file" property');
        }
        this.file = properties.file;
    }
}
exports.TreeCloudArtifact = TreeCloudArtifact;
_a = JSII_RTTI_SYMBOL_1;
TreeCloudArtifact[_a] = { fqn: "@aws-cdk/cx-api.TreeCloudArtifact", version: "1.159.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidHJlZS1jbG91ZC1hcnRpZmFjdC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInRyZWUtY2xvdWQtYXJ0aWZhY3QudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBQ0Esc0RBQWtEO0FBR2xELE1BQWEsaUJBQWtCLFNBQVEsOEJBQWE7SUFHbEQsWUFBWSxRQUF1QixFQUFFLElBQVksRUFBRSxRQUFtQztRQUNwRixLQUFLLENBQUMsUUFBUSxFQUFFLElBQUksRUFBRSxRQUFRLENBQUMsQ0FBQzs7Ozs7Ozs7OztRQUVoQyxNQUFNLFVBQVUsR0FBRyxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsVUFBVSxJQUFJLEVBQUUsQ0FBb0MsQ0FBQztRQUN2RixJQUFJLENBQUMsVUFBVSxDQUFDLElBQUksRUFBRTtZQUNwQixNQUFNLElBQUksS0FBSyxDQUFDLG9EQUFvRCxDQUFDLENBQUM7U0FDdkU7UUFDRCxJQUFJLENBQUMsSUFBSSxHQUFHLFVBQVUsQ0FBQyxJQUFJLENBQUM7S0FDN0I7O0FBWEgsOENBWUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBjeHNjaGVtYSBmcm9tICdAYXdzLWNkay9jbG91ZC1hc3NlbWJseS1zY2hlbWEnO1xuaW1wb3J0IHsgQ2xvdWRBcnRpZmFjdCB9IGZyb20gJy4uL2Nsb3VkLWFydGlmYWN0JztcbmltcG9ydCB7IENsb3VkQXNzZW1ibHkgfSBmcm9tICcuLi9jbG91ZC1hc3NlbWJseSc7XG5cbmV4cG9ydCBjbGFzcyBUcmVlQ2xvdWRBcnRpZmFjdCBleHRlbmRzIENsb3VkQXJ0aWZhY3Qge1xuICBwdWJsaWMgcmVhZG9ubHkgZmlsZTogc3RyaW5nO1xuXG4gIGNvbnN0cnVjdG9yKGFzc2VtYmx5OiBDbG91ZEFzc2VtYmx5LCBuYW1lOiBzdHJpbmcsIGFydGlmYWN0OiBjeHNjaGVtYS5BcnRpZmFjdE1hbmlmZXN0KSB7XG4gICAgc3VwZXIoYXNzZW1ibHksIG5hbWUsIGFydGlmYWN0KTtcblxuICAgIGNvbnN0IHByb3BlcnRpZXMgPSAodGhpcy5tYW5pZmVzdC5wcm9wZXJ0aWVzIHx8IHt9KSBhcyBjeHNjaGVtYS5UcmVlQXJ0aWZhY3RQcm9wZXJ0aWVzO1xuICAgIGlmICghcHJvcGVydGllcy5maWxlKSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoJ0ludmFsaWQgVHJlZUNsb3VkQXJ0aWZhY3QuIE1pc3NpbmcgXCJmaWxlXCIgcHJvcGVydHknKTtcbiAgICB9XG4gICAgdGhpcy5maWxlID0gcHJvcGVydGllcy5maWxlO1xuICB9XG59Il19