"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnCondition = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cfn_element_1 = require("./cfn-element");
/**
 * Represents a CloudFormation condition, for resources which must be conditionally created and
 * the determination must be made at deploy time.
 */
class CfnCondition extends cfn_element_1.CfnElement {
    /**
     * Build a new condition. The condition must be constructed with a condition token,
     * that the condition is based on.
     */
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_core_CfnConditionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        this.expression = props && props.expression;
    }
    /**
     * @internal
     */
    _toCloudFormation() {
        if (!this.expression) {
            return {};
        }
        return {
            Conditions: {
                [this.logicalId]: this.expression,
            },
        };
    }
    /**
     * Synthesizes the condition.
     */
    resolve(_context) {
        try {
            jsiiDeprecationWarnings._aws_cdk_core_IResolveContext(_context);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.resolve);
            }
            throw error;
        }
        return { Condition: this.logicalId };
    }
}
exports.CfnCondition = CfnCondition;
_a = JSII_RTTI_SYMBOL_1;
CfnCondition[_a] = { fqn: "@aws-cdk/core.CfnCondition", version: "1.159.0" };
//# sourceMappingURL=data:application/json;base64,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