"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FIREHOSE_CIDR_BLOCKS = exports.CLOUDWATCH_LAMBDA_INSIGHTS_ARNS = exports.APPMESH_ECR_ACCOUNTS = exports.DLC_REPOSITORY_ACCOUNTS = exports.ELBV2_ACCOUNTS = exports.PARTITION_MAP = exports.EBS_ENV_ENDPOINT_HOSTED_ZONE_IDS = exports.ROUTE_53_BUCKET_WEBSITE_ZONE_IDS = exports.AWS_CDK_METADATA = void 0;
exports.AWS_CDK_METADATA = new Set([
    'us-east-2',
    'us-east-1',
    'us-west-1',
    'us-west-2',
    // 'us-gov-east-1',
    // 'us-gov-west-1',
    // 'us-iso-east-1',
    // 'us-isob-east-1',
    'af-south-1',
    'ap-south-1',
    'ap-east-1',
    // 'ap-northeast-3',
    'ap-northeast-2',
    'ap-southeast-1',
    'ap-southeast-2',
    'ap-northeast-1',
    'ca-central-1',
    'cn-north-1',
    'cn-northwest-1',
    'eu-central-1',
    'eu-west-1',
    'eu-west-2',
    'eu-west-3',
    'eu-north-1',
    'eu-south-1',
    'me-south-1',
    'sa-east-1',
]);
/**
 * The hosted zone Id if using an alias record in Route53.
 *
 * @see https://docs.aws.amazon.com/general/latest/gr/s3.html#s3_region
 */
exports.ROUTE_53_BUCKET_WEBSITE_ZONE_IDS = {
    'af-south-1': 'Z11KHD8FBVPUYU',
    'ap-east-1': 'ZNB98KWMFR0R6',
    'ap-northeast-1': 'Z2M4EHUR26P7ZW',
    'ap-northeast-2': 'Z3W03O7B5YMIYP',
    'ap-northeast-3': 'Z2YQB5RD63NC85',
    'ap-south-1': 'Z11RGJOFQNVJUP',
    'ap-southeast-1': 'Z3O0J2DXBE1FTB',
    'ap-southeast-2': 'Z1WCIGYICN2BYD',
    'ap-southeast-3': 'Z01613992JD795ZI93075',
    'ca-central-1': 'Z1QDHH18159H29',
    'cn-northwest-1': 'Z282HJ1KT0DH03',
    'eu-central-1': 'Z21DNDUVLTQW6Q',
    'eu-north-1': 'Z3BAZG2TWCNX0D',
    'eu-south-1': 'Z3IXVV8C73GIO3',
    'eu-west-1': 'Z1BKCTXD74EZPE',
    'eu-west-2': 'Z3GKZC51ZF0DB4',
    'eu-west-3': 'Z3R1K369G5AVDG',
    'me-south-1': 'Z1MPMWCPA7YB62',
    'sa-east-1': 'Z7KQH4QJS55SO',
    'us-east-1': 'Z3AQBSTGFYJSTF',
    'us-east-2': 'Z2O1EMRO9K5GLX',
    'us-gov-east-1': 'Z2NIFVYYW2VKV1',
    'us-gov-west-1': 'Z31GFT0UA1I2HV',
    'us-west-1': 'Z2F56UZL2M1ACD',
    'us-west-2': 'Z3BJ6K6RIION7M',
};
/**
 * The hosted zone Id of the Elastic Beanstalk environment.
 *
 * @see https://docs.aws.amazon.com/general/latest/gr/elasticbeanstalk.html
 */
exports.EBS_ENV_ENDPOINT_HOSTED_ZONE_IDS = {
    'af-south-1': 'Z1EI3BVKMKK4AM',
    'ap-east-1': 'ZPWYUBWRU171A',
    'ap-northeast-1': 'Z1R25G3KIG2GBW',
    'ap-northeast-2': 'Z3JE5OI70TWKCP',
    'ap-northeast-3': 'ZNE5GEY1TIAGY',
    'ap-south-1': 'Z18NTBI3Y7N9TZ',
    'ap-southeast-1': 'Z16FZ9L249IFLT',
    'ap-southeast-2': 'Z2PCDNR3VC2G1N',
    'ca-central-1': 'ZJFCZL7SSZB5I',
    'eu-central-1': 'Z1FRNW7UH4DEZJ',
    'eu-north-1': 'Z23GO28BZ5AETM',
    'eu-south-1': 'Z10VDYYOA2JFKM',
    'eu-west-1': 'Z2NYPWQ7DFZAZH',
    'eu-west-2': 'Z1GKAAAUGATPF1',
    'eu-west-3': 'Z5WN6GAYWG5OB',
    'me-south-1': 'Z2BBTEKR2I36N2',
    'sa-east-1': 'Z10X7K2B4QSOFV',
    'us-east-1': 'Z117KPS5GTRQ2G',
    'us-east-2': 'Z14LCN19Q5QHIC',
    'us-gov-east-1': 'Z35TSARG0EJ4VU',
    'us-gov-west-1': 'Z4KAURWC4UUUG',
    'us-west-1': 'Z1LQECGX5PH1X',
    'us-west-2': 'Z38NKT9BP95V3O',
};
exports.PARTITION_MAP = {
    'default': { partition: 'aws', domainSuffix: 'amazonaws.com' },
    'cn-': { partition: 'aws-cn', domainSuffix: 'amazonaws.com.cn' },
    'us-gov-': { partition: 'aws-us-gov', domainSuffix: 'amazonaws.com' },
    'us-iso-': { partition: 'aws-iso', domainSuffix: 'c2s.ic.gov' },
    'us-isob-': { partition: 'aws-iso-b', domainSuffix: 'sc2s.sgov.gov' },
};
// https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-access-logs.html#access-logging-bucket-permissions
// https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/enable-access-logs.html#attach-bucket-policy
exports.ELBV2_ACCOUNTS = {
    'af-south-1': '098369216593',
    'ap-east-1': '754344448648',
    'ap-northeast-1': '582318560864',
    'ap-northeast-2': '600734575887',
    'ap-northeast-3': '383597477331',
    'ap-south-1': '718504428378',
    'ap-southeast-1': '114774131450',
    'ap-southeast-2': '783225319266',
    'ap-southeast-3': '589379963580',
    'ca-central-1': '985666609251',
    'cn-north-1': '638102146993',
    'cn-northwest-1': '037604701340',
    'eu-central-1': '054676820928',
    'eu-north-1': '897822967062',
    'eu-south-1': '635631232127',
    'eu-west-1': '156460612806',
    'eu-west-2': '652711504416',
    'eu-west-3': '009996457667',
    'me-south-1': '076674570225',
    'sa-east-1': '507241528517',
    'us-east-1': '127311923021',
    'us-east-2': '033677994240',
    'us-gov-east-1': '190560391635',
    'us-gov-west-1': '048591011584',
    'us-west-1': '027434742980',
    'us-west-2': '797873946194',
};
// https://aws.amazon.com/releasenotes/available-deep-learning-containers-images
exports.DLC_REPOSITORY_ACCOUNTS = {
    'ap-east-1': '871362719292',
    'ap-northeast-1': '763104351884',
    'ap-northeast-2': '763104351884',
    'ap-south-1': '763104351884',
    'ap-southeast-1': '763104351884',
    'ap-southeast-2': '763104351884',
    'ca-central-1': '763104351884',
    'cn-north-1': '727897471807',
    'cn-northwest-1': '727897471807',
    'eu-central-1': '763104351884',
    'eu-north-1': '763104351884',
    'eu-west-1': '763104351884',
    'eu-west-2': '763104351884',
    'eu-west-3': '763104351884',
    'me-south-1': '217643126080',
    'sa-east-1': '763104351884',
    'us-east-1': '763104351884',
    'us-east-2': '763104351884',
    'us-west-1': '763104351884',
    'us-west-2': '763104351884',
};
// https://docs.aws.amazon.com/app-mesh/latest/userguide/envoy.html
// https://docs.amazonaws.cn/app-mesh/latest/userguide/envoy.html
exports.APPMESH_ECR_ACCOUNTS = {
    'af-south-1': '924023996002',
    'ap-east-1': '856666278305',
    'ap-northeast-1': '840364872350',
    'ap-northeast-2': '840364872350',
    'ap-northeast-3': '840364872350',
    'ap-south-1': '840364872350',
    'ap-southeast-1': '840364872350',
    'ap-southeast-2': '840364872350',
    'ca-central-1': '840364872350',
    'cn-north-1': '919366029133',
    'cn-northwest-1': '919830735681',
    'eu-central-1': '840364872350',
    'eu-north-1': '840364872350',
    'eu-south-1': '422531588944',
    'eu-west-1': '840364872350',
    'eu-west-2': '840364872350',
    'eu-west-3': '840364872350',
    'me-south-1': '772975370895',
    'sa-east-1': '840364872350',
    'us-east-1': '840364872350',
    'us-east-2': '840364872350',
    'us-west-1': '840364872350',
    'us-west-2': '840364872350',
};
// https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Lambda-Insights-extension-versions.html
exports.CLOUDWATCH_LAMBDA_INSIGHTS_ARNS = {
    '1.0.119.0': {
        arm64: {
            // US East (N. Virginia)
            'us-east-1': 'arn:aws:lambda:us-east-1:580247275435:layer:LambdaInsightsExtension-Arm64:1',
            // US East (Ohio)
            'us-east-2': 'arn:aws:lambda:us-east-2:580247275435:layer:LambdaInsightsExtension-Arm64:1',
            // US West (Oregon)
            'us-west-2': 'arn:aws:lambda:us-west-2:580247275435:layer:LambdaInsightsExtension-Arm64:1',
            // Asia Pacific (Mumbai)
            'ap-south-1': 'arn:aws:lambda:ap-south-1:580247275435:layer:LambdaInsightsExtension-Arm64:1',
            // Asia Pacific (Singapore)
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:580247275435:layer:LambdaInsightsExtension-Arm64:1',
            // Asia Pacific (Sydney)
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:580247275435:layer:LambdaInsightsExtension-Arm64:1',
            // Asia Pacific (Tokyo)
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:580247275435:layer:LambdaInsightsExtension-Arm64:1',
            // Europe (Frankfurt)
            'eu-central-1': 'arn:aws:lambda:eu-central-1:580247275435:layer:LambdaInsightsExtension-Arm64:1',
            // Europe (Ireland)
            'eu-west-1': 'arn:aws:lambda:eu-west-1:580247275435:layer:LambdaInsightsExtension-Arm64:1',
            // Europe (London)
            'eu-west-2': 'arn:aws:lambda:eu-west-2:580247275435:layer:LambdaInsightsExtension-Arm64:1',
        },
        x86_64: {
            // US East (N. Virginia)
            'us-east-1': 'arn:aws:lambda:us-east-1:580247275435:layer:LambdaInsightsExtension:16',
            // US East (Ohio)
            'us-east-2': 'arn:aws:lambda:us-east-2:580247275435:layer:LambdaInsightsExtension:16',
            // US West (N. California)
            'us-west-1': 'arn:aws:lambda:us-west-1:580247275435:layer:LambdaInsightsExtension:16',
            // US West (Oregon)
            'us-west-2': 'arn:aws:lambda:us-west-2:580247275435:layer:LambdaInsightsExtension:16',
            // Africa (Cape Town)
            'af-south-1': 'arn:aws:lambda:af-south-1:012438385374:layer:LambdaInsightsExtension:9',
            // Asia Pacific (Hong Kong)
            'ap-east-1': 'arn:aws:lambda:ap-east-1:519774774795:layer:LambdaInsightsExtension:9',
            // Asia Pacific (Mumbai)
            'ap-south-1': 'arn:aws:lambda:ap-south-1:580247275435:layer:LambdaInsightsExtension:16',
            // Asia Pacific (Seoul)
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:580247275435:layer:LambdaInsightsExtension:16',
            // Asia Pacific (Singapore)
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:580247275435:layer:LambdaInsightsExtension:16',
            // Asia Pacific (Sydney)
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:580247275435:layer:LambdaInsightsExtension:16',
            // Asia Pacific (Tokyo)
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:580247275435:layer:LambdaInsightsExtension:23',
            // Canada (Central)
            'ca-central-1': 'arn:aws:lambda:ca-central-1:580247275435:layer:LambdaInsightsExtension:16',
            // China (Beijing)
            'cn-north-1': 'arn:aws-cn:lambda:cn-north-1:488211338238:layer:LambdaInsightsExtension:9',
            // China (Ningxia)
            'cn-northwest-1': 'arn:aws-cn:lambda:cn-northwest-1:488211338238:layer:LambdaInsightsExtension:9',
            // Europe (Frankfurt)
            'eu-central-1': 'arn:aws:lambda:eu-central-1:580247275435:layer:LambdaInsightsExtension:16',
            // Europe (Ireland)
            'eu-west-1': 'arn:aws:lambda:eu-west-1:580247275435:layer:LambdaInsightsExtension:16',
            // Europe (London)
            'eu-west-2': 'arn:aws:lambda:eu-west-2:580247275435:layer:LambdaInsightsExtension:16',
            // Europe (Milan)
            'eu-south-1': 'arn:aws:lambda:eu-south-1:339249233099:layer:LambdaInsightsExtension:9',
            // Europe (Paris)
            'eu-west-3': 'arn:aws:lambda:eu-west-3:580247275435:layer:LambdaInsightsExtension:16',
            // Europe (Stockholm)
            'eu-north-1': 'arn:aws:lambda:eu-north-1:580247275435:layer:LambdaInsightsExtension:16',
            // Middle East (Bahrain)
            'me-south-1': 'arn:aws:lambda:me-south-1:285320876703:layer:LambdaInsightsExtension:9',
            // South America (Sao Paulo)
            'sa-east-1': 'arn:aws:lambda:sa-east-1:580247275435:layer:LambdaInsightsExtension:16',
        },
    },
    '1.0.98.0': {
        x86_64: {
            'us-east-1': 'arn:aws:lambda:us-east-1:580247275435:layer:LambdaInsightsExtension:14',
            'us-east-2': 'arn:aws:lambda:us-east-2:580247275435:layer:LambdaInsightsExtension:14',
            'us-west-1': 'arn:aws:lambda:us-west-1:580247275435:layer:LambdaInsightsExtension:14',
            'us-west-2': 'arn:aws:lambda:us-west-2:580247275435:layer:LambdaInsightsExtension:14',
            'af-south-1': 'arn:aws:lambda:af-south-1:012438385374:layer:LambdaInsightsExtension:8',
            'ap-east-1': 'arn:aws:lambda:ap-east-1:519774774795:layer:LambdaInsightsExtension:8',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:580247275435:layer:LambdaInsightsExtension:14',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:580247275435:layer:LambdaInsightsExtension:14',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:580247275435:layer:LambdaInsightsExtension:14',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:580247275435:layer:LambdaInsightsExtension:14',
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:580247275435:layer:LambdaInsightsExtension:14',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:580247275435:layer:LambdaInsightsExtension:14',
            'cn-north-1': 'arn:aws-cn:lambda:cn-north-1:488211338238:layer:LambdaInsightsExtension:8',
            'cn-northwest-1': 'arn:aws-cn:lambda:cn-northwest-1:488211338238:layer:LambdaInsightsExtension:8',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:580247275435:layer:LambdaInsightsExtension:14',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:580247275435:layer:LambdaInsightsExtension:14',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:580247275435:layer:LambdaInsightsExtension:14',
            'eu-south-1': 'arn:aws:lambda:eu-south-1:339249233099:layer:LambdaInsightsExtension:8',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:580247275435:layer:LambdaInsightsExtension:14',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:580247275435:layer:LambdaInsightsExtension:14',
            'me-south-1': 'arn:aws:lambda:me-south-1:285320876703:layer:LambdaInsightsExtension:8',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:580247275435:layer:LambdaInsightsExtension:14',
        },
    },
    '1.0.89.0': {
        x86_64: {
            'us-east-1': 'arn:aws:lambda:us-east-1:580247275435:layer:LambdaInsightsExtension:12',
            'us-east-2': 'arn:aws:lambda:us-east-2:580247275435:layer:LambdaInsightsExtension:12',
            'us-west-1': 'arn:aws:lambda:us-west-1:580247275435:layer:LambdaInsightsExtension:12',
            'us-west-2': 'arn:aws:lambda:us-west-2:580247275435:layer:LambdaInsightsExtension:12',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:580247275435:layer:LambdaInsightsExtension:12',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:580247275435:layer:LambdaInsightsExtension:12',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:580247275435:layer:LambdaInsightsExtension:12',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:580247275435:layer:LambdaInsightsExtension:12',
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:580247275435:layer:LambdaInsightsExtension:12',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:580247275435:layer:LambdaInsightsExtension:12',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:580247275435:layer:LambdaInsightsExtension:12',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:580247275435:layer:LambdaInsightsExtension:12',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:580247275435:layer:LambdaInsightsExtension:12',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:580247275435:layer:LambdaInsightsExtension:12',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:580247275435:layer:LambdaInsightsExtension:12',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:580247275435:layer:LambdaInsightsExtension:12',
        },
    },
    '1.0.86.0': {
        x86_64: {
            'us-east-1': 'arn:aws:lambda:us-east-1:580247275435:layer:LambdaInsightsExtension:11',
            'us-east-2': 'arn:aws:lambda:us-east-2:580247275435:layer:LambdaInsightsExtension:11',
            'us-west-1': 'arn:aws:lambda:us-west-1:580247275435:layer:LambdaInsightsExtension:11',
            'us-west-2': 'arn:aws:lambda:us-west-2:580247275435:layer:LambdaInsightsExtension:11',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:580247275435:layer:LambdaInsightsExtension:11',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:580247275435:layer:LambdaInsightsExtension:11',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:580247275435:layer:LambdaInsightsExtension:11',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:580247275435:layer:LambdaInsightsExtension:11',
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:580247275435:layer:LambdaInsightsExtension:11',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:580247275435:layer:LambdaInsightsExtension:11',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:580247275435:layer:LambdaInsightsExtension:11',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:580247275435:layer:LambdaInsightsExtension:11',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:580247275435:layer:LambdaInsightsExtension:11',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:580247275435:layer:LambdaInsightsExtension:11',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:580247275435:layer:LambdaInsightsExtension:11',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:580247275435:layer:LambdaInsightsExtension:11',
        },
    },
    '1.0.54.0': {
        x86_64: {
            'us-east-1': 'arn:aws:lambda:us-east-1:580247275435:layer:LambdaInsightsExtension:2',
            'us-east-2': 'arn:aws:lambda:us-east-2:580247275435:layer:LambdaInsightsExtension:2',
            'us-west-1': 'arn:aws:lambda:us-west-1:580247275435:layer:LambdaInsightsExtension:2',
            'us-west-2': 'arn:aws:lambda:us-west-2:580247275435:layer:LambdaInsightsExtension:2',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:580247275435:layer:LambdaInsightsExtension:2',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:580247275435:layer:LambdaInsightsExtension:2',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:580247275435:layer:LambdaInsightsExtension:2',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:580247275435:layer:LambdaInsightsExtension:2',
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:580247275435:layer:LambdaInsightsExtension:2',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:580247275435:layer:LambdaInsightsExtension:2',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:580247275435:layer:LambdaInsightsExtension:2',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:580247275435:layer:LambdaInsightsExtension:2',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:580247275435:layer:LambdaInsightsExtension:2',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:580247275435:layer:LambdaInsightsExtension:2',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:580247275435:layer:LambdaInsightsExtension:2',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:580247275435:layer:LambdaInsightsExtension:2',
        },
    },
};
// https://docs.aws.amazon.com/firehose/latest/dev/controlling-access.html#using-iam-rs-vpc
exports.FIREHOSE_CIDR_BLOCKS = {
    'af-south-1': '13.244.121.224',
    'ap-east-1': '18.162.221.32',
    'ap-northeast-1': '13.113.196.224',
    'ap-northeast-2': '13.209.1.64',
    'ap-northeast-3': '13.208.177.192',
    'ap-south-1': '13.232.67.32',
    'ap-southeast-1': '13.228.64.192',
    'ap-southeast-2': '13.210.67.224',
    'ca-central-1': '35.183.92.128',
    'cn-north-1': '52.81.151.32',
    'cn-northwest-1': '161.189.23.64',
    'eu-central-1': '35.158.127.160',
    'eu-north-1': '13.53.63.224',
    'eu-south-1': '15.161.135.128',
    'eu-west-1': '52.19.239.192',
    'eu-west-2': '18.130.1.96',
    'eu-west-3': '35.180.1.96',
    'me-south-1': '15.185.91.0',
    'sa-east-1': '18.228.1.128',
    'us-east-1': '52.70.63.192',
    'us-east-2': '13.58.135.96',
    'us-gov-east-1': '18.253.138.96',
    'us-gov-west-1': '52.61.204.160',
    'us-west-1': '13.57.135.192',
    'us-west-2': '52.89.255.224',
};
//# sourceMappingURL=data:application/json;base64,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