"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Names = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constructs_1 = require("constructs");
const uniqueid_1 = require("./private/uniqueid");
/**
 * Functions for devising unique names for constructs. For example, those can be
 * used to allocate unique physical names for resources.
 */
class Names {
    constructor() { }
    /**
     * Returns a CloudFormation-compatible unique identifier for a construct based
     * on its path. The identifier includes a human readable portion rendered
     * from the path components and a hash suffix.
     *
     * @param construct The construct
     * @returns a unique id based on the construct path
     */
    static uniqueId(construct) {
        const node = constructs_1.Node.of(construct);
        const components = node.scopes.slice(1).map(c => constructs_1.Node.of(c).id);
        return components.length > 0 ? uniqueid_1.makeUniqueId(components) : '';
    }
    /**
     * Returns a CloudFormation-compatible unique identifier for a construct based
     * on its path. The identifier includes a human readable portion rendered
     * from the path components and a hash suffix.
     *
     * TODO (v2): replace with API to use `constructs.Node`.
     *
     * @param node The construct node
     * @returns a unique id based on the construct path
     */
    static nodeUniqueId(node) {
        try {
            jsiiDeprecationWarnings._aws_cdk_core_ConstructNode(node);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.nodeUniqueId);
            }
            throw error;
        }
        const components = node.scopes.slice(1).map(c => c.node.id);
        return components.length > 0 ? uniqueid_1.makeUniqueId(components) : '';
    }
}
exports.Names = Names;
_a = JSII_RTTI_SYMBOL_1;
Names[_a] = { fqn: "@aws-cdk/core.Names", version: "1.158.0" };
//# sourceMappingURL=data:application/json;base64,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