import * as ec2 from '@aws-cdk/aws-ec2';
import * as cdk from '@aws-cdk/core';
import { AmiOSType } from './ami';
export interface ISuperEC2BaseProps {
    /**
     * Super EC2 OS you want.
     *
     * @default - Amzaon Linux 2.
     */
    amiOSType?: AmiOSType;
    /**
     * Super EC2 Vpc.
     *
     * @default - Create a new Vpc.
     */
    vpc?: ec2.IVpc;
    /**
     * Super EC2 Instance Type.
     *
     * @default - t3.small.
     */
    instanceType?: ec2.InstanceType;
}
export declare abstract class SuperEC2Base extends cdk.Construct {
    readonly instance: ec2.Instance;
    readonly vpc: ec2.IVpc;
    readonly userData: ec2.UserData;
    readonly defaultSecurityGroup: ec2.SecurityGroup;
    constructor(scope: cdk.Construct, id: string, props: ISuperEC2BaseProps);
}
//# sourceMappingURL=super-ec2.d.ts.map