"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NestedCloudAssemblyArtifact = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const cloud_artifact_1 = require("../cloud-artifact");
/**
 * Asset manifest is a description of a set of assets which need to be built and published
 */
class NestedCloudAssemblyArtifact extends cloud_artifact_1.CloudArtifact {
    constructor(assembly, name, artifact) {
        var _b;
        super(assembly, name, artifact);
        try {
            jsiiDeprecationWarnings._aws_cdk_cx_api_CloudAssembly(assembly);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        const properties = (this.manifest.properties || {});
        this.directoryName = properties.directoryName;
        this.displayName = (_b = properties.displayName) !== null && _b !== void 0 ? _b : name;
    }
    /**
     * Full path to the nested assembly directory
     */
    get fullPath() {
        return path.join(this.assembly.directory, this.directoryName);
    }
}
exports.NestedCloudAssemblyArtifact = NestedCloudAssemblyArtifact;
_a = JSII_RTTI_SYMBOL_1;
NestedCloudAssemblyArtifact[_a] = { fqn: "@aws-cdk/cx-api.NestedCloudAssemblyArtifact", version: "1.157.0" };
//# sourceMappingURL=data:application/json;base64,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