import * as elbv2 from '@aws-cdk/aws-elasticloadbalancingv2';
import * as cdk from '@aws-cdk/core';
import { SuperEC2Base, ISuperEC2BaseProps } from './super-ec2';
import { ELBtype, IDomainProps, SuperDomain } from './super-ec2-interfaces';
export interface IJenkinsEC2Props extends ISuperEC2BaseProps {
    /**
     * Provide a loadbalancer.
     *
     * Only support ALB and NLB.
     * @default - Create ApplicationLoadBalancer
     */
    loadbalancer?: elbv2.ApplicationLoadBalancer | elbv2.NetworkLoadBalancer;
    /**
     * ELB type.
     * @default - ELBtype.ALB
     */
    loadbalancerType?: ELBtype;
    /**
     * Provide domain attribute.
     * @default - Not use certificate and route53
     */
    domain?: IDomainProps;
}
export declare class JenkinsEC2 extends SuperEC2Base {
    readonly loadbalancer: elbv2.ApplicationLoadBalancer | elbv2.NetworkLoadBalancer;
    readonly domain?: SuperDomain;
    constructor(scope: cdk.Construct, id: string, props: IJenkinsEC2Props);
    jenkinsUserData(): string[];
    private _addIngressRule;
    private _setloadbalancer;
    private _setlistener;
    private _set80listener;
}
//# sourceMappingURL=jenkins-ec2.d.ts.map