"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CustomResourceProvider = exports.CustomResourceProviderRuntime = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const path = require("path");
const cxapi = require("@aws-cdk/cx-api");
const asset_staging_1 = require("../asset-staging");
const assets_1 = require("../assets");
const cfn_resource_1 = require("../cfn-resource");
const duration_1 = require("../duration");
const size_1 = require("../size");
const stack_1 = require("../stack");
const token_1 = require("../token");
const ENTRYPOINT_FILENAME = '__entrypoint__';
const ENTRYPOINT_NODEJS_SOURCE = path.join(__dirname, 'nodejs-entrypoint.js');
// v2 - keep this import as a separate section to reduce merge conflict when forward merging with the v2 branch.
// eslint-disable-next-line
const construct_compat_1 = require("../construct-compat");
/**
 * The lambda runtime to use for the resource provider. This also indicates
 * which language is used for the handler.
 */
var CustomResourceProviderRuntime;
(function (CustomResourceProviderRuntime) {
    /**
     * Node.js 12.x
     *
     * @deprecated Use {@link NODEJS_12_X}
     */
    CustomResourceProviderRuntime["NODEJS_12"] = "nodejs12.x";
    /**
     * Node.js 12.x
     */
    CustomResourceProviderRuntime["NODEJS_12_X"] = "nodejs12.x";
    /**
     * Node.js 14.x
     */
    CustomResourceProviderRuntime["NODEJS_14_X"] = "nodejs14.x";
})(CustomResourceProviderRuntime = exports.CustomResourceProviderRuntime || (exports.CustomResourceProviderRuntime = {}));
/**
 * An AWS-Lambda backed custom resource provider, for CDK Construct Library constructs
 *
 * This is a provider for `CustomResource` constructs, backed by an AWS Lambda
 * Function. It only supports NodeJS runtimes.
 *
 * **This is not a generic custom resource provider class**. It is specifically
 * intended to be used only by constructs in the AWS CDK Construct Library, and
 * only exists here because of reverse dependency issues (for example, it cannot
 * use `iam.PolicyStatement` objects, since the `iam` library already depends on
 * the CDK `core` library and we cannot have cyclic dependencies).
 *
 * If you are not writing constructs for the AWS Construct Library, you should
 * use the `Provider` class in the `custom-resources` module instead, which has
 * a better API and supports all Lambda runtimes, not just Node.
 *
 * N.B.: When you are writing Custom Resource Providers, there are a number of
 * lifecycle events you have to pay attention to. These are documented in the
 * README of the `custom-resources` module. Be sure to give the documentation
 * in that module a read, regardless of whether you end up using the Provider
 * class in there or this one.
 */
class CustomResourceProvider extends construct_compat_1.Construct {
    constructor(scope, id, props) {
        var _b, _c, _d;
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_core_CustomResourceProviderProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        const stack = stack_1.Stack.of(scope);
        // copy the entry point to the code directory
        fs.copyFileSync(ENTRYPOINT_NODEJS_SOURCE, path.join(props.codeDirectory, `${ENTRYPOINT_FILENAME}.js`));
        // verify we have an index file there
        if (!fs.existsSync(path.join(props.codeDirectory, 'index.js'))) {
            throw new Error(`cannot find ${props.codeDirectory}/index.js`);
        }
        const staging = new asset_staging_1.AssetStaging(this, 'Staging', {
            sourcePath: props.codeDirectory,
        });
        const assetFileName = staging.relativeStagedPath(stack);
        const asset = stack.synthesizer.addFileAsset({
            fileName: assetFileName,
            sourceHash: staging.assetHash,
            packaging: assets_1.FileAssetPackaging.ZIP_DIRECTORY,
        });
        const policies = !props.policyStatements ? undefined : [
            {
                PolicyName: 'Inline',
                PolicyDocument: {
                    Version: '2012-10-17',
                    Statement: props.policyStatements,
                },
            },
        ];
        const role = new cfn_resource_1.CfnResource(this, 'Role', {
            type: 'AWS::IAM::Role',
            properties: {
                AssumeRolePolicyDocument: {
                    Version: '2012-10-17',
                    Statement: [{ Action: 'sts:AssumeRole', Effect: 'Allow', Principal: { Service: 'lambda.amazonaws.com' } }],
                },
                ManagedPolicyArns: [
                    { 'Fn::Sub': 'arn:${AWS::Partition}:iam::aws:policy/service-role/AWSLambdaBasicExecutionRole' },
                ],
                Policies: policies,
            },
        });
        this.roleArn = token_1.Token.asString(role.getAtt('Arn'));
        const timeout = (_b = props.timeout) !== null && _b !== void 0 ? _b : duration_1.Duration.minutes(15);
        const memory = (_c = props.memorySize) !== null && _c !== void 0 ? _c : size_1.Size.mebibytes(128);
        const handler = new cfn_resource_1.CfnResource(this, 'Handler', {
            type: 'AWS::Lambda::Function',
            properties: {
                Code: {
                    S3Bucket: asset.bucketName,
                    S3Key: asset.objectKey,
                },
                Timeout: timeout.toSeconds(),
                MemorySize: memory.toMebibytes(),
                Handler: `${ENTRYPOINT_FILENAME}.handler`,
                Role: role.getAtt('Arn'),
                Runtime: props.runtime,
                Environment: this.renderEnvironmentVariables(props.environment),
                Description: (_d = props.description) !== null && _d !== void 0 ? _d : undefined,
            },
        });
        handler.addDependsOn(role);
        if (this.node.tryGetContext(cxapi.ASSET_RESOURCE_METADATA_ENABLED_CONTEXT)) {
            handler.addMetadata(cxapi.ASSET_RESOURCE_METADATA_PATH_KEY, assetFileName);
            handler.addMetadata(cxapi.ASSET_RESOURCE_METADATA_PROPERTY_KEY, 'Code');
        }
        this.serviceToken = token_1.Token.asString(handler.getAtt('Arn'));
    }
    /**
     * Returns a stack-level singleton ARN (service token) for the custom resource
     * provider.
     *
     * @param scope Construct scope
     * @param uniqueid A globally unique id that will be used for the stack-level
     * construct.
     * @param props Provider properties which will only be applied when the
     * provider is first created.
     * @returns the service token of the custom resource provider, which should be
     * used when defining a `CustomResource`.
     */
    static getOrCreate(scope, uniqueid, props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_core_CustomResourceProviderProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.getOrCreate);
            }
            throw error;
        }
        return this.getOrCreateProvider(scope, uniqueid, props).serviceToken;
    }
    /**
     * Returns a stack-level singleton for the custom resource provider.
     *
     * @param scope Construct scope
     * @param uniqueid A globally unique id that will be used for the stack-level
     * construct.
     * @param props Provider properties which will only be applied when the
     * provider is first created.
     * @returns the service token of the custom resource provider, which should be
     * used when defining a `CustomResource`.
     */
    static getOrCreateProvider(scope, uniqueid, props) {
        var _b;
        try {
            jsiiDeprecationWarnings._aws_cdk_core_CustomResourceProviderProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.getOrCreateProvider);
            }
            throw error;
        }
        const id = `${uniqueid}CustomResourceProvider`;
        const stack = stack_1.Stack.of(scope);
        const provider = (_b = stack.node.tryFindChild(id)) !== null && _b !== void 0 ? _b : new CustomResourceProvider(stack, id, props);
        return provider;
    }
    renderEnvironmentVariables(env) {
        if (!env || Object.keys(env).length === 0) {
            return undefined;
        }
        // Sort environment so the hash of the function used to create
        // `currentVersion` is not affected by key order (this is how lambda does
        // it)
        const variables = {};
        const keys = Object.keys(env).sort();
        for (const key of keys) {
            variables[key] = env[key];
        }
        return { Variables: variables };
    }
}
exports.CustomResourceProvider = CustomResourceProvider;
_a = JSII_RTTI_SYMBOL_1;
CustomResourceProvider[_a] = { fqn: "@aws-cdk/core.CustomResourceProvider", version: "1.155.0" };
//# sourceMappingURL=data:application/json;base64,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