"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnJson = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const custom_resource_1 = require("./custom-resource");
const cfn_utils_provider_1 = require("./private/cfn-utils-provider");
const stack_1 = require("./stack");
const stack_trace_1 = require("./stack-trace");
// v2 - keep this import as a separate section to reduce merge conflict when forward merging with the v2 branch.
// eslint-disable-next-line
const construct_compat_1 = require("./construct-compat");
/**
 * Captures a synthesis-time JSON object a CloudFormation reference which
 * resolves during deployment to the resolved values of the JSON object.
 *
 * The main use case for this is to overcome a limitation in CloudFormation that
 * does not allow using intrinsic functions as dictionary keys (because
 * dictionary keys in JSON must be strings). Specifically this is common in IAM
 * conditions such as `StringEquals: { lhs: "rhs" }` where you want "lhs" to be
 * a reference.
 *
 * This object is resolvable, so it can be used as a value.
 *
 * This construct is backed by a custom resource.
 */
class CfnJson extends construct_compat_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.creationStack = [];
        try {
            jsiiDeprecationWarnings._aws_cdk_core_CfnJsonProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        this.creationStack = stack_trace_1.captureStackTrace();
        // stringify the JSON object in a token-aware way.
        this.jsonString = stack_1.Stack.of(this).toJsonString(props.value);
        const resource = new custom_resource_1.CustomResource(this, 'Resource', {
            serviceToken: cfn_utils_provider_1.CfnUtilsProvider.getOrCreate(this),
            resourceType: "Custom::AWSCDKCfnJson" /* CFN_JSON */,
            properties: {
                Value: this.jsonString,
            },
        });
        this.value = resource.getAtt('Value');
    }
    /**
     * This is required in case someone JSON.stringifys an object which refrences
     * this object. Otherwise, we'll get a cyclic JSON reference.
     */
    toJSON() {
        return this.jsonString;
    }
    resolve(_) {
        try {
            jsiiDeprecationWarnings._aws_cdk_core_IResolveContext(_);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.resolve);
            }
            throw error;
        }
        return this.value;
    }
}
exports.CfnJson = CfnJson;
_a = JSII_RTTI_SYMBOL_1;
CfnJson[_a] = { fqn: "@aws-cdk/core.CfnJson", version: "1.155.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY2ZuLWpzb24uanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJjZm4tanNvbi50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7QUFDQSx1REFBbUQ7QUFDbkQscUVBQWdFO0FBSWhFLG1DQUFnQztBQUNoQywrQ0FBa0Q7QUFFbEQsZ0hBQWdIO0FBQ2hILDJCQUEyQjtBQUMzQix5REFBZ0U7QUFVaEU7Ozs7Ozs7Ozs7Ozs7R0FhRztBQUNILE1BQWEsT0FBUSxTQUFRLDRCQUFhO0lBY3hDLFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBbUI7UUFDM0QsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQWRILGtCQUFhLEdBQWEsRUFBRSxDQUFDOzs7Ozs7Ozs7O1FBZ0IzQyxJQUFJLENBQUMsYUFBYSxHQUFHLCtCQUFpQixFQUFFLENBQUM7UUFFekMsa0RBQWtEO1FBQ2xELElBQUksQ0FBQyxVQUFVLEdBQUcsYUFBSyxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxZQUFZLENBQUMsS0FBSyxDQUFDLEtBQUssQ0FBQyxDQUFDO1FBRTNELE1BQU0sUUFBUSxHQUFHLElBQUksZ0NBQWMsQ0FBQyxJQUFJLEVBQUUsVUFBVSxFQUFFO1lBQ3BELFlBQVksRUFBRSxxQ0FBZ0IsQ0FBQyxXQUFXLENBQUMsSUFBSSxDQUFDO1lBQ2hELFlBQVksd0NBQStCO1lBQzNDLFVBQVUsRUFBRTtnQkFDVixLQUFLLEVBQUUsSUFBSSxDQUFDLFVBQVU7YUFDdkI7U0FDRixDQUFDLENBQUM7UUFFSCxJQUFJLENBQUMsS0FBSyxHQUFHLFFBQVEsQ0FBQyxNQUFNLENBQUMsT0FBTyxDQUFDLENBQUM7S0FDdkM7SUFFRDs7O09BR0c7SUFDSSxNQUFNO1FBQ1gsT0FBTyxJQUFJLENBQUMsVUFBVSxDQUFDO0tBQ3hCO0lBRU0sT0FBTyxDQUFDLENBQWtCOzs7Ozs7Ozs7O1FBQy9CLE9BQU8sSUFBSSxDQUFDLEtBQUssQ0FBQztLQUNuQjs7QUEzQ0gsMEJBNENDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5pbXBvcnQgeyBDdXN0b21SZXNvdXJjZSB9IGZyb20gJy4vY3VzdG9tLXJlc291cmNlJztcbmltcG9ydCB7IENmblV0aWxzUHJvdmlkZXIgfSBmcm9tICcuL3ByaXZhdGUvY2ZuLXV0aWxzLXByb3ZpZGVyJztcbmltcG9ydCB7IENmblV0aWxzUmVzb3VyY2VUeXBlIH0gZnJvbSAnLi9wcml2YXRlL2Nmbi11dGlscy1wcm92aWRlci9jb25zdHMnO1xuaW1wb3J0IHsgUmVmZXJlbmNlIH0gZnJvbSAnLi9yZWZlcmVuY2UnO1xuaW1wb3J0IHsgSVJlc29sdmFibGUsIElSZXNvbHZlQ29udGV4dCB9IGZyb20gJy4vcmVzb2x2YWJsZSc7XG5pbXBvcnQgeyBTdGFjayB9IGZyb20gJy4vc3RhY2snO1xuaW1wb3J0IHsgY2FwdHVyZVN0YWNrVHJhY2UgfSBmcm9tICcuL3N0YWNrLXRyYWNlJztcblxuLy8gdjIgLSBrZWVwIHRoaXMgaW1wb3J0IGFzIGEgc2VwYXJhdGUgc2VjdGlvbiB0byByZWR1Y2UgbWVyZ2UgY29uZmxpY3Qgd2hlbiBmb3J3YXJkIG1lcmdpbmcgd2l0aCB0aGUgdjIgYnJhbmNoLlxuLy8gZXNsaW50LWRpc2FibGUtbmV4dC1saW5lXG5pbXBvcnQgeyBDb25zdHJ1Y3QgYXMgQ29yZUNvbnN0cnVjdCB9IGZyb20gJy4vY29uc3RydWN0LWNvbXBhdCc7XG5cbmV4cG9ydCBpbnRlcmZhY2UgQ2ZuSnNvblByb3BzIHtcbiAgLyoqXG4gICAqIFRoZSB2YWx1ZSB0byByZXNvbHZlLiBDYW4gYmUgYW55IEphdmFTY3JpcHQgb2JqZWN0LCBpbmNsdWRpbmcgdG9rZW5zIGFuZFxuICAgKiByZWZlcmVuY2VzIGluIGtleXMgb3IgdmFsdWVzLlxuICAgKi9cbiAgcmVhZG9ubHkgdmFsdWU6IGFueTtcbn1cblxuLyoqXG4gKiBDYXB0dXJlcyBhIHN5bnRoZXNpcy10aW1lIEpTT04gb2JqZWN0IGEgQ2xvdWRGb3JtYXRpb24gcmVmZXJlbmNlIHdoaWNoXG4gKiByZXNvbHZlcyBkdXJpbmcgZGVwbG95bWVudCB0byB0aGUgcmVzb2x2ZWQgdmFsdWVzIG9mIHRoZSBKU09OIG9iamVjdC5cbiAqXG4gKiBUaGUgbWFpbiB1c2UgY2FzZSBmb3IgdGhpcyBpcyB0byBvdmVyY29tZSBhIGxpbWl0YXRpb24gaW4gQ2xvdWRGb3JtYXRpb24gdGhhdFxuICogZG9lcyBub3QgYWxsb3cgdXNpbmcgaW50cmluc2ljIGZ1bmN0aW9ucyBhcyBkaWN0aW9uYXJ5IGtleXMgKGJlY2F1c2VcbiAqIGRpY3Rpb25hcnkga2V5cyBpbiBKU09OIG11c3QgYmUgc3RyaW5ncykuIFNwZWNpZmljYWxseSB0aGlzIGlzIGNvbW1vbiBpbiBJQU1cbiAqIGNvbmRpdGlvbnMgc3VjaCBhcyBgU3RyaW5nRXF1YWxzOiB7IGxoczogXCJyaHNcIiB9YCB3aGVyZSB5b3Ugd2FudCBcImxoc1wiIHRvIGJlXG4gKiBhIHJlZmVyZW5jZS5cbiAqXG4gKiBUaGlzIG9iamVjdCBpcyByZXNvbHZhYmxlLCBzbyBpdCBjYW4gYmUgdXNlZCBhcyBhIHZhbHVlLlxuICpcbiAqIFRoaXMgY29uc3RydWN0IGlzIGJhY2tlZCBieSBhIGN1c3RvbSByZXNvdXJjZS5cbiAqL1xuZXhwb3J0IGNsYXNzIENmbkpzb24gZXh0ZW5kcyBDb3JlQ29uc3RydWN0IGltcGxlbWVudHMgSVJlc29sdmFibGUge1xuICBwdWJsaWMgcmVhZG9ubHkgY3JlYXRpb25TdGFjazogc3RyaW5nW10gPSBbXTtcblxuICAvKipcbiAgICogQW4gRm46OkdldEF0dCB0byB0aGUgSlNPTiBvYmplY3QgcGFzc2VkIHRocm91Z2ggYHZhbHVlYCBhbmQgcmVzb2x2ZWQgZHVyaW5nXG4gICAqIHN5bnRoZXNpcy5cbiAgICpcbiAgICogTm9ybWFsbHkgdGhlcmUgaXMgbm8gbmVlZCB0byB1c2UgdGhpcyBwcm9wZXJ0eSBzaW5jZSBgQ2ZuSnNvbmAgaXMgYW5cbiAgICogSVJlc29sdmFibGUsIHNvIGl0IGNhbiBiZSBzaW1wbHkgdXNlZCBhcyBhIHZhbHVlLlxuICAgKi9cbiAgcHVibGljIHJlYWRvbmx5IHZhbHVlOiBSZWZlcmVuY2U7XG5cbiAgcHJpdmF0ZSByZWFkb25seSBqc29uU3RyaW5nOiBzdHJpbmc7XG5cbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IENmbkpzb25Qcm9wcykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCk7XG5cbiAgICB0aGlzLmNyZWF0aW9uU3RhY2sgPSBjYXB0dXJlU3RhY2tUcmFjZSgpO1xuXG4gICAgLy8gc3RyaW5naWZ5IHRoZSBKU09OIG9iamVjdCBpbiBhIHRva2VuLWF3YXJlIHdheS5cbiAgICB0aGlzLmpzb25TdHJpbmcgPSBTdGFjay5vZih0aGlzKS50b0pzb25TdHJpbmcocHJvcHMudmFsdWUpO1xuXG4gICAgY29uc3QgcmVzb3VyY2UgPSBuZXcgQ3VzdG9tUmVzb3VyY2UodGhpcywgJ1Jlc291cmNlJywge1xuICAgICAgc2VydmljZVRva2VuOiBDZm5VdGlsc1Byb3ZpZGVyLmdldE9yQ3JlYXRlKHRoaXMpLFxuICAgICAgcmVzb3VyY2VUeXBlOiBDZm5VdGlsc1Jlc291cmNlVHlwZS5DRk5fSlNPTixcbiAgICAgIHByb3BlcnRpZXM6IHtcbiAgICAgICAgVmFsdWU6IHRoaXMuanNvblN0cmluZyxcbiAgICAgIH0sXG4gICAgfSk7XG5cbiAgICB0aGlzLnZhbHVlID0gcmVzb3VyY2UuZ2V0QXR0KCdWYWx1ZScpO1xuICB9XG5cbiAgLyoqXG4gICAqIFRoaXMgaXMgcmVxdWlyZWQgaW4gY2FzZSBzb21lb25lIEpTT04uc3RyaW5naWZ5cyBhbiBvYmplY3Qgd2hpY2ggcmVmcmVuY2VzXG4gICAqIHRoaXMgb2JqZWN0LiBPdGhlcndpc2UsIHdlJ2xsIGdldCBhIGN5Y2xpYyBKU09OIHJlZmVyZW5jZS5cbiAgICovXG4gIHB1YmxpYyB0b0pTT04oKSB7XG4gICAgcmV0dXJuIHRoaXMuanNvblN0cmluZztcbiAgfVxuXG4gIHB1YmxpYyByZXNvbHZlKF86IElSZXNvbHZlQ29udGV4dCk6IGFueSB7XG4gICAgcmV0dXJuIHRoaXMudmFsdWU7XG4gIH1cbn1cbiJdfQ==