"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CustomResource = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cfn_resource_1 = require("./cfn-resource");
const removal_policy_1 = require("./removal-policy");
const resource_1 = require("./resource");
const token_1 = require("./token");
/**
 * Instantiation of a custom resource, whose implementation is provided a Provider
 *
 * This class is intended to be used by construct library authors. Application
 * builder should not be able to tell whether or not a construct is backed by
 * a custom resource, and so the use of this class should be invisible.
 *
 * Instead, construct library authors declare a custom construct that hides the
 * choice of provider, and accepts a strongly-typed properties object with the
 * properties your provider accepts.
 *
 * Your custom resource provider (identified by the `serviceToken` property)
 * can be one of 4 constructs:
 *
 * - If you are authoring a construct library or application, we recommend you
 *   use the `Provider` class in the `custom-resources` module.
 * - If you are authoring a construct for the CDK's AWS Construct Library,
 *   you should use the `CustomResourceProvider` construct in this package.
 * - If you want full control over the provider, you can always directly use
 *   a Lambda Function or SNS Topic by passing the ARN into `serviceToken`.
 *
 * @resource AWS::CloudFormation::CustomResource
 */
class CustomResource extends resource_1.Resource {
    constructor(scope, id, props) {
        var _b;
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_core_CustomResourceProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        const type = renderResourceType(props.resourceType);
        const pascalCaseProperties = (_b = props.pascalCaseProperties) !== null && _b !== void 0 ? _b : false;
        const properties = pascalCaseProperties ? uppercaseProperties(props.properties || {}) : (props.properties || {});
        this.resource = new cfn_resource_1.CfnResource(this, 'Default', {
            type,
            properties: {
                ServiceToken: props.serviceToken,
                ...properties,
            },
        });
        this.resource.applyRemovalPolicy(props.removalPolicy, {
            default: removal_policy_1.RemovalPolicy.DESTROY,
        });
    }
    /**
     * The physical name of this custom resource.
     */
    get ref() {
        return this.resource.ref;
    }
    /**
     * Returns the value of an attribute of the custom resource of an arbitrary
     * type. Attributes are returned from the custom resource provider through the
     * `Data` map where the key is the attribute name.
     *
     * @param attributeName the name of the attribute
     * @returns a token for `Fn::GetAtt`. Use `Token.asXxx` to encode the returned `Reference` as a specific type or
     * use the convenience `getAttString` for string attributes.
     */
    getAtt(attributeName) {
        return this.resource.getAtt(attributeName);
    }
    /**
     * Returns the value of an attribute of the custom resource of type string.
     * Attributes are returned from the custom resource provider through the
     * `Data` map where the key is the attribute name.
     *
     * @param attributeName the name of the attribute
     * @returns a token for `Fn::GetAtt` encoded as a string.
     */
    getAttString(attributeName) {
        return token_1.Token.asString(this.getAtt(attributeName));
    }
}
exports.CustomResource = CustomResource;
_a = JSII_RTTI_SYMBOL_1;
CustomResource[_a] = { fqn: "@aws-cdk/core.CustomResource", version: "1.154.0" };
/**
 * Uppercase the first letter of every property name
 *
 * It's customary for CloudFormation properties to start with capitals, and our
 * properties to start with lowercase, so this function translates from one
 * to the other
 */
function uppercaseProperties(props) {
    const ret = {};
    Object.keys(props).forEach(key => {
        const upper = key.slice(0, 1).toUpperCase() + key.slice(1);
        ret[upper] = props[key];
    });
    return ret;
}
function renderResourceType(resourceType) {
    if (!resourceType) {
        return 'AWS::CloudFormation::CustomResource';
    }
    if (!resourceType.startsWith('Custom::')) {
        throw new Error(`Custom resource type must begin with "Custom::" (${resourceType})`);
    }
    const typeName = resourceType.slice(resourceType.indexOf('::') + 2);
    if (typeName.length > 60) {
        throw new Error(`Custom resource type length > 60 (${resourceType})`);
    }
    if (!/^[a-z0-9_@-]+$/i.test(typeName)) {
        throw new Error(`Custom resource type name can only include alphanumeric characters and _@- (${typeName})`);
    }
    return resourceType;
}
//# sourceMappingURL=data:application/json;base64,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