"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnMapping = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const annotations_1 = require("./annotations");
const cfn_element_1 = require("./cfn-element");
const cfn_fn_1 = require("./cfn-fn");
const token_1 = require("./token");
/**
 * Represents a CloudFormation mapping.
 */
class CfnMapping extends cfn_element_1.CfnRefElement {
    constructor(scope, id, props = {}) {
        super(scope, id);
        this.lazyRender = false;
        this.lazyInformed = false;
        try {
            jsiiDeprecationWarnings._aws_cdk_core_CfnMappingProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        this.mapping = props.mapping ? this.validateMapping(props.mapping) : {};
        this.lazy = props.lazy;
    }
    /**
     * Sets a value in the map based on the two keys.
     */
    setValue(key1, key2, value) {
        this.validateAlphanumeric(key2);
        if (!(key1 in this.mapping)) {
            this.mapping[key1] = {};
        }
        this.mapping[key1][key2] = value;
    }
    /**
     * @returns A reference to a value in the map based on the two keys.
     */
    findInMap(key1, key2) {
        let fullyResolved = false;
        if (!token_1.Token.isUnresolved(key1)) {
            if (!(key1 in this.mapping)) {
                throw new Error(`Mapping doesn't contain top-level key '${key1}'`);
            }
            if (!token_1.Token.isUnresolved(key2)) {
                if (!(key2 in this.mapping[key1])) {
                    throw new Error(`Mapping doesn't contain second-level key '${key2}'`);
                }
                fullyResolved = true;
            }
        }
        if (fullyResolved) {
            if (this.lazy) {
                return this.mapping[key1][key2];
            }
        }
        else {
            this.lazyRender = true;
        }
        return cfn_fn_1.Fn.findInMap(this.logicalId, key1, key2);
    }
    /**
     * @internal
     */
    _toCloudFormation() {
        if (this.lazy === undefined && !this.lazyRender) {
            this.informLazyUse();
        }
        if (!this.lazy || (this.lazy && this.lazyRender)) {
            return {
                Mappings: {
                    [this.logicalId]: this.mapping,
                },
            };
        }
        else {
            return {};
        }
    }
    informLazyUse() {
        if (!this.lazyInformed) {
            annotations_1.Annotations.of(this).addInfo('Consider making this CfnMapping a lazy mapping by providing `lazy: true`: either no findInMap was called or every findInMap could be immediately resolved without using Fn::FindInMap');
        }
        this.lazyInformed = true;
    }
    validateMapping(mapping) {
        Object.keys(mapping).forEach((m) => Object.keys(mapping[m]).forEach(this.validateAlphanumeric));
        return mapping;
    }
    validateAlphanumeric(value) {
        // https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/mappings-section-structure.html
        if (value.match(/[^a-zA-Z0-9]/g)) {
            throw new Error(`Attribute name '${value}' must contain only alphanumeric characters.`);
        }
    }
}
exports.CfnMapping = CfnMapping;
_a = JSII_RTTI_SYMBOL_1;
CfnMapping[_a] = { fqn: "@aws-cdk/core.CfnMapping", version: "1.154.0" };
//# sourceMappingURL=data:application/json;base64,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