"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AssetManifestArtifact = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const cloud_artifact_1 = require("../cloud-artifact");
const ASSET_MANIFEST_ARTIFACT_SYM = Symbol.for('@aws-cdk/cx-api.AssetManifestArtifact');
/**
 * Asset manifest is a description of a set of assets which need to be built and published
 */
class AssetManifestArtifact extends cloud_artifact_1.CloudArtifact {
    constructor(assembly, name, artifact) {
        var _b;
        super(assembly, name, artifact);
        try {
            jsiiDeprecationWarnings._aws_cdk_cx_api_CloudAssembly(assembly);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        const properties = (this.manifest.properties || {});
        if (!properties.file) {
            throw new Error('Invalid AssetManifestArtifact. Missing "file" property');
        }
        this.file = path.resolve(this.assembly.directory, properties.file);
        this.requiresBootstrapStackVersion = (_b = properties.requiresBootstrapStackVersion) !== null && _b !== void 0 ? _b : 1;
        this.bootstrapStackVersionSsmParameter = properties.bootstrapStackVersionSsmParameter;
    }
    /**
     * Checks if `art` is an instance of this class.
     *
     * Use this method instead of `instanceof` to properly detect `AssetManifestArtifact`
     * instances, even when the construct library is symlinked.
     *
     * Explanation: in JavaScript, multiple copies of the `cx-api` library on
     * disk are seen as independent, completely different libraries. As a
     * consequence, the class `AssetManifestArtifact` in each copy of the `cx-api` library
     * is seen as a different class, and an instance of one class will not test as
     * `instanceof` the other class. `npm install` will not create installations
     * like this, but users may manually symlink construct libraries together or
     * use a monorepo tool: in those cases, multiple copies of the `cx-api`
     * library can be accidentally installed, and `instanceof` will behave
     * unpredictably. It is safest to avoid using `instanceof`, and using
     * this type-testing method instead.
     */
    static isAssetManifestArtifact(art) {
        return art && typeof art === 'object' && art[ASSET_MANIFEST_ARTIFACT_SYM];
    }
}
exports.AssetManifestArtifact = AssetManifestArtifact;
_a = JSII_RTTI_SYMBOL_1;
AssetManifestArtifact[_a] = { fqn: "@aws-cdk/cx-api.AssetManifestArtifact", version: "1.153.1" };
/**
 * Mark all instances of 'AssetManifestArtifact'
 *
 * Why not put this in the constructor? Because this is a class property,
 * not an instance property. It applies to all instances of the class.
 */
Object.defineProperty(AssetManifestArtifact.prototype, ASSET_MANIFEST_ARTIFACT_SYM, {
    value: true,
    enumerable: false,
    writable: false,
});
//# sourceMappingURL=data:application/json;base64,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