"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NestedStackSynthesizer = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const _shared_1 = require("./_shared");
const stack_synthesizer_1 = require("./stack-synthesizer");
/**
 * Synthesizer for a nested stack
 *
 * Forwards all calls to the parent stack's synthesizer.
 *
 * This synthesizer is automatically used for `NestedStack` constructs.
 * App builder do not need to use this class directly.
 */
class NestedStackSynthesizer extends stack_synthesizer_1.StackSynthesizer {
    constructor(parentDeployment) {
        super();
        this.parentDeployment = parentDeployment;
        try {
            jsiiDeprecationWarnings._aws_cdk_core_IStackSynthesizer(parentDeployment);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
    }
    bind(stack) {
        try {
            jsiiDeprecationWarnings._aws_cdk_core_Stack(stack);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        if (this.stack !== undefined) {
            throw new Error('A StackSynthesizer can only be used for one Stack: create a new instance to use with a different Stack');
        }
        this.stack = stack;
    }
    addFileAsset(asset) {
        try {
            jsiiDeprecationWarnings._aws_cdk_core_FileAssetSource(asset);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addFileAsset);
            }
            throw error;
        }
        // Forward to parent deployment. By the magic of cross-stack references any parameter
        // returned and used will magically be forwarded to the nested stack.
        return this.parentDeployment.addFileAsset(asset);
    }
    addDockerImageAsset(asset) {
        try {
            jsiiDeprecationWarnings._aws_cdk_core_DockerImageAssetSource(asset);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addDockerImageAsset);
            }
            throw error;
        }
        // Forward to parent deployment. By the magic of cross-stack references any parameter
        // returned and used will magically be forwarded to the nested stack.
        return this.parentDeployment.addDockerImageAsset(asset);
    }
    synthesize(session) {
        try {
            jsiiDeprecationWarnings._aws_cdk_core_ISynthesisSession(session);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.synthesize);
            }
            throw error;
        }
        _shared_1.assertBound(this.stack);
        // Synthesize the template, but don't emit as a cloud assembly artifact.
        // It will be registered as an S3 asset of its parent instead.
        this.synthesizeStackTemplate(this.stack, session);
    }
}
exports.NestedStackSynthesizer = NestedStackSynthesizer;
_a = JSII_RTTI_SYMBOL_1;
NestedStackSynthesizer[_a] = { fqn: "@aws-cdk/core.NestedStackSynthesizer", version: "1.153.1" };
//# sourceMappingURL=data:application/json;base64,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