"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CustomResource = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cfn_resource_1 = require("./cfn-resource");
const removal_policy_1 = require("./removal-policy");
const resource_1 = require("./resource");
const token_1 = require("./token");
/**
 * Instantiation of a custom resource, whose implementation is provided a Provider
 *
 * This class is intended to be used by construct library authors. Application
 * builder should not be able to tell whether or not a construct is backed by
 * a custom resource, and so the use of this class should be invisible.
 *
 * Instead, construct library authors declare a custom construct that hides the
 * choice of provider, and accepts a strongly-typed properties object with the
 * properties your provider accepts.
 *
 * Your custom resource provider (identified by the `serviceToken` property)
 * can be one of 4 constructs:
 *
 * - If you are authoring a construct library or application, we recommend you
 *   use the `Provider` class in the `custom-resources` module.
 * - If you are authoring a construct for the CDK's AWS Construct Library,
 *   you should use the `CustomResourceProvider` construct in this package.
 * - If you want full control over the provider, you can always directly use
 *   a Lambda Function or SNS Topic by passing the ARN into `serviceToken`.
 *
 * @resource AWS::CloudFormation::CustomResource
 */
class CustomResource extends resource_1.Resource {
    constructor(scope, id, props) {
        var _b;
        super(scope, id);
        jsiiDeprecationWarnings._aws_cdk_core_CustomResourceProps(props);
        const type = renderResourceType(props.resourceType);
        const pascalCaseProperties = (_b = props.pascalCaseProperties) !== null && _b !== void 0 ? _b : false;
        const properties = pascalCaseProperties ? uppercaseProperties(props.properties || {}) : (props.properties || {});
        this.resource = new cfn_resource_1.CfnResource(this, 'Default', {
            type,
            properties: {
                ServiceToken: props.serviceToken,
                ...properties,
            },
        });
        this.resource.applyRemovalPolicy(props.removalPolicy, {
            default: removal_policy_1.RemovalPolicy.DESTROY,
        });
    }
    /**
     * The physical name of this custom resource.
     */
    get ref() {
        return this.resource.ref;
    }
    /**
     * Returns the value of an attribute of the custom resource of an arbitrary
     * type. Attributes are returned from the custom resource provider through the
     * `Data` map where the key is the attribute name.
     *
     * @param attributeName the name of the attribute
     * @returns a token for `Fn::GetAtt`. Use `Token.asXxx` to encode the returned `Reference` as a specific type or
     * use the convenience `getAttString` for string attributes.
     */
    getAtt(attributeName) {
        return this.resource.getAtt(attributeName);
    }
    /**
     * Returns the value of an attribute of the custom resource of type string.
     * Attributes are returned from the custom resource provider through the
     * `Data` map where the key is the attribute name.
     *
     * @param attributeName the name of the attribute
     * @returns a token for `Fn::GetAtt` encoded as a string.
     */
    getAttString(attributeName) {
        return token_1.Token.asString(this.getAtt(attributeName));
    }
}
exports.CustomResource = CustomResource;
_a = JSII_RTTI_SYMBOL_1;
CustomResource[_a] = { fqn: "@aws-cdk/core.CustomResource", version: "1.152.0" };
/**
 * Uppercase the first letter of every property name
 *
 * It's customary for CloudFormation properties to start with capitals, and our
 * properties to start with lowercase, so this function translates from one
 * to the other
 */
function uppercaseProperties(props) {
    const ret = {};
    Object.keys(props).forEach(key => {
        const upper = key.slice(0, 1).toUpperCase() + key.slice(1);
        ret[upper] = props[key];
    });
    return ret;
}
function renderResourceType(resourceType) {
    if (!resourceType) {
        return 'AWS::CloudFormation::CustomResource';
    }
    if (!resourceType.startsWith('Custom::')) {
        throw new Error(`Custom resource type must begin with "Custom::" (${resourceType})`);
    }
    const typeName = resourceType.slice(resourceType.indexOf('::') + 2);
    if (typeName.length > 60) {
        throw new Error(`Custom resource type length > 60 (${resourceType})`);
    }
    if (!/^[a-z0-9_@-]+$/i.test(typeName)) {
        throw new Error(`Custom resource type name can only include alphanumeric characters and _@- (${typeName})`);
    }
    return resourceType;
}
//# sourceMappingURL=data:application/json;base64,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