"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const ec2 = require("@aws-cdk/aws-ec2");
const cdk = require("@aws-cdk/core");
const index_1 = require("./index");
const super_ec2_interfaces_1 = require("./super-ec2-interfaces");
const env = {
    region: process.env.CDK_DEFAULT_REGION,
    account: process.env.CDK_DEFAULT_ACCOUNT,
};
const app = new cdk.App();
const stack = new cdk.Stack(app, 'super-ec2-demo', { env });
const jks = new index_1.JenkinsEC2(stack, 'jenkins-ec2', {
    vpc: ec2.Vpc.fromLookup(stack, 'defVpc', { isDefault: true }),
    instanceType: new ec2.InstanceType('t3.large'),
    loadbalancerType: super_ec2_interfaces_1.ELBtype.ALB,
});
new cdk.CfnOutput(stack, 'loadbalancerDNS', {
    value: jks.loadbalancer.loadBalancerDnsName,
});
new cdk.CfnOutput(stack, 'instanceID', {
    value: jks.instance.instanceId,
});
app.synth();
//# sourceMappingURL=data:application/json;base64,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