"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Lazy = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const debug_1 = require("./debug");
const stack_trace_1 = require("./stack-trace");
const token_1 = require("./token");
/**
 * Lazily produce a value
 *
 * Can be used to return a string, list or numeric value whose actual value
 * will only be calculated later, during synthesis.
 */
class Lazy {
    constructor() {
    }
    /**
     * Defer the calculation of a string value to synthesis time
     *
     * Use this if you want to render a string to a template whose actual value depends on
     * some state mutation that may happen after the construct has been created.
     *
     * If you are simply looking to force a value to a `string` type and don't need
     * the calculation to be deferred, use `Token.asString()` instead.
     *
     * @deprecated Use `Lazy.string()` or `Lazy.uncachedString()` instead.
     */
    static stringValue(producer, options = {}) {
        jsiiDeprecationWarnings.print("@aws-cdk/core.Lazy#stringValue", "Use `Lazy.string()` or `Lazy.uncachedString()` instead.");
        jsiiDeprecationWarnings._aws_cdk_core_IStringProducer(producer);
        jsiiDeprecationWarnings._aws_cdk_core_LazyStringValueOptions(options);
        return token_1.Token.asString(new LazyString(producer, false), options);
    }
    /**
     * Defer the one-time calculation of a string value to synthesis time
     *
     * Use this if you want to render a string to a template whose actual value depends on
     * some state mutation that may happen after the construct has been created.
     *
     * If you are simply looking to force a value to a `string` type and don't need
     * the calculation to be deferred, use `Token.asString()` instead.
     *
     * The inner function will only be invoked once, and the resolved value
     * cannot depend on the Stack the Token is used in.
     */
    static string(producer, options = {}) {
        jsiiDeprecationWarnings._aws_cdk_core_IStableStringProducer(producer);
        jsiiDeprecationWarnings._aws_cdk_core_LazyStringValueOptions(options);
        return token_1.Token.asString(new LazyString(producer, true), options);
    }
    /**
     * Defer the calculation of a string value to synthesis time
     *
     * Use of this function is not recommended; unless you know you need it for sure, you
     * probably don't. Use `Lazy.string()` instead.
     *
     * The inner function may be invoked multiple times during synthesis. You
     * should only use this method if the returned value depends on variables
     * that may change during the Aspect application phase of synthesis, or if
     * the value depends on the Stack the value is being used in. Both of these
     * cases are rare, and only ever occur for AWS Construct Library authors.
     */
    static uncachedString(producer, options = {}) {
        jsiiDeprecationWarnings._aws_cdk_core_IStringProducer(producer);
        jsiiDeprecationWarnings._aws_cdk_core_LazyStringValueOptions(options);
        return token_1.Token.asString(new LazyString(producer, false), options);
    }
    /**
     * Defer the one-time calculation of a number value to synthesis time
     *
     * Use this if you want to render a number to a template whose actual value depends on
     * some state mutation that may happen after the construct has been created.
     *
     * If you are simply looking to force a value to a `number` type and don't need
     * the calculation to be deferred, use `Token.asNumber()` instead.
     *
     * @deprecated Use `Lazy.number()` or `Lazy.uncachedNumber()` instead.
     */
    static numberValue(producer) {
        jsiiDeprecationWarnings.print("@aws-cdk/core.Lazy#numberValue", "Use `Lazy.number()` or `Lazy.uncachedNumber()` instead.");
        jsiiDeprecationWarnings._aws_cdk_core_INumberProducer(producer);
        return token_1.Token.asNumber(new LazyNumber(producer, false));
    }
    /**
     * Defer the one-time calculation of a number value to synthesis time
     *
     * Use this if you want to render a number to a template whose actual value depends on
     * some state mutation that may happen after the construct has been created.
     *
     * If you are simply looking to force a value to a `number` type and don't need
     * the calculation to be deferred, use `Token.asNumber()` instead.
     *
     * The inner function will only be invoked once, and the resolved value
     * cannot depend on the Stack the Token is used in.
     */
    static number(producer) {
        jsiiDeprecationWarnings._aws_cdk_core_IStableNumberProducer(producer);
        return token_1.Token.asNumber(new LazyNumber(producer, true));
    }
    /**
     * Defer the calculation of a number value to synthesis time
     *
     * Use of this function is not recommended; unless you know you need it for sure, you
     * probably don't. Use `Lazy.number()` instead.
     *
     * The inner function may be invoked multiple times during synthesis. You
     * should only use this method if the returned value depends on variables
     * that may change during the Aspect application phase of synthesis, or if
     * the value depends on the Stack the value is being used in. Both of these
     * cases are rare, and only ever occur for AWS Construct Library authors.
     */
    static uncachedNumber(producer) {
        jsiiDeprecationWarnings._aws_cdk_core_INumberProducer(producer);
        return token_1.Token.asNumber(new LazyNumber(producer, false));
    }
    /**
     * Defer the one-time calculation of a list value to synthesis time
     *
     * Use this if you want to render a list to a template whose actual value depends on
     * some state mutation that may happen after the construct has been created.
     *
     * If you are simply looking to force a value to a `string[]` type and don't need
     * the calculation to be deferred, use `Token.asList()` instead.
     *
     * @deprecated Use `Lazy.list()` or `Lazy.uncachedList()` instead.
     */
    static listValue(producer, options = {}) {
        jsiiDeprecationWarnings.print("@aws-cdk/core.Lazy#listValue", "Use `Lazy.list()` or `Lazy.uncachedList()` instead.");
        jsiiDeprecationWarnings._aws_cdk_core_IListProducer(producer);
        jsiiDeprecationWarnings._aws_cdk_core_LazyListValueOptions(options);
        return token_1.Token.asList(new LazyList(producer, false, options), options);
    }
    /**
     * Defer the calculation of a list value to synthesis time
     *
     * Use of this function is not recommended; unless you know you need it for sure, you
     * probably don't. Use `Lazy.list()` instead.
     *
     * The inner function may be invoked multiple times during synthesis. You
     * should only use this method if the returned value depends on variables
     * that may change during the Aspect application phase of synthesis, or if
     * the value depends on the Stack the value is being used in. Both of these
     * cases are rare, and only ever occur for AWS Construct Library authors.
     */
    static uncachedList(producer, options = {}) {
        jsiiDeprecationWarnings._aws_cdk_core_IListProducer(producer);
        jsiiDeprecationWarnings._aws_cdk_core_LazyListValueOptions(options);
        return token_1.Token.asList(new LazyList(producer, false, options), options);
    }
    /**
     * Defer the one-time calculation of a list value to synthesis time
     *
     * Use this if you want to render a list to a template whose actual value depends on
     * some state mutation that may happen after the construct has been created.
     *
     * If you are simply looking to force a value to a `string[]` type and don't need
     * the calculation to be deferred, use `Token.asList()` instead.
     *
     * The inner function will only be invoked once, and the resolved value
     * cannot depend on the Stack the Token is used in.
     */
    static list(producer, options = {}) {
        jsiiDeprecationWarnings._aws_cdk_core_IStableListProducer(producer);
        jsiiDeprecationWarnings._aws_cdk_core_LazyListValueOptions(options);
        return token_1.Token.asList(new LazyList(producer, true, options), options);
    }
    /**
     * Defer the one-time calculation of an arbitrarily typed value to synthesis time
     *
     * Use this if you want to render an object to a template whose actual value depends on
     * some state mutation that may happen after the construct has been created.
     *
     * @deprecated Use `Lazy.any()` or `Lazy.uncachedAny()` instead.
     */
    static anyValue(producer, options = {}) {
        jsiiDeprecationWarnings.print("@aws-cdk/core.Lazy#anyValue", "Use `Lazy.any()` or `Lazy.uncachedAny()` instead.");
        jsiiDeprecationWarnings._aws_cdk_core_IAnyProducer(producer);
        jsiiDeprecationWarnings._aws_cdk_core_LazyAnyValueOptions(options);
        return new LazyAny(producer, false, options);
    }
    /**
     * Defer the one-time calculation of an arbitrarily typed value to synthesis time
     *
     * Use this if you want to render an object to a template whose actual value depends on
     * some state mutation that may happen after the construct has been created.
     *
     * The inner function will only be invoked one time and cannot depend on
     * resolution context.
     */
    static any(producer, options = {}) {
        jsiiDeprecationWarnings._aws_cdk_core_IStableAnyProducer(producer);
        jsiiDeprecationWarnings._aws_cdk_core_LazyAnyValueOptions(options);
        return new LazyAny(producer, true, options);
    }
    /**
     * Defer the calculation of an untyped value to synthesis time
     *
     * Use of this function is not recommended; unless you know you need it for sure, you
     * probably don't. Use `Lazy.any()` instead.
     *
     * The inner function may be invoked multiple times during synthesis. You
     * should only use this method if the returned value depends on variables
     * that may change during the Aspect application phase of synthesis, or if
     * the value depends on the Stack the value is being used in. Both of these
     * cases are rare, and only ever occur for AWS Construct Library authors.
     */
    static uncachedAny(producer, options = {}) {
        jsiiDeprecationWarnings._aws_cdk_core_IAnyProducer(producer);
        jsiiDeprecationWarnings._aws_cdk_core_LazyAnyValueOptions(options);
        return new LazyAny(producer, false, options);
    }
}
exports.Lazy = Lazy;
_a = JSII_RTTI_SYMBOL_1;
Lazy[_a] = { fqn: "@aws-cdk/core.Lazy", version: "1.152.0" };
class LazyBase {
    constructor(producer, cache) {
        this.producer = producer;
        this.cache = cache;
        // Stack trace capture is conditionned to `debugModeEnabled()`, because
        // lazies can be created in a fairly thrashy way, and the stack traces are
        // large and slow to obtain; but are mostly useful only when debugging a
        // resolution issue.
        this.creationStack = debug_1.debugModeEnabled()
            ? stack_trace_1.captureStackTrace(this.constructor)
            : [`Execute again with ${debug_1.CDK_DEBUG}=true to capture stack traces`];
    }
    resolve(context) {
        var _b;
        if (this.cache) {
            return (_b = this._cached) !== null && _b !== void 0 ? _b : (this._cached = this.producer.produce(context));
        }
        else {
            return this.producer.produce(context);
        }
    }
    toString() {
        return token_1.Token.asString(this);
    }
    /**
     * Turn this Token into JSON
     *
     * Called automatically when JSON.stringify() is called on a Token.
     */
    toJSON() {
        return '<unresolved-lazy>';
    }
}
class LazyString extends LazyBase {
}
class LazyNumber extends LazyBase {
}
class LazyList extends LazyBase {
    constructor(producer, cache, options = {}) {
        super(producer, cache);
        this.options = options;
    }
    resolve(context) {
        const resolved = super.resolve(context);
        if ((resolved === null || resolved === void 0 ? void 0 : resolved.length) === 0 && this.options.omitEmpty) {
            return undefined;
        }
        return resolved;
    }
}
class LazyAny extends LazyBase {
    constructor(producer, cache, options = {}) {
        super(producer, cache);
        this.options = options;
    }
    resolve(context) {
        const resolved = super.resolve(context);
        if (Array.isArray(resolved) && resolved.length === 0 && this.options.omitEmptyArray) {
            return undefined;
        }
        return resolved;
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibGF6eS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImxhenkudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBQUEsbUNBQXNEO0FBRXRELCtDQUFrRDtBQUNsRCxtQ0FBZ0M7QUFvSWhDOzs7OztHQUtHO0FBQ0gsTUFBYSxJQUFJO0lBdUxmO0tBQ0M7SUF2TEQ7Ozs7Ozs7Ozs7T0FVRztJQUNJLE1BQU0sQ0FBQyxXQUFXLENBQUMsUUFBeUIsRUFBRSxVQUFrQyxFQUFFOzs7O1FBQ3ZGLE9BQU8sYUFBSyxDQUFDLFFBQVEsQ0FBQyxJQUFJLFVBQVUsQ0FBQyxRQUFRLEVBQUUsS0FBSyxDQUFDLEVBQUUsT0FBTyxDQUFDLENBQUM7S0FDakU7SUFFRDs7Ozs7Ozs7Ozs7T0FXRztJQUNJLE1BQU0sQ0FBQyxNQUFNLENBQUMsUUFBK0IsRUFBRSxVQUFrQyxFQUFFOzs7UUFDeEYsT0FBTyxhQUFLLENBQUMsUUFBUSxDQUFDLElBQUksVUFBVSxDQUFDLFFBQVEsRUFBRSxJQUFJLENBQUMsRUFBRSxPQUFPLENBQUMsQ0FBQztLQUNoRTtJQUVEOzs7Ozs7Ozs7OztPQVdHO0lBQ0ksTUFBTSxDQUFDLGNBQWMsQ0FBQyxRQUF5QixFQUFFLFVBQWtDLEVBQUU7OztRQUMxRixPQUFPLGFBQUssQ0FBQyxRQUFRLENBQUMsSUFBSSxVQUFVLENBQUMsUUFBUSxFQUFFLEtBQUssQ0FBQyxFQUFFLE9BQU8sQ0FBQyxDQUFDO0tBQ2pFO0lBRUQ7Ozs7Ozs7Ozs7T0FVRztJQUNJLE1BQU0sQ0FBQyxXQUFXLENBQUMsUUFBeUI7OztRQUNqRCxPQUFPLGFBQUssQ0FBQyxRQUFRLENBQUMsSUFBSSxVQUFVLENBQUMsUUFBUSxFQUFFLEtBQUssQ0FBQyxDQUFDLENBQUM7S0FDeEQ7SUFFRDs7Ozs7Ozs7Ozs7T0FXRztJQUNJLE1BQU0sQ0FBQyxNQUFNLENBQUMsUUFBK0I7O1FBQ2xELE9BQU8sYUFBSyxDQUFDLFFBQVEsQ0FBQyxJQUFJLFVBQVUsQ0FBQyxRQUFRLEVBQUUsSUFBSSxDQUFDLENBQUMsQ0FBQztLQUN2RDtJQUVEOzs7Ozs7Ozs7OztPQVdHO0lBQ0ksTUFBTSxDQUFDLGNBQWMsQ0FBQyxRQUF5Qjs7UUFDcEQsT0FBTyxhQUFLLENBQUMsUUFBUSxDQUFDLElBQUksVUFBVSxDQUFDLFFBQVEsRUFBRSxLQUFLLENBQUMsQ0FBQyxDQUFDO0tBQ3hEO0lBRUQ7Ozs7Ozs7Ozs7T0FVRztJQUNJLE1BQU0sQ0FBQyxTQUFTLENBQUMsUUFBdUIsRUFBRSxVQUFnQyxFQUFFOzs7O1FBQ2pGLE9BQU8sYUFBSyxDQUFDLE1BQU0sQ0FBQyxJQUFJLFFBQVEsQ0FBQyxRQUFRLEVBQUUsS0FBSyxFQUFFLE9BQU8sQ0FBQyxFQUFFLE9BQU8sQ0FBQyxDQUFDO0tBQ3RFO0lBRUQ7Ozs7Ozs7Ozs7O09BV0c7SUFDSSxNQUFNLENBQUMsWUFBWSxDQUFDLFFBQXVCLEVBQUUsVUFBZ0MsRUFBRTs7O1FBQ3BGLE9BQU8sYUFBSyxDQUFDLE1BQU0sQ0FBQyxJQUFJLFFBQVEsQ0FBQyxRQUFRLEVBQUUsS0FBSyxFQUFFLE9BQU8sQ0FBQyxFQUFFLE9BQU8sQ0FBQyxDQUFDO0tBQ3RFO0lBRUQ7Ozs7Ozs7Ozs7O09BV0c7SUFDSSxNQUFNLENBQUMsSUFBSSxDQUFDLFFBQTZCLEVBQUUsVUFBZ0MsRUFBRTs7O1FBQ2xGLE9BQU8sYUFBSyxDQUFDLE1BQU0sQ0FBQyxJQUFJLFFBQVEsQ0FBQyxRQUFRLEVBQUUsSUFBSSxFQUFFLE9BQU8sQ0FBQyxFQUFFLE9BQU8sQ0FBQyxDQUFDO0tBQ3JFO0lBRUQ7Ozs7Ozs7T0FPRztJQUNJLE1BQU0sQ0FBQyxRQUFRLENBQUMsUUFBc0IsRUFBRSxVQUErQixFQUFFOzs7O1FBQzlFLE9BQU8sSUFBSSxPQUFPLENBQUMsUUFBUSxFQUFFLEtBQUssRUFBRSxPQUFPLENBQUMsQ0FBQztLQUM5QztJQUVEOzs7Ozs7OztPQVFHO0lBQ0ksTUFBTSxDQUFDLEdBQUcsQ0FBQyxRQUE0QixFQUFFLFVBQStCLEVBQUU7OztRQUMvRSxPQUFPLElBQUksT0FBTyxDQUFDLFFBQVEsRUFBRSxJQUFJLEVBQUUsT0FBTyxDQUFDLENBQUM7S0FDN0M7SUFFRDs7Ozs7Ozs7Ozs7T0FXRztJQUNJLE1BQU0sQ0FBQyxXQUFXLENBQUMsUUFBc0IsRUFBRSxVQUErQixFQUFFOzs7UUFDakYsT0FBTyxJQUFJLE9BQU8sQ0FBQyxRQUFRLEVBQUUsS0FBSyxFQUFFLE9BQU8sQ0FBQyxDQUFDO0tBQzlDOztBQXJMSCxvQkF5TEM7OztBQU9ELE1BQWUsUUFBUTtJQUlyQixZQUE2QixRQUEwQixFQUFtQixLQUFjO1FBQTNELGFBQVEsR0FBUixRQUFRLENBQWtCO1FBQW1CLFVBQUssR0FBTCxLQUFLLENBQVM7UUFDdEYsdUVBQXVFO1FBQ3ZFLDBFQUEwRTtRQUMxRSx3RUFBd0U7UUFDeEUsb0JBQW9CO1FBQ3BCLElBQUksQ0FBQyxhQUFhLEdBQUcsd0JBQWdCLEVBQUU7WUFDckMsQ0FBQyxDQUFDLCtCQUFpQixDQUFDLElBQUksQ0FBQyxXQUFXLENBQUM7WUFDckMsQ0FBQyxDQUFDLENBQUMsc0JBQXNCLGlCQUFTLCtCQUErQixDQUFDLENBQUM7S0FDdEU7SUFFTSxPQUFPLENBQUMsT0FBd0I7O1FBQ3JDLElBQUksSUFBSSxDQUFDLEtBQUssRUFBRTtZQUNkLGFBQU8sSUFBSSxDQUFDLE9BQU8sbUNBQUksQ0FBQyxJQUFJLENBQUMsT0FBTyxHQUFHLElBQUksQ0FBQyxRQUFRLENBQUMsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUM7U0FDeEU7YUFBTTtZQUNMLE9BQU8sSUFBSSxDQUFDLFFBQVEsQ0FBQyxPQUFPLENBQUMsT0FBTyxDQUFDLENBQUM7U0FDdkM7S0FDRjtJQUVNLFFBQVE7UUFDYixPQUFPLGFBQUssQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLENBQUM7S0FDN0I7SUFFRDs7OztPQUlHO0lBQ0ksTUFBTTtRQUNYLE9BQU8sbUJBQW1CLENBQUM7S0FDNUI7Q0FFRjtBQUVELE1BQU0sVUFBVyxTQUFRLFFBQWdCO0NBQ3hDO0FBRUQsTUFBTSxVQUFXLFNBQVEsUUFBZ0I7Q0FDeEM7QUFFRCxNQUFNLFFBQVMsU0FBUSxRQUF1QjtJQUM1QyxZQUFZLFFBQXVCLEVBQUUsS0FBYyxFQUFtQixVQUFnQyxFQUFFO1FBQ3RHLEtBQUssQ0FBQyxRQUFRLEVBQUUsS0FBSyxDQUFDLENBQUM7UUFENkMsWUFBTyxHQUFQLE9BQU8sQ0FBMkI7S0FFdkc7SUFFTSxPQUFPLENBQUMsT0FBd0I7UUFDckMsTUFBTSxRQUFRLEdBQUcsS0FBSyxDQUFDLE9BQU8sQ0FBQyxPQUFPLENBQUMsQ0FBQztRQUN4QyxJQUFJLENBQUEsUUFBUSxhQUFSLFFBQVEsdUJBQVIsUUFBUSxDQUFFLE1BQU0sTUFBSyxDQUFDLElBQUksSUFBSSxDQUFDLE9BQU8sQ0FBQyxTQUFTLEVBQUU7WUFDcEQsT0FBTyxTQUFTLENBQUM7U0FDbEI7UUFDRCxPQUFPLFFBQVEsQ0FBQztLQUNqQjtDQUNGO0FBRUQsTUFBTSxPQUFRLFNBQVEsUUFBYTtJQUNqQyxZQUFZLFFBQXNCLEVBQUUsS0FBYyxFQUFtQixVQUErQixFQUFFO1FBQ3BHLEtBQUssQ0FBQyxRQUFRLEVBQUUsS0FBSyxDQUFDLENBQUM7UUFENEMsWUFBTyxHQUFQLE9BQU8sQ0FBMEI7S0FFckc7SUFFTSxPQUFPLENBQUMsT0FBd0I7UUFDckMsTUFBTSxRQUFRLEdBQUcsS0FBSyxDQUFDLE9BQU8sQ0FBQyxPQUFPLENBQUMsQ0FBQztRQUN4QyxJQUFJLEtBQUssQ0FBQyxPQUFPLENBQUMsUUFBUSxDQUFDLElBQUksUUFBUSxDQUFDLE1BQU0sS0FBSyxDQUFDLElBQUksSUFBSSxDQUFDLE9BQU8sQ0FBQyxjQUFjLEVBQUU7WUFDbkYsT0FBTyxTQUFTLENBQUM7U0FDbEI7UUFDRCxPQUFPLFFBQVEsQ0FBQztLQUNqQjtDQUNGIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQ0RLX0RFQlVHLCBkZWJ1Z01vZGVFbmFibGVkIH0gZnJvbSAnLi9kZWJ1Zyc7XG5pbXBvcnQgeyBJUmVzb2x2YWJsZSwgSVJlc29sdmVDb250ZXh0IH0gZnJvbSAnLi9yZXNvbHZhYmxlJztcbmltcG9ydCB7IGNhcHR1cmVTdGFja1RyYWNlIH0gZnJvbSAnLi9zdGFjay10cmFjZSc7XG5pbXBvcnQgeyBUb2tlbiB9IGZyb20gJy4vdG9rZW4nO1xuXG4vKipcbiAqIEludGVyZmFjZSBmb3IgbGF6eSBzdHJpbmcgcHJvZHVjZXJzXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgSVN0cmluZ1Byb2R1Y2VyIHtcbiAgLyoqXG4gICAqIFByb2R1Y2UgdGhlIHN0cmluZyB2YWx1ZVxuICAgKi9cbiAgcHJvZHVjZShjb250ZXh0OiBJUmVzb2x2ZUNvbnRleHQpOiBzdHJpbmcgfCB1bmRlZmluZWQ7XG59XG5cbi8qKlxuICogSW50ZXJmYWNlIGZvciAoc3RhYmxlKSBsYXp5IHN0cmluZyBwcm9kdWNlcnNcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBJU3RhYmxlU3RyaW5nUHJvZHVjZXIge1xuICAvKipcbiAgICogUHJvZHVjZSB0aGUgc3RyaW5nIHZhbHVlXG4gICAqL1xuICBwcm9kdWNlKCk6IHN0cmluZyB8IHVuZGVmaW5lZDtcbn1cblxuLyoqXG4gKiBJbnRlcmZhY2UgZm9yIGxhenkgbGlzdCBwcm9kdWNlcnNcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBJTGlzdFByb2R1Y2VyIHtcbiAgLyoqXG4gICAqIFByb2R1Y2UgdGhlIGxpc3QgdmFsdWVcbiAgICovXG4gIHByb2R1Y2UoY29udGV4dDogSVJlc29sdmVDb250ZXh0KTogc3RyaW5nW10gfCB1bmRlZmluZWQ7XG59XG5cbi8qKlxuICogSW50ZXJmYWNlIGZvciAoc3RhYmxlKSBsYXp5IGxpc3QgcHJvZHVjZXJzXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgSVN0YWJsZUxpc3RQcm9kdWNlciB7XG4gIC8qKlxuICAgKiBQcm9kdWNlIHRoZSBsaXN0IHZhbHVlXG4gICAqL1xuICBwcm9kdWNlKCk6IHN0cmluZ1tdIHwgdW5kZWZpbmVkO1xufVxuXG4vKipcbiAqIEludGVyZmFjZSBmb3IgbGF6eSBudW1iZXIgcHJvZHVjZXJzXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgSU51bWJlclByb2R1Y2VyIHtcbiAgLyoqXG4gICAqIFByb2R1Y2UgdGhlIG51bWJlciB2YWx1ZVxuICAgKi9cbiAgcHJvZHVjZShjb250ZXh0OiBJUmVzb2x2ZUNvbnRleHQpOiBudW1iZXIgfCB1bmRlZmluZWQ7XG59XG5cbi8qKlxuICogSW50ZXJmYWNlIGZvciAoc3RhYmxlKSBsYXp5IG51bWJlciBwcm9kdWNlcnNcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBJU3RhYmxlTnVtYmVyUHJvZHVjZXIge1xuICAvKipcbiAgICogUHJvZHVjZSB0aGUgbnVtYmVyIHZhbHVlXG4gICAqL1xuICBwcm9kdWNlKCk6IG51bWJlciB8IHVuZGVmaW5lZDtcbn1cblxuLyoqXG4gKiBJbnRlcmZhY2UgZm9yIGxhenkgdW50eXBlZCB2YWx1ZSBwcm9kdWNlcnNcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBJQW55UHJvZHVjZXIge1xuICAvKipcbiAgICogUHJvZHVjZSB0aGUgdmFsdWVcbiAgICovXG4gIHByb2R1Y2UoY29udGV4dDogSVJlc29sdmVDb250ZXh0KTogYW55O1xufVxuXG4vKipcbiAqIEludGVyZmFjZSBmb3IgKHN0YWJsZSkgbGF6eSB1bnR5cGVkIHZhbHVlIHByb2R1Y2Vyc1xuICovXG5leHBvcnQgaW50ZXJmYWNlIElTdGFibGVBbnlQcm9kdWNlciB7XG4gIC8qKlxuICAgKiBQcm9kdWNlIHRoZSB2YWx1ZVxuICAgKi9cbiAgcHJvZHVjZSgpOiBhbnk7XG59XG5cbi8qKlxuICogT3B0aW9ucyBmb3IgY3JlYXRpbmcgYSBsYXp5IHN0cmluZyB0b2tlblxuICovXG5leHBvcnQgaW50ZXJmYWNlIExhenlTdHJpbmdWYWx1ZU9wdGlvbnMge1xuICAvKipcbiAgICogVXNlIHRoZSBnaXZlbiBuYW1lIGFzIGEgZGlzcGxheSBoaW50XG4gICAqXG4gICAqIEBkZWZhdWx0IC0gTm8gaGludFxuICAgKi9cbiAgcmVhZG9ubHkgZGlzcGxheUhpbnQ/OiBzdHJpbmc7XG59XG5cbi8qKlxuICogT3B0aW9ucyBmb3IgY3JlYXRpbmcgYSBsYXp5IGxpc3QgdG9rZW5cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBMYXp5TGlzdFZhbHVlT3B0aW9ucyB7XG4gIC8qKlxuICAgKiBVc2UgdGhlIGdpdmVuIG5hbWUgYXMgYSBkaXNwbGF5IGhpbnRcbiAgICpcbiAgICogQGRlZmF1bHQgLSBObyBoaW50XG4gICAqL1xuICByZWFkb25seSBkaXNwbGF5SGludD86IHN0cmluZztcblxuICAvKipcbiAgICogSWYgdGhlIHByb2R1Y2VkIGxpc3QgaXMgZW1wdHksIHJldHVybiAndW5kZWZpbmVkJyBpbnN0ZWFkXG4gICAqXG4gICAqIEBkZWZhdWx0IGZhbHNlXG4gICAqL1xuICByZWFkb25seSBvbWl0RW1wdHk/OiBib29sZWFuO1xufVxuXG4vKipcbiAqIE9wdGlvbnMgZm9yIGNyZWF0aW5nIGxhenkgdW50eXBlZCB0b2tlbnNcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBMYXp5QW55VmFsdWVPcHRpb25zIHtcbiAgLyoqXG4gICAqIFVzZSB0aGUgZ2l2ZW4gbmFtZSBhcyBhIGRpc3BsYXkgaGludFxuICAgKlxuICAgKiBAZGVmYXVsdCAtIE5vIGhpbnRcbiAgICovXG4gIHJlYWRvbmx5IGRpc3BsYXlIaW50Pzogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBJZiB0aGUgcHJvZHVjZWQgdmFsdWUgaXMgYW4gYXJyYXkgYW5kIGl0IGlzIGVtcHR5LCByZXR1cm4gJ3VuZGVmaW5lZCcgaW5zdGVhZFxuICAgKlxuICAgKiBAZGVmYXVsdCBmYWxzZVxuICAgKi9cbiAgcmVhZG9ubHkgb21pdEVtcHR5QXJyYXk/OiBib29sZWFuO1xufVxuXG4vKipcbiAqIExhemlseSBwcm9kdWNlIGEgdmFsdWVcbiAqXG4gKiBDYW4gYmUgdXNlZCB0byByZXR1cm4gYSBzdHJpbmcsIGxpc3Qgb3IgbnVtZXJpYyB2YWx1ZSB3aG9zZSBhY3R1YWwgdmFsdWVcbiAqIHdpbGwgb25seSBiZSBjYWxjdWxhdGVkIGxhdGVyLCBkdXJpbmcgc3ludGhlc2lzLlxuICovXG5leHBvcnQgY2xhc3MgTGF6eSB7XG4gIC8qKlxuICAgKiBEZWZlciB0aGUgY2FsY3VsYXRpb24gb2YgYSBzdHJpbmcgdmFsdWUgdG8gc3ludGhlc2lzIHRpbWVcbiAgICpcbiAgICogVXNlIHRoaXMgaWYgeW91IHdhbnQgdG8gcmVuZGVyIGEgc3RyaW5nIHRvIGEgdGVtcGxhdGUgd2hvc2UgYWN0dWFsIHZhbHVlIGRlcGVuZHMgb25cbiAgICogc29tZSBzdGF0ZSBtdXRhdGlvbiB0aGF0IG1heSBoYXBwZW4gYWZ0ZXIgdGhlIGNvbnN0cnVjdCBoYXMgYmVlbiBjcmVhdGVkLlxuICAgKlxuICAgKiBJZiB5b3UgYXJlIHNpbXBseSBsb29raW5nIHRvIGZvcmNlIGEgdmFsdWUgdG8gYSBgc3RyaW5nYCB0eXBlIGFuZCBkb24ndCBuZWVkXG4gICAqIHRoZSBjYWxjdWxhdGlvbiB0byBiZSBkZWZlcnJlZCwgdXNlIGBUb2tlbi5hc1N0cmluZygpYCBpbnN0ZWFkLlxuICAgKlxuICAgKiBAZGVwcmVjYXRlZCBVc2UgYExhenkuc3RyaW5nKClgIG9yIGBMYXp5LnVuY2FjaGVkU3RyaW5nKClgIGluc3RlYWQuXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIHN0cmluZ1ZhbHVlKHByb2R1Y2VyOiBJU3RyaW5nUHJvZHVjZXIsIG9wdGlvbnM6IExhenlTdHJpbmdWYWx1ZU9wdGlvbnMgPSB7fSkge1xuICAgIHJldHVybiBUb2tlbi5hc1N0cmluZyhuZXcgTGF6eVN0cmluZyhwcm9kdWNlciwgZmFsc2UpLCBvcHRpb25zKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBEZWZlciB0aGUgb25lLXRpbWUgY2FsY3VsYXRpb24gb2YgYSBzdHJpbmcgdmFsdWUgdG8gc3ludGhlc2lzIHRpbWVcbiAgICpcbiAgICogVXNlIHRoaXMgaWYgeW91IHdhbnQgdG8gcmVuZGVyIGEgc3RyaW5nIHRvIGEgdGVtcGxhdGUgd2hvc2UgYWN0dWFsIHZhbHVlIGRlcGVuZHMgb25cbiAgICogc29tZSBzdGF0ZSBtdXRhdGlvbiB0aGF0IG1heSBoYXBwZW4gYWZ0ZXIgdGhlIGNvbnN0cnVjdCBoYXMgYmVlbiBjcmVhdGVkLlxuICAgKlxuICAgKiBJZiB5b3UgYXJlIHNpbXBseSBsb29raW5nIHRvIGZvcmNlIGEgdmFsdWUgdG8gYSBgc3RyaW5nYCB0eXBlIGFuZCBkb24ndCBuZWVkXG4gICAqIHRoZSBjYWxjdWxhdGlvbiB0byBiZSBkZWZlcnJlZCwgdXNlIGBUb2tlbi5hc1N0cmluZygpYCBpbnN0ZWFkLlxuICAgKlxuICAgKiBUaGUgaW5uZXIgZnVuY3Rpb24gd2lsbCBvbmx5IGJlIGludm9rZWQgb25jZSwgYW5kIHRoZSByZXNvbHZlZCB2YWx1ZVxuICAgKiBjYW5ub3QgZGVwZW5kIG9uIHRoZSBTdGFjayB0aGUgVG9rZW4gaXMgdXNlZCBpbi5cbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgc3RyaW5nKHByb2R1Y2VyOiBJU3RhYmxlU3RyaW5nUHJvZHVjZXIsIG9wdGlvbnM6IExhenlTdHJpbmdWYWx1ZU9wdGlvbnMgPSB7fSkge1xuICAgIHJldHVybiBUb2tlbi5hc1N0cmluZyhuZXcgTGF6eVN0cmluZyhwcm9kdWNlciwgdHJ1ZSksIG9wdGlvbnMpO1xuICB9XG5cbiAgLyoqXG4gICAqIERlZmVyIHRoZSBjYWxjdWxhdGlvbiBvZiBhIHN0cmluZyB2YWx1ZSB0byBzeW50aGVzaXMgdGltZVxuICAgKlxuICAgKiBVc2Ugb2YgdGhpcyBmdW5jdGlvbiBpcyBub3QgcmVjb21tZW5kZWQ7IHVubGVzcyB5b3Uga25vdyB5b3UgbmVlZCBpdCBmb3Igc3VyZSwgeW91XG4gICAqIHByb2JhYmx5IGRvbid0LiBVc2UgYExhenkuc3RyaW5nKClgIGluc3RlYWQuXG4gICAqXG4gICAqIFRoZSBpbm5lciBmdW5jdGlvbiBtYXkgYmUgaW52b2tlZCBtdWx0aXBsZSB0aW1lcyBkdXJpbmcgc3ludGhlc2lzLiBZb3VcbiAgICogc2hvdWxkIG9ubHkgdXNlIHRoaXMgbWV0aG9kIGlmIHRoZSByZXR1cm5lZCB2YWx1ZSBkZXBlbmRzIG9uIHZhcmlhYmxlc1xuICAgKiB0aGF0IG1heSBjaGFuZ2UgZHVyaW5nIHRoZSBBc3BlY3QgYXBwbGljYXRpb24gcGhhc2Ugb2Ygc3ludGhlc2lzLCBvciBpZlxuICAgKiB0aGUgdmFsdWUgZGVwZW5kcyBvbiB0aGUgU3RhY2sgdGhlIHZhbHVlIGlzIGJlaW5nIHVzZWQgaW4uIEJvdGggb2YgdGhlc2VcbiAgICogY2FzZXMgYXJlIHJhcmUsIGFuZCBvbmx5IGV2ZXIgb2NjdXIgZm9yIEFXUyBDb25zdHJ1Y3QgTGlicmFyeSBhdXRob3JzLlxuICAgKi9cbiAgcHVibGljIHN0YXRpYyB1bmNhY2hlZFN0cmluZyhwcm9kdWNlcjogSVN0cmluZ1Byb2R1Y2VyLCBvcHRpb25zOiBMYXp5U3RyaW5nVmFsdWVPcHRpb25zID0ge30pIHtcbiAgICByZXR1cm4gVG9rZW4uYXNTdHJpbmcobmV3IExhenlTdHJpbmcocHJvZHVjZXIsIGZhbHNlKSwgb3B0aW9ucyk7XG4gIH1cblxuICAvKipcbiAgICogRGVmZXIgdGhlIG9uZS10aW1lIGNhbGN1bGF0aW9uIG9mIGEgbnVtYmVyIHZhbHVlIHRvIHN5bnRoZXNpcyB0aW1lXG4gICAqXG4gICAqIFVzZSB0aGlzIGlmIHlvdSB3YW50IHRvIHJlbmRlciBhIG51bWJlciB0byBhIHRlbXBsYXRlIHdob3NlIGFjdHVhbCB2YWx1ZSBkZXBlbmRzIG9uXG4gICAqIHNvbWUgc3RhdGUgbXV0YXRpb24gdGhhdCBtYXkgaGFwcGVuIGFmdGVyIHRoZSBjb25zdHJ1Y3QgaGFzIGJlZW4gY3JlYXRlZC5cbiAgICpcbiAgICogSWYgeW91IGFyZSBzaW1wbHkgbG9va2luZyB0byBmb3JjZSBhIHZhbHVlIHRvIGEgYG51bWJlcmAgdHlwZSBhbmQgZG9uJ3QgbmVlZFxuICAgKiB0aGUgY2FsY3VsYXRpb24gdG8gYmUgZGVmZXJyZWQsIHVzZSBgVG9rZW4uYXNOdW1iZXIoKWAgaW5zdGVhZC5cbiAgICpcbiAgICogQGRlcHJlY2F0ZWQgVXNlIGBMYXp5Lm51bWJlcigpYCBvciBgTGF6eS51bmNhY2hlZE51bWJlcigpYCBpbnN0ZWFkLlxuICAgKi9cbiAgcHVibGljIHN0YXRpYyBudW1iZXJWYWx1ZShwcm9kdWNlcjogSU51bWJlclByb2R1Y2VyKSB7XG4gICAgcmV0dXJuIFRva2VuLmFzTnVtYmVyKG5ldyBMYXp5TnVtYmVyKHByb2R1Y2VyLCBmYWxzZSkpO1xuICB9XG5cbiAgLyoqXG4gICAqIERlZmVyIHRoZSBvbmUtdGltZSBjYWxjdWxhdGlvbiBvZiBhIG51bWJlciB2YWx1ZSB0byBzeW50aGVzaXMgdGltZVxuICAgKlxuICAgKiBVc2UgdGhpcyBpZiB5b3Ugd2FudCB0byByZW5kZXIgYSBudW1iZXIgdG8gYSB0ZW1wbGF0ZSB3aG9zZSBhY3R1YWwgdmFsdWUgZGVwZW5kcyBvblxuICAgKiBzb21lIHN0YXRlIG11dGF0aW9uIHRoYXQgbWF5IGhhcHBlbiBhZnRlciB0aGUgY29uc3RydWN0IGhhcyBiZWVuIGNyZWF0ZWQuXG4gICAqXG4gICAqIElmIHlvdSBhcmUgc2ltcGx5IGxvb2tpbmcgdG8gZm9yY2UgYSB2YWx1ZSB0byBhIGBudW1iZXJgIHR5cGUgYW5kIGRvbid0IG5lZWRcbiAgICogdGhlIGNhbGN1bGF0aW9uIHRvIGJlIGRlZmVycmVkLCB1c2UgYFRva2VuLmFzTnVtYmVyKClgIGluc3RlYWQuXG4gICAqXG4gICAqIFRoZSBpbm5lciBmdW5jdGlvbiB3aWxsIG9ubHkgYmUgaW52b2tlZCBvbmNlLCBhbmQgdGhlIHJlc29sdmVkIHZhbHVlXG4gICAqIGNhbm5vdCBkZXBlbmQgb24gdGhlIFN0YWNrIHRoZSBUb2tlbiBpcyB1c2VkIGluLlxuICAgKi9cbiAgcHVibGljIHN0YXRpYyBudW1iZXIocHJvZHVjZXI6IElTdGFibGVOdW1iZXJQcm9kdWNlcikge1xuICAgIHJldHVybiBUb2tlbi5hc051bWJlcihuZXcgTGF6eU51bWJlcihwcm9kdWNlciwgdHJ1ZSkpO1xuICB9XG5cbiAgLyoqXG4gICAqIERlZmVyIHRoZSBjYWxjdWxhdGlvbiBvZiBhIG51bWJlciB2YWx1ZSB0byBzeW50aGVzaXMgdGltZVxuICAgKlxuICAgKiBVc2Ugb2YgdGhpcyBmdW5jdGlvbiBpcyBub3QgcmVjb21tZW5kZWQ7IHVubGVzcyB5b3Uga25vdyB5b3UgbmVlZCBpdCBmb3Igc3VyZSwgeW91XG4gICAqIHByb2JhYmx5IGRvbid0LiBVc2UgYExhenkubnVtYmVyKClgIGluc3RlYWQuXG4gICAqXG4gICAqIFRoZSBpbm5lciBmdW5jdGlvbiBtYXkgYmUgaW52b2tlZCBtdWx0aXBsZSB0aW1lcyBkdXJpbmcgc3ludGhlc2lzLiBZb3VcbiAgICogc2hvdWxkIG9ubHkgdXNlIHRoaXMgbWV0aG9kIGlmIHRoZSByZXR1cm5lZCB2YWx1ZSBkZXBlbmRzIG9uIHZhcmlhYmxlc1xuICAgKiB0aGF0IG1heSBjaGFuZ2UgZHVyaW5nIHRoZSBBc3BlY3QgYXBwbGljYXRpb24gcGhhc2Ugb2Ygc3ludGhlc2lzLCBvciBpZlxuICAgKiB0aGUgdmFsdWUgZGVwZW5kcyBvbiB0aGUgU3RhY2sgdGhlIHZhbHVlIGlzIGJlaW5nIHVzZWQgaW4uIEJvdGggb2YgdGhlc2VcbiAgICogY2FzZXMgYXJlIHJhcmUsIGFuZCBvbmx5IGV2ZXIgb2NjdXIgZm9yIEFXUyBDb25zdHJ1Y3QgTGlicmFyeSBhdXRob3JzLlxuICAgKi9cbiAgcHVibGljIHN0YXRpYyB1bmNhY2hlZE51bWJlcihwcm9kdWNlcjogSU51bWJlclByb2R1Y2VyKSB7XG4gICAgcmV0dXJuIFRva2VuLmFzTnVtYmVyKG5ldyBMYXp5TnVtYmVyKHByb2R1Y2VyLCBmYWxzZSkpO1xuICB9XG5cbiAgLyoqXG4gICAqIERlZmVyIHRoZSBvbmUtdGltZSBjYWxjdWxhdGlvbiBvZiBhIGxpc3QgdmFsdWUgdG8gc3ludGhlc2lzIHRpbWVcbiAgICpcbiAgICogVXNlIHRoaXMgaWYgeW91IHdhbnQgdG8gcmVuZGVyIGEgbGlzdCB0byBhIHRlbXBsYXRlIHdob3NlIGFjdHVhbCB2YWx1ZSBkZXBlbmRzIG9uXG4gICAqIHNvbWUgc3RhdGUgbXV0YXRpb24gdGhhdCBtYXkgaGFwcGVuIGFmdGVyIHRoZSBjb25zdHJ1Y3QgaGFzIGJlZW4gY3JlYXRlZC5cbiAgICpcbiAgICogSWYgeW91IGFyZSBzaW1wbHkgbG9va2luZyB0byBmb3JjZSBhIHZhbHVlIHRvIGEgYHN0cmluZ1tdYCB0eXBlIGFuZCBkb24ndCBuZWVkXG4gICAqIHRoZSBjYWxjdWxhdGlvbiB0byBiZSBkZWZlcnJlZCwgdXNlIGBUb2tlbi5hc0xpc3QoKWAgaW5zdGVhZC5cbiAgICpcbiAgICogQGRlcHJlY2F0ZWQgVXNlIGBMYXp5Lmxpc3QoKWAgb3IgYExhenkudW5jYWNoZWRMaXN0KClgIGluc3RlYWQuXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIGxpc3RWYWx1ZShwcm9kdWNlcjogSUxpc3RQcm9kdWNlciwgb3B0aW9uczogTGF6eUxpc3RWYWx1ZU9wdGlvbnMgPSB7fSkge1xuICAgIHJldHVybiBUb2tlbi5hc0xpc3QobmV3IExhenlMaXN0KHByb2R1Y2VyLCBmYWxzZSwgb3B0aW9ucyksIG9wdGlvbnMpO1xuICB9XG5cbiAgLyoqXG4gICAqIERlZmVyIHRoZSBjYWxjdWxhdGlvbiBvZiBhIGxpc3QgdmFsdWUgdG8gc3ludGhlc2lzIHRpbWVcbiAgICpcbiAgICogVXNlIG9mIHRoaXMgZnVuY3Rpb24gaXMgbm90IHJlY29tbWVuZGVkOyB1bmxlc3MgeW91IGtub3cgeW91IG5lZWQgaXQgZm9yIHN1cmUsIHlvdVxuICAgKiBwcm9iYWJseSBkb24ndC4gVXNlIGBMYXp5Lmxpc3QoKWAgaW5zdGVhZC5cbiAgICpcbiAgICogVGhlIGlubmVyIGZ1bmN0aW9uIG1heSBiZSBpbnZva2VkIG11bHRpcGxlIHRpbWVzIGR1cmluZyBzeW50aGVzaXMuIFlvdVxuICAgKiBzaG91bGQgb25seSB1c2UgdGhpcyBtZXRob2QgaWYgdGhlIHJldHVybmVkIHZhbHVlIGRlcGVuZHMgb24gdmFyaWFibGVzXG4gICAqIHRoYXQgbWF5IGNoYW5nZSBkdXJpbmcgdGhlIEFzcGVjdCBhcHBsaWNhdGlvbiBwaGFzZSBvZiBzeW50aGVzaXMsIG9yIGlmXG4gICAqIHRoZSB2YWx1ZSBkZXBlbmRzIG9uIHRoZSBTdGFjayB0aGUgdmFsdWUgaXMgYmVpbmcgdXNlZCBpbi4gQm90aCBvZiB0aGVzZVxuICAgKiBjYXNlcyBhcmUgcmFyZSwgYW5kIG9ubHkgZXZlciBvY2N1ciBmb3IgQVdTIENvbnN0cnVjdCBMaWJyYXJ5IGF1dGhvcnMuXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIHVuY2FjaGVkTGlzdChwcm9kdWNlcjogSUxpc3RQcm9kdWNlciwgb3B0aW9uczogTGF6eUxpc3RWYWx1ZU9wdGlvbnMgPSB7fSkge1xuICAgIHJldHVybiBUb2tlbi5hc0xpc3QobmV3IExhenlMaXN0KHByb2R1Y2VyLCBmYWxzZSwgb3B0aW9ucyksIG9wdGlvbnMpO1xuICB9XG5cbiAgLyoqXG4gICAqIERlZmVyIHRoZSBvbmUtdGltZSBjYWxjdWxhdGlvbiBvZiBhIGxpc3QgdmFsdWUgdG8gc3ludGhlc2lzIHRpbWVcbiAgICpcbiAgICogVXNlIHRoaXMgaWYgeW91IHdhbnQgdG8gcmVuZGVyIGEgbGlzdCB0byBhIHRlbXBsYXRlIHdob3NlIGFjdHVhbCB2YWx1ZSBkZXBlbmRzIG9uXG4gICAqIHNvbWUgc3RhdGUgbXV0YXRpb24gdGhhdCBtYXkgaGFwcGVuIGFmdGVyIHRoZSBjb25zdHJ1Y3QgaGFzIGJlZW4gY3JlYXRlZC5cbiAgICpcbiAgICogSWYgeW91IGFyZSBzaW1wbHkgbG9va2luZyB0byBmb3JjZSBhIHZhbHVlIHRvIGEgYHN0cmluZ1tdYCB0eXBlIGFuZCBkb24ndCBuZWVkXG4gICAqIHRoZSBjYWxjdWxhdGlvbiB0byBiZSBkZWZlcnJlZCwgdXNlIGBUb2tlbi5hc0xpc3QoKWAgaW5zdGVhZC5cbiAgICpcbiAgICogVGhlIGlubmVyIGZ1bmN0aW9uIHdpbGwgb25seSBiZSBpbnZva2VkIG9uY2UsIGFuZCB0aGUgcmVzb2x2ZWQgdmFsdWVcbiAgICogY2Fubm90IGRlcGVuZCBvbiB0aGUgU3RhY2sgdGhlIFRva2VuIGlzIHVzZWQgaW4uXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIGxpc3QocHJvZHVjZXI6IElTdGFibGVMaXN0UHJvZHVjZXIsIG9wdGlvbnM6IExhenlMaXN0VmFsdWVPcHRpb25zID0ge30pIHtcbiAgICByZXR1cm4gVG9rZW4uYXNMaXN0KG5ldyBMYXp5TGlzdChwcm9kdWNlciwgdHJ1ZSwgb3B0aW9ucyksIG9wdGlvbnMpO1xuICB9XG5cbiAgLyoqXG4gICAqIERlZmVyIHRoZSBvbmUtdGltZSBjYWxjdWxhdGlvbiBvZiBhbiBhcmJpdHJhcmlseSB0eXBlZCB2YWx1ZSB0byBzeW50aGVzaXMgdGltZVxuICAgKlxuICAgKiBVc2UgdGhpcyBpZiB5b3Ugd2FudCB0byByZW5kZXIgYW4gb2JqZWN0IHRvIGEgdGVtcGxhdGUgd2hvc2UgYWN0dWFsIHZhbHVlIGRlcGVuZHMgb25cbiAgICogc29tZSBzdGF0ZSBtdXRhdGlvbiB0aGF0IG1heSBoYXBwZW4gYWZ0ZXIgdGhlIGNvbnN0cnVjdCBoYXMgYmVlbiBjcmVhdGVkLlxuICAgKlxuICAgKiBAZGVwcmVjYXRlZCBVc2UgYExhenkuYW55KClgIG9yIGBMYXp5LnVuY2FjaGVkQW55KClgIGluc3RlYWQuXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIGFueVZhbHVlKHByb2R1Y2VyOiBJQW55UHJvZHVjZXIsIG9wdGlvbnM6IExhenlBbnlWYWx1ZU9wdGlvbnMgPSB7fSk6IElSZXNvbHZhYmxlIHtcbiAgICByZXR1cm4gbmV3IExhenlBbnkocHJvZHVjZXIsIGZhbHNlLCBvcHRpb25zKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBEZWZlciB0aGUgb25lLXRpbWUgY2FsY3VsYXRpb24gb2YgYW4gYXJiaXRyYXJpbHkgdHlwZWQgdmFsdWUgdG8gc3ludGhlc2lzIHRpbWVcbiAgICpcbiAgICogVXNlIHRoaXMgaWYgeW91IHdhbnQgdG8gcmVuZGVyIGFuIG9iamVjdCB0byBhIHRlbXBsYXRlIHdob3NlIGFjdHVhbCB2YWx1ZSBkZXBlbmRzIG9uXG4gICAqIHNvbWUgc3RhdGUgbXV0YXRpb24gdGhhdCBtYXkgaGFwcGVuIGFmdGVyIHRoZSBjb25zdHJ1Y3QgaGFzIGJlZW4gY3JlYXRlZC5cbiAgICpcbiAgICogVGhlIGlubmVyIGZ1bmN0aW9uIHdpbGwgb25seSBiZSBpbnZva2VkIG9uZSB0aW1lIGFuZCBjYW5ub3QgZGVwZW5kIG9uXG4gICAqIHJlc29sdXRpb24gY29udGV4dC5cbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgYW55KHByb2R1Y2VyOiBJU3RhYmxlQW55UHJvZHVjZXIsIG9wdGlvbnM6IExhenlBbnlWYWx1ZU9wdGlvbnMgPSB7fSk6IElSZXNvbHZhYmxlIHtcbiAgICByZXR1cm4gbmV3IExhenlBbnkocHJvZHVjZXIsIHRydWUsIG9wdGlvbnMpO1xuICB9XG5cbiAgLyoqXG4gICAqIERlZmVyIHRoZSBjYWxjdWxhdGlvbiBvZiBhbiB1bnR5cGVkIHZhbHVlIHRvIHN5bnRoZXNpcyB0aW1lXG4gICAqXG4gICAqIFVzZSBvZiB0aGlzIGZ1bmN0aW9uIGlzIG5vdCByZWNvbW1lbmRlZDsgdW5sZXNzIHlvdSBrbm93IHlvdSBuZWVkIGl0IGZvciBzdXJlLCB5b3VcbiAgICogcHJvYmFibHkgZG9uJ3QuIFVzZSBgTGF6eS5hbnkoKWAgaW5zdGVhZC5cbiAgICpcbiAgICogVGhlIGlubmVyIGZ1bmN0aW9uIG1heSBiZSBpbnZva2VkIG11bHRpcGxlIHRpbWVzIGR1cmluZyBzeW50aGVzaXMuIFlvdVxuICAgKiBzaG91bGQgb25seSB1c2UgdGhpcyBtZXRob2QgaWYgdGhlIHJldHVybmVkIHZhbHVlIGRlcGVuZHMgb24gdmFyaWFibGVzXG4gICAqIHRoYXQgbWF5IGNoYW5nZSBkdXJpbmcgdGhlIEFzcGVjdCBhcHBsaWNhdGlvbiBwaGFzZSBvZiBzeW50aGVzaXMsIG9yIGlmXG4gICAqIHRoZSB2YWx1ZSBkZXBlbmRzIG9uIHRoZSBTdGFjayB0aGUgdmFsdWUgaXMgYmVpbmcgdXNlZCBpbi4gQm90aCBvZiB0aGVzZVxuICAgKiBjYXNlcyBhcmUgcmFyZSwgYW5kIG9ubHkgZXZlciBvY2N1ciBmb3IgQVdTIENvbnN0cnVjdCBMaWJyYXJ5IGF1dGhvcnMuXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIHVuY2FjaGVkQW55KHByb2R1Y2VyOiBJQW55UHJvZHVjZXIsIG9wdGlvbnM6IExhenlBbnlWYWx1ZU9wdGlvbnMgPSB7fSk6IElSZXNvbHZhYmxlIHtcbiAgICByZXR1cm4gbmV3IExhenlBbnkocHJvZHVjZXIsIGZhbHNlLCBvcHRpb25zKTtcbiAgfVxuXG4gIHByaXZhdGUgY29uc3RydWN0b3IoKSB7XG4gIH1cbn1cblxuXG5pbnRlcmZhY2UgSUxhenlQcm9kdWNlcjxBPiB7XG4gIHByb2R1Y2UoY29udGV4dDogSVJlc29sdmVDb250ZXh0KTogQSB8IHVuZGVmaW5lZDtcbn1cblxuYWJzdHJhY3QgY2xhc3MgTGF6eUJhc2U8QT4gaW1wbGVtZW50cyBJUmVzb2x2YWJsZSB7XG4gIHB1YmxpYyByZWFkb25seSBjcmVhdGlvblN0YWNrOiBzdHJpbmdbXTtcbiAgcHJpdmF0ZSBfY2FjaGVkPzogQTtcblxuICBjb25zdHJ1Y3Rvcihwcml2YXRlIHJlYWRvbmx5IHByb2R1Y2VyOiBJTGF6eVByb2R1Y2VyPEE+LCBwcml2YXRlIHJlYWRvbmx5IGNhY2hlOiBib29sZWFuKSB7XG4gICAgLy8gU3RhY2sgdHJhY2UgY2FwdHVyZSBpcyBjb25kaXRpb25uZWQgdG8gYGRlYnVnTW9kZUVuYWJsZWQoKWAsIGJlY2F1c2VcbiAgICAvLyBsYXppZXMgY2FuIGJlIGNyZWF0ZWQgaW4gYSBmYWlybHkgdGhyYXNoeSB3YXksIGFuZCB0aGUgc3RhY2sgdHJhY2VzIGFyZVxuICAgIC8vIGxhcmdlIGFuZCBzbG93IHRvIG9idGFpbjsgYnV0IGFyZSBtb3N0bHkgdXNlZnVsIG9ubHkgd2hlbiBkZWJ1Z2dpbmcgYVxuICAgIC8vIHJlc29sdXRpb24gaXNzdWUuXG4gICAgdGhpcy5jcmVhdGlvblN0YWNrID0gZGVidWdNb2RlRW5hYmxlZCgpXG4gICAgICA/IGNhcHR1cmVTdGFja1RyYWNlKHRoaXMuY29uc3RydWN0b3IpXG4gICAgICA6IFtgRXhlY3V0ZSBhZ2FpbiB3aXRoICR7Q0RLX0RFQlVHfT10cnVlIHRvIGNhcHR1cmUgc3RhY2sgdHJhY2VzYF07XG4gIH1cblxuICBwdWJsaWMgcmVzb2x2ZShjb250ZXh0OiBJUmVzb2x2ZUNvbnRleHQpIHtcbiAgICBpZiAodGhpcy5jYWNoZSkge1xuICAgICAgcmV0dXJuIHRoaXMuX2NhY2hlZCA/PyAodGhpcy5fY2FjaGVkID0gdGhpcy5wcm9kdWNlci5wcm9kdWNlKGNvbnRleHQpKTtcbiAgICB9IGVsc2Uge1xuICAgICAgcmV0dXJuIHRoaXMucHJvZHVjZXIucHJvZHVjZShjb250ZXh0KTtcbiAgICB9XG4gIH1cblxuICBwdWJsaWMgdG9TdHJpbmcoKSB7XG4gICAgcmV0dXJuIFRva2VuLmFzU3RyaW5nKHRoaXMpO1xuICB9XG5cbiAgLyoqXG4gICAqIFR1cm4gdGhpcyBUb2tlbiBpbnRvIEpTT05cbiAgICpcbiAgICogQ2FsbGVkIGF1dG9tYXRpY2FsbHkgd2hlbiBKU09OLnN0cmluZ2lmeSgpIGlzIGNhbGxlZCBvbiBhIFRva2VuLlxuICAgKi9cbiAgcHVibGljIHRvSlNPTigpOiBhbnkge1xuICAgIHJldHVybiAnPHVucmVzb2x2ZWQtbGF6eT4nO1xuICB9XG5cbn1cblxuY2xhc3MgTGF6eVN0cmluZyBleHRlbmRzIExhenlCYXNlPHN0cmluZz4ge1xufVxuXG5jbGFzcyBMYXp5TnVtYmVyIGV4dGVuZHMgTGF6eUJhc2U8bnVtYmVyPiB7XG59XG5cbmNsYXNzIExhenlMaXN0IGV4dGVuZHMgTGF6eUJhc2U8QXJyYXk8c3RyaW5nPj4ge1xuICBjb25zdHJ1Y3Rvcihwcm9kdWNlcjogSUxpc3RQcm9kdWNlciwgY2FjaGU6IGJvb2xlYW4sIHByaXZhdGUgcmVhZG9ubHkgb3B0aW9uczogTGF6eUxpc3RWYWx1ZU9wdGlvbnMgPSB7fSkge1xuICAgIHN1cGVyKHByb2R1Y2VyLCBjYWNoZSk7XG4gIH1cblxuICBwdWJsaWMgcmVzb2x2ZShjb250ZXh0OiBJUmVzb2x2ZUNvbnRleHQpIHtcbiAgICBjb25zdCByZXNvbHZlZCA9IHN1cGVyLnJlc29sdmUoY29udGV4dCk7XG4gICAgaWYgKHJlc29sdmVkPy5sZW5ndGggPT09IDAgJiYgdGhpcy5vcHRpb25zLm9taXRFbXB0eSkge1xuICAgICAgcmV0dXJuIHVuZGVmaW5lZDtcbiAgICB9XG4gICAgcmV0dXJuIHJlc29sdmVkO1xuICB9XG59XG5cbmNsYXNzIExhenlBbnkgZXh0ZW5kcyBMYXp5QmFzZTxhbnk+IHtcbiAgY29uc3RydWN0b3IocHJvZHVjZXI6IElBbnlQcm9kdWNlciwgY2FjaGU6IGJvb2xlYW4sIHByaXZhdGUgcmVhZG9ubHkgb3B0aW9uczogTGF6eUFueVZhbHVlT3B0aW9ucyA9IHt9KSB7XG4gICAgc3VwZXIocHJvZHVjZXIsIGNhY2hlKTtcbiAgfVxuXG4gIHB1YmxpYyByZXNvbHZlKGNvbnRleHQ6IElSZXNvbHZlQ29udGV4dCkge1xuICAgIGNvbnN0IHJlc29sdmVkID0gc3VwZXIucmVzb2x2ZShjb250ZXh0KTtcbiAgICBpZiAoQXJyYXkuaXNBcnJheShyZXNvbHZlZCkgJiYgcmVzb2x2ZWQubGVuZ3RoID09PSAwICYmIHRoaXMub3B0aW9ucy5vbWl0RW1wdHlBcnJheSkge1xuICAgICAgcmV0dXJuIHVuZGVmaW5lZDtcbiAgICB9XG4gICAgcmV0dXJuIHJlc29sdmVkO1xuICB9XG59XG4iXX0=