"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.JenkinsEC2 = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const ec2 = require("@aws-cdk/aws-ec2");
const elbv2 = require("@aws-cdk/aws-elasticloadbalancingv2");
const targets = require("@aws-cdk/aws-elasticloadbalancingv2-targets");
const super_ec2_1 = require("./super-ec2");
const super_ec2_interfaces_1 = require("./super-ec2-interfaces");
;
class JenkinsEC2 extends super_ec2_1.SuperEC2Base {
    constructor(scope, id, props) {
        var _b;
        super(scope, id, props);
        this.userData.addCommands(...this.jenkinsUserData());
        this._addIngressRule(this.defaultSecurityGroup, [22, 8080, 50000]);
        this.loadbalancer = (_b = props.loadbalancer) !== null && _b !== void 0 ? _b : this._setloadbalancer(props.loadbalancerType);
        if (props.domain) {
            this.domain = new super_ec2_interfaces_1.SuperDomain(this, 'superDomain', { ...props.domain, loadbalancer: this.loadbalancer });
            this._setlistener(this.domain.acm);
        }
        else {
            this._set80listener();
        }
    }
    jenkinsUserData() {
        return ['yum install docker -y',
            'systemctl start docker',
            'usermod -aG docker ec2-user',
            'usermod -aG docker ssm-user',
            'chmod +x /var/run/docker.sock',
            'systemctl restart docker && systemctl enable docker',
            'mkdir /home/ec2-user/jenkins-data',
            'docker run --name jks --rm -d -u root -p 8080:8080 -p 50000:50000 -v /home/ec2-user/jenkins-data:/var/jenkins_home -v /var/run/docker.sock:/var/run/docker.sock -v /home/ec2-user:/home jenkinsci/blueocean'];
    }
    ;
    _addIngressRule(SecurityGroup, Ports) {
        Ports.forEach(port => {
            SecurityGroup.addIngressRule(ec2.Peer.anyIpv4(), ec2.Port.tcp(port));
        });
        return SecurityGroup;
    }
    _setloadbalancer(loadbalancerType) {
        switch (loadbalancerType) {
            case super_ec2_interfaces_1.ELBtype.ALB:
                return new elbv2.ApplicationLoadBalancer(this, 'jksALB', {
                    vpc: this.vpc,
                    loadBalancerName: 'jksALB',
                    internetFacing: true,
                });
            case super_ec2_interfaces_1.ELBtype.NLB:
                return new elbv2.NetworkLoadBalancer(this, 'jksNLB', {
                    vpc: this.vpc,
                    loadBalancerName: 'jksNLB',
                    internetFacing: true,
                });
            default: {
                return new elbv2.ApplicationLoadBalancer(this, 'jksALB', {
                    vpc: this.vpc,
                    loadBalancerName: 'jksALB',
                    internetFacing: true,
                });
            }
        }
    }
    _setlistener(acm) {
        const httpslistener = this.loadbalancer.addListener('httpsListener', {
            certificates: [elbv2.ListenerCertificate.fromArn(acm.certificateArn)],
            port: 443,
        });
        if (this.loadbalancer instanceof elbv2.ApplicationLoadBalancer) {
            this.loadbalancer.addListener('httpListener', {
                port: 80,
                open: true,
                defaultAction: elbv2.ListenerAction.redirect({
                    protocol: 'HTTPS',
                    host: '#{host}',
                    path: '/#{path}',
                    query: '/#{query}',
                    port: '443',
                }),
            });
        }
        if (httpslistener instanceof elbv2.ApplicationListener) {
            httpslistener.addTargets('Targets', {
                port: 8080,
                protocol: elbv2.ApplicationProtocol.HTTP,
                targets: [new targets.InstanceTarget(this.instance)],
            });
            httpslistener.connections.allowTo(this.instance, ec2.Port.tcp(8080));
        }
        else if (httpslistener instanceof elbv2.NetworkListener) {
            httpslistener.addTargets('Targets', {
                port: 8080,
                protocol: elbv2.Protocol.TCP,
                targets: [new targets.InstanceTarget(this.instance)],
            });
        }
    }
    _set80listener() {
        const httplistener = this.loadbalancer.addListener('httpListener', {
            port: 80,
        });
        if (httplistener instanceof elbv2.ApplicationListener) {
            httplistener.addTargets('Targets', {
                port: 8080,
                protocol: elbv2.ApplicationProtocol.HTTP,
                targets: [new targets.InstanceTarget(this.instance)],
            });
            httplistener.connections.allowTo(this.instance, ec2.Port.tcp(8080));
        }
        else if (httplistener instanceof elbv2.NetworkListener) {
            httplistener.addTargets('Targets', {
                port: 8080,
                protocol: elbv2.Protocol.TCP,
                targets: [new targets.InstanceTarget(this.instance)],
            });
        }
    }
}
exports.JenkinsEC2 = JenkinsEC2;
_a = JSII_RTTI_SYMBOL_1;
JenkinsEC2[_a] = { fqn: "@cdk-constructs-zone/super-ec2.JenkinsEC2", version: "0.0.323" };
//# sourceMappingURL=data:application/json;base64,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