"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !exports.hasOwnProperty(p)) __createBinding(exports, m, p);
};
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FileSystem = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const os = require("os");
const path = require("path");
const copy_1 = require("./copy");
const fingerprint_1 = require("./fingerprint");
__exportStar(require("./ignore"), exports);
__exportStar(require("./options"), exports);
/**
 * File system utilities.
 */
class FileSystem {
    /**
     * Copies an entire directory structure.
     * @param srcDir Source directory
     * @param destDir Destination directory
     * @param options options
     * @param rootDir Root directory to calculate exclusions from
     */
    static copyDirectory(srcDir, destDir, options = {}, rootDir) {
        jsiiDeprecationWarnings._aws_cdk_core_CopyOptions(options);
        return copy_1.copyDirectory(srcDir, destDir, options, rootDir);
    }
    /**
     * Produces fingerprint based on the contents of a single file or an entire directory tree.
     *
     * The fingerprint will also include:
     * 1. An extra string if defined in `options.extra`.
     * 2. The set of exclude patterns, if defined in `options.exclude`
     * 3. The symlink follow mode value.
     *
     * @param fileOrDirectory The directory or file to fingerprint
     * @param options Fingerprinting options
     */
    static fingerprint(fileOrDirectory, options = {}) {
        jsiiDeprecationWarnings._aws_cdk_core_FingerprintOptions(options);
        return fingerprint_1.fingerprint(fileOrDirectory, options);
    }
    /**
     * Checks whether a directory is empty
     *
     * @param dir The directory to check
     */
    static isEmpty(dir) {
        return fs.readdirSync(dir).length === 0;
    }
    /**
     * The real path of the system temp directory
     */
    static get tmpdir() {
        if (FileSystem._tmpdir) {
            return FileSystem._tmpdir;
        }
        FileSystem._tmpdir = fs.realpathSync(os.tmpdir());
        return FileSystem._tmpdir;
    }
    /**
     * Creates a unique temporary directory in the **system temp directory**.
     *
     * @param prefix A prefix for the directory name. Six random characters
     * will be generated and appended behind this prefix.
     */
    static mkdtemp(prefix) {
        return fs.mkdtempSync(path.join(FileSystem.tmpdir, prefix));
    }
}
exports.FileSystem = FileSystem;
_a = JSII_RTTI_SYMBOL_1;
FileSystem[_a] = { fqn: "@aws-cdk/core.FileSystem", version: "1.151.0" };
//# sourceMappingURL=data:application/json;base64,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