"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AssetManifestArtifact = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const cloud_artifact_1 = require("../cloud-artifact");
/**
 * Asset manifest is a description of a set of assets which need to be built and published
 */
class AssetManifestArtifact extends cloud_artifact_1.CloudArtifact {
    constructor(assembly, name, artifact) {
        var _b;
        super(assembly, name, artifact);
        jsiiDeprecationWarnings._aws_cdk_cx_api_CloudAssembly(assembly);
        const properties = (this.manifest.properties || {});
        if (!properties.file) {
            throw new Error('Invalid AssetManifestArtifact. Missing "file" property');
        }
        this.file = path.resolve(this.assembly.directory, properties.file);
        this.requiresBootstrapStackVersion = (_b = properties.requiresBootstrapStackVersion) !== null && _b !== void 0 ? _b : 1;
        this.bootstrapStackVersionSsmParameter = properties.bootstrapStackVersionSsmParameter;
    }
}
exports.AssetManifestArtifact = AssetManifestArtifact;
_a = JSII_RTTI_SYMBOL_1;
AssetManifestArtifact[_a] = { fqn: "@aws-cdk/cx-api.AssetManifestArtifact", version: "1.150.0" };
//# sourceMappingURL=data:application/json;base64,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